/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.Tango.PipeWriteType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tango.DeviceState;
import org.tango.attribute.AttributeTangoType;
import org.tango.server.DeviceBehaviorObject;
import org.tango.server.annotation.Attribute;
import org.tango.server.annotation.AttributeProperties;
import org.tango.server.annotation.Pipe;
import org.tango.server.annotation.StateMachine;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.pipe.PipeConfiguration;
import org.tango.utils.DevFailedUtils;

final class BuilderUtils {
    public static final String IS = "is";
    public static final String INIT_ERROR = "INIT_ERROR";
    static final String METHOD_NOT_FOUND = " method not found";
    public static final String SET = "set";
    public static final String GET = "get";
    private static final String MUST_NOT_BE_STATIC = " must not be static";

    private BuilderUtils() {
    }

    static String getAttributeName(String fieldName, Attribute annot) {
        String attributeName = null;
        attributeName = annot.name().equals("") ? fieldName : annot.name();
        return attributeName;
    }

    static String getPipeName(String fieldName, Pipe annot) {
        String attributeName = null;
        attributeName = annot.name().equals("") ? fieldName : annot.name();
        return attributeName;
    }

    static void checkStatic(Field field) throws DevFailed {
        if (Modifier.isStatic(field.getModifiers())) {
            throw DevFailedUtils.newDevFailed("TANGO_BUILD_FAILED", field + MUST_NOT_BE_STATIC);
        }
    }

    static AttributeConfiguration getAttributeConfiguration(Class<?> type, Method getter, Method setter, Attribute annot, String attributeName) throws DevFailed {
        AttributeConfiguration config = new AttributeConfiguration();
        config.setName(attributeName);
        config.setDispLevel(DispLevel.from_int(annot.displayLevel()));
        config.setMaxX(annot.maxDimX());
        config.setMaxY(annot.maxDimY());
        config.setType(type);
        config.setMemorized(annot.isMemorized());
        config.setMemorizedAtInit(annot.isMemorizedAtInit());
        config.setPolled(annot.isPolled());
        config.setPollingPeriod(annot.pollingPeriod());
        config.setPushDataReady(annot.pushDataReady());
        config.setPushChangeEvent(annot.pushChangeEvent());
        config.setCheckChangeEvent(annot.checkChangeEvent());
        config.setPushArchiveEvent(annot.pushArchiveEvent());
        config.setCheckArchivingEvent(annot.checkArchivingEvent());
        if (setter == null) {
            config.setWritable(AttrWriteType.READ);
        } else if (getter == null) {
            config.setWritable(AttrWriteType.WRITE);
        } else {
            config.setWritable(AttrWriteType.READ_WRITE);
        }
        return config;
    }

    static PipeConfiguration getPipeConfiguration(Class<?> type, Method getter, Method setter, Pipe annot, String pipeName) throws DevFailed {
        PipeConfiguration config = new PipeConfiguration(pipeName);
        if (setter == null) {
            config.setWriteType(PipeWriteType.PIPE_READ);
        } else {
            config.setWriteType(PipeWriteType.PIPE_READ_WRITE);
        }
        config.setDisplayLevel(DispLevel.from_int(annot.displayLevel()));
        if (annot.label().equals("")) {
            config.setLabel(pipeName);
        } else {
            config.setLabel(annot.label());
        }
        config.setDescription(annot.description());
        return config;
    }

    static AttributePropertiesImpl setEnumLabelProperty(Class<?> type, AttributePropertiesImpl props) throws DevFailed {
        if (AttributeTangoType.getTypeFromClass(type).equals((Object)AttributeTangoType.DEVENUM)) {
            ?[] enumValues = type.getEnumConstants();
            String[] enumLabels = new String[enumValues.length];
            for (int i = 0; i < enumLabels.length; ++i) {
                enumLabels[i] = enumValues[i].toString();
            }
            props.setEnumLabels(enumLabels, false);
        }
        return props;
    }

    static AttributePropertiesImpl getAttributeProperties(AccessibleObject method, String attributeName, Class<?> attributeScalarType) throws DevFailed {
        AttributePropertiesImpl props = new AttributePropertiesImpl();
        if (method.isAnnotationPresent(AttributeProperties.class)) {
            AttributeProperties annotProp = method.getAnnotation(AttributeProperties.class);
            if (annotProp.label().equals("")) {
                props.setLabel(attributeName);
            } else {
                props.setLabel(annotProp.label());
            }
            props.setDescription(annotProp.description());
            props.setDisplayUnit(annotProp.displayUnit());
            props.setUnit(annotProp.unit());
            props.setStandardUnit(annotProp.standardUnit());
            String annotFormat = annotProp.format();
            if (annotFormat.isEmpty()) {
                props.setDefaultFormat(attributeScalarType);
            } else {
                props.setFormat(annotProp.format());
            }
            props.setMaxAlarm(annotProp.maxAlarm());
            props.setMinAlarm(annotProp.minAlarm());
            props.setMaxValue(annotProp.maxValue());
            props.setMinValue(annotProp.minValue());
            props.setMinWarning(annotProp.minWarning());
            props.setMaxWarning(annotProp.maxWarning());
            props.setDeltaT(annotProp.deltaTime());
            props.setDeltaVal(annotProp.deltaValue());
            props.setEventAbsChange(annotProp.changeEventAbsolute());
            props.setEventRelChange(annotProp.changeEventRelative());
            props.setEventPeriod(annotProp.periodicEvent());
            props.setArchivingEventRelChange(annotProp.archiveEventRelative());
            props.setArchivingEventAbsChange(annotProp.archiveEventAbsolute());
            props.setArchivingEventPeriod(annotProp.archiveEventPeriod());
            props.setRootAttribute(annotProp.rootAttribute());
        } else {
            props.setLabel(attributeName);
            props.setDefaultFormat(attributeScalarType);
        }
        return props;
    }

    static void setStateMachine(AccessibleObject annotatedObject, DeviceBehaviorObject behavior) {
        StateMachine stateMach = annotatedObject.getAnnotation(StateMachine.class);
        if (stateMach != null) {
            if (stateMach.endState() != DeviceState.UNKNOWN) {
                behavior.setEndState(stateMach.endState());
            }
            if (stateMach.deniedStates().length != 0) {
                behavior.setDeniedStates(stateMach.deniedStates());
            }
        }
    }
}

