/*
 * Decompiled with CFR 0.152.
 */
package org.tango.script.evalution;

import fr.esrf.Tango.DevFailed;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.script.evalution.IContextVariable;
import org.tango.utils.DevFailedUtils;

public final class BooleanExpressionValidator {
    private static Logger logger = LoggerFactory.getLogger(BooleanExpressionValidator.class);
    private static final String RESULT_VARIABLE = "context";
    private final List<IContextVariable> variables;
    private final String contextCondition;

    public BooleanExpressionValidator(String contextCondition, List<IContextVariable> variables) {
        this.contextCondition = contextCondition;
        this.variables = new ArrayList<IContextVariable>(variables);
    }

    public boolean isExpressionTrue() throws DevFailed {
        boolean context = true;
        if (this.variables.size() > 0) {
            try {
                context = false;
                Context cx = Context.enter();
                ScriptableObject scope = cx.initStandardObjects();
                for (IContextVariable variable : this.variables) {
                    Object value = variable.getValue();
                    Object m = Context.javaToJS(value, scope);
                    ScriptableObject.putProperty((Scriptable)scope, variable.getName(), m);
                    logger.debug("put value {} for {}", value, (Object)variable);
                }
                Object sc = Context.javaToJS(context, scope);
                ScriptableObject.putProperty((Scriptable)scope, RESULT_VARIABLE, sc);
                String scriptText = "context = " + this.contextCondition + ";";
                logger.debug("script: {} ", (Object)scriptText);
                cx.evaluateString(scope, scriptText, "test", 1, null);
                context = (Boolean)ScriptableObject.getProperty((Scriptable)scope, RESULT_VARIABLE);
                logger.debug("result is {}", (Object)context);
            }
            catch (EcmaError e) {
                throw DevFailedUtils.newDevFailed("EVALUATION_ERROR", e.details());
            }
            finally {
                Context.exit();
            }
        }
        return context;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        sb.append("contextCondition", this.contextCondition);
        sb.append("variables", this.variables);
        return sb.toString();
    }
}

