/*
 * Decompiled with CFR 0.152.
 */
package org.tango.orb;

import java.net.InetAddress;
import java.net.Socket;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.ETF.Connection;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerRequestInterceptor
extends LocalObject
implements org.omg.PortableInterceptor.ServerRequestInterceptor {
    private static final String GIOP_TCP = "giop:tcp:";
    private final Logger logger = LoggerFactory.getLogger(ServerRequestInterceptor.class);
    private static final long serialVersionUID = 1L;
    private final ThreadLocal<String> clientHostName = new ThreadLocal();
    private volatile ThreadLocal<String> giopHostAddress = new ThreadLocal();
    private volatile ThreadLocal<String> clientIPAddress = new ThreadLocal();
    private static final ServerRequestInterceptor INSTANCE = new ServerRequestInterceptor();

    private ServerRequestInterceptor() {
    }

    @Override
    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        try {
            if (ri instanceof ServerRequestInfoImpl) {
                ServerRequestInfoImpl infoImpl = (ServerRequestInfoImpl)ri;
                Connection connection = infoImpl.getConnection().getTransport();
                if (connection instanceof ServerIIOPConnection) {
                    ServerIIOPConnection connex = (ServerIIOPConnection)connection;
                    Socket sock = connex.getSocket();
                    if (sock != null) {
                        this.clientIPAddress.set(sock.getInetAddress().getHostAddress());
                        int remotePort = sock.getPort();
                        this.clientHostName.set(InetAddress.getByName(this.clientIPAddress.get()).getCanonicalHostName());
                        this.giopHostAddress.set(GIOP_TCP + this.clientIPAddress.get() + ":" + remotePort);
                    }
                } else {
                    InetAddress addr = InetAddress.getLocalHost();
                    this.clientIPAddress.set(addr.getHostAddress());
                    this.clientHostName.set(addr.getCanonicalHostName());
                    this.giopHostAddress.set(GIOP_TCP + this.clientIPAddress.get());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("", e);
        }
    }

    @Override
    public void send_reply(ServerRequestInfo ri) {
    }

    @Override
    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public String name() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void destroy() {
    }

    public String getClientHostName() {
        return this.clientHostName.get();
    }

    public String getClientIPAddress() {
        return this.clientIPAddress.get();
    }

    public String getGiopHostAddress() {
        return this.giopHostAddress.get();
    }

    public static ServerRequestInterceptor getInstance() {
        return INSTANCE;
    }
}

