/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.client.database.cache.DeviceCache;
import org.tango.utils.CaseInsensitiveMap;

public final class ClassCache {
    private final Map<String, String[]> propertiesCache = new CaseInsensitiveMap<String[]>();
    private final String name;
    private final Map<String, DeviceCache> deviceCaches = new CaseInsensitiveMap<DeviceCache>();

    ClassCache(String name) {
        this.name = name;
    }

    public void addProperty(String propertyName, String[] propertyValue) {
        this.propertiesCache.put(propertyName, propertyValue);
    }

    public void addDeviceCache(DeviceCache cache) {
        this.deviceCaches.put(cache.getName(), cache);
    }

    public Map<String, String[]> getPropertiesCache() {
        return new HashMap<String, String[]>(this.propertiesCache);
    }

    public DeviceCache getDeviceCache(String deviceName) {
        return this.deviceCaches.get(deviceName);
    }

    public void addProperties(Map<String, String[]> properties) {
        this.propertiesCache.putAll(properties);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

