/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database;

import fr.esrf.Tango.DevVarLongStringArray;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class DeviceImportInfo {
    private final String name;
    private final String ior;
    private final boolean exported;
    private final int pid;
    private final String server;

    public DeviceImportInfo(String name, boolean exported, String ior, String server, int pid) {
        this.name = name;
        this.ior = ior;
        this.exported = exported;
        this.server = server;
        this.pid = pid;
    }

    public DeviceImportInfo(DevVarLongStringArray info) {
        this.name = info.svalue[0];
        this.ior = info.svalue[1];
        this.exported = info.lvalue[0] == 1;
        this.pid = info.lvalue.length > 1 ? info.lvalue[1] : 0;
        this.server = info.svalue.length > 3 ? info.svalue[3] : "unknown";
    }

    public String toString() {
        ToStringBuilder strBuilder = new ToStringBuilder(this);
        strBuilder.append("IOR", this.ior);
        strBuilder.append("server", this.server);
        strBuilder.append("PID", this.pid);
        strBuilder.append("exported", this.exported);
        return strBuilder.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getIor() {
        return this.ior;
    }

    public boolean isExported() {
        return this.exported;
    }

    public int getPid() {
        return this.pid;
    }

    public String getServer() {
        return this.server;
    }
}

