/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database;

import fr.esrf.Tango.DevFailed;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.tango.TangoHostManager;
import org.tango.client.database.Database;
import org.tango.client.database.FileTangoDB;
import org.tango.client.database.ITangoDB;

public final class DatabaseFactory {
    private static Map<String, ITangoDB> databaseMap = new HashMap<String, ITangoDB>();
    private static ITangoDB fileDatabase;
    private static boolean useDb;

    private DatabaseFactory() {
    }

    public static synchronized ITangoDB getDatabase(String host, String port) throws DevFailed {
        ITangoDB dbase;
        if (useDb) {
            String tangoHost = host + ":" + port;
            if (databaseMap.containsKey(tangoHost)) {
                return databaseMap.get(tangoHost);
            }
            dbase = new Database(host, port);
            databaseMap.put(tangoHost, dbase);
        } else {
            dbase = fileDatabase;
        }
        return dbase;
    }

    public static synchronized ITangoDB getDatabase() throws DevFailed {
        ITangoDB tangoDb = null;
        if (useDb) {
            String tangoHost = TangoHostManager.getFirstTangoHost();
            if (databaseMap.containsKey(tangoHost)) {
                tangoDb = databaseMap.get(tangoHost);
            } else {
                DevFailed lastError = null;
                Map<String, String> tangoHostMap = TangoHostManager.getTangoHostPortMap();
                for (Map.Entry<String, String> entry : tangoHostMap.entrySet()) {
                    try {
                        lastError = null;
                        tangoDb = new Database(entry.getKey(), entry.getValue());
                        databaseMap.put(tangoHost, tangoDb);
                        break;
                    }
                    catch (DevFailed e) {
                        lastError = e;
                    }
                }
                if (lastError != null) {
                    throw lastError;
                }
            }
        } else {
            tangoDb = fileDatabase;
        }
        return tangoDb;
    }

    public static boolean isUseDb() {
        return useDb;
    }

    public static void setDbFile(File dbFile, String[] devices, String className) throws DevFailed {
        useDb = false;
        fileDatabase = new FileTangoDB(dbFile, Arrays.copyOf(devices, devices.length), className);
    }

    public static void setNoDbDevices(String[] devices, String className) {
        useDb = false;
        fileDatabase = new FileTangoDB(Arrays.copyOf(devices, devices.length), className);
    }

    public static void setUseDb(boolean useDb) {
        DatabaseFactory.useDb = useDb;
    }

    static {
        useDb = true;
    }
}

