/*
 * Decompiled with CFR 0.152.
 */
package org.tango;

import fr.esrf.Tango.DevFailed;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.utils.DevFailedUtils;

public final class TangoHostManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TangoHostManager.class);
    public static final Map<String, String> TANGO_HOST_PORT_MAP = new HashMap<String, String>();
    public static final String TANGO_HOST_NAME = "TANGO_HOST";
    private static final String TANGO_HOST = System.getProperty("TANGO_HOST", System.getenv("TANGO_HOST"));
    private static boolean isChecked = false;

    private TangoHostManager() {
    }

    public static String getTangoHost() {
        return TANGO_HOST;
    }

    private static void checkTangoHost() throws DevFailed {
        if (!isChecked) {
            LOGGER.debug("TANGO_HOST is {} ", (Object)TANGO_HOST);
            if (TANGO_HOST_PORT_MAP.isEmpty()) {
                if (TANGO_HOST == null) {
                    throw DevFailedUtils.newDevFailed("CONFIG_ERROR", "tango host not defined");
                }
                if (TANGO_HOST.indexOf(58) < 0) {
                    throw DevFailedUtils.newDevFailed("CONFIG_ERROR", "tango host not defined correctly. Must be host:port");
                }
                StringTokenizer stk = TANGO_HOST.indexOf(44) > 0 ? new StringTokenizer(TANGO_HOST, ",") : new StringTokenizer(TANGO_HOST);
                while (stk.hasMoreTokens()) {
                    String th = stk.nextToken();
                    StringTokenizer stk2 = new StringTokenizer(th, ":");
                    String host = stk2.nextToken();
                    String port = stk2.nextToken();
                    TANGO_HOST_PORT_MAP.put(host, port);
                }
            }
            isChecked = true;
        }
    }

    public static String getFirstTangoHost() throws DevFailed {
        TangoHostManager.checkTangoHost();
        Map.Entry<String, String> entrySet = TANGO_HOST_PORT_MAP.entrySet().iterator().next();
        return entrySet.getKey() + ":" + entrySet.getValue();
    }

    public static String getFirstHost() throws DevFailed {
        TangoHostManager.checkTangoHost();
        Map.Entry<String, String> entrySet = TANGO_HOST_PORT_MAP.entrySet().iterator().next();
        return entrySet.getKey();
    }

    public static String getFirstPort() throws DevFailed {
        TangoHostManager.checkTangoHost();
        Map.Entry<String, String> entrySet = TANGO_HOST_PORT_MAP.entrySet().iterator().next();
        return entrySet.getValue();
    }

    public static String getFirstFullTangoHost() throws DevFailed {
        String TANGO_HOST_ERROR = "API_GetTangoHostFailed";
        String host = TangoHostManager.getFirstHost();
        try {
            InetAddress iadd = InetAddress.getByName(host);
            host = iadd.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw DevFailedUtils.newDevFailed("API_GetTangoHostFailed", e.toString());
        }
        return host + ':' + TangoHostManager.getFirstPort();
    }

    public static Map<String, String> getTangoHostPortMap() {
        return new HashMap<String, String>(TANGO_HOST_PORT_MAP);
    }
}

