/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.remoting.rmi;

import com.thoughtworks.proxy.ProxyFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Iterator;
import org.nanocontainer.remoting.rmi.ByRefKey;
import org.nanocontainer.remoting.rmi.Invocation;
import org.nanocontainer.remoting.rmi.KeyHolder;
import org.nanocontainer.remoting.rmi.NanoNamingImpl;
import org.nanocontainer.remoting.rmi.RemoteInterceptor;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public class RemoteInterceptorImpl
extends UnicastRemoteObject
implements RemoteInterceptor {
    private final transient ByRefKey key;
    private final PicoContainer pico;
    private final ProxyFactory proxyFactory;
    private final Registry registry;

    public RemoteInterceptorImpl(Registry registry, PicoContainer pico, ByRefKey key, ProxyFactory proxyFactory) throws RemoteException {
        if (registry == null) {
            throw new NullPointerException("registry");
        }
        this.registry = registry;
        this.pico = pico;
        this.proxyFactory = proxyFactory;
        this.key = key;
    }

    public Object invoke(Invocation invocation) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, RemoteException {
        Object target = this.pico.getComponentInstance(this.key);
        Object[] args = invocation.getArgs();
        invocation.setArgs(this.unwrap(args));
        Object resultOfInvocation = invocation.invoke(target);
        ComponentAdapter componentAdapter = this.getComponentAdapterByInstance(this.pico, resultOfInvocation);
        if (componentAdapter != null && componentAdapter.getComponentKey() instanceof ByRefKey) {
            NanoNamingImpl naming = new NanoNamingImpl(this.registry, this.pico, this.proxyFactory);
            ByRefKey key = (ByRefKey)componentAdapter.getComponentKey();
            return naming.lookup(key);
        }
        return resultOfInvocation;
    }

    private Object[] unwrap(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.unwrap(args[i]);
        }
        return args;
    }

    private Object unwrap(Object arg) {
        if (arg instanceof KeyHolder && this.proxyFactory.isProxyClass(arg.getClass())) {
            KeyHolder keyHolder = (KeyHolder)arg;
            ByRefKey key = keyHolder.getKey();
            arg = this.pico.getComponentInstance(key);
        }
        return arg;
    }

    public void bind(ComponentAdapter componentAdapter) throws RemoteException {
        ByRefKey byRefKey = (ByRefKey)componentAdapter.getComponentKey();
        Serializable key = byRefKey.getValue();
        this.registry.rebind(key.toString(), this);
    }

    private ComponentAdapter getComponentAdapterByInstance(PicoContainer pico, Object componentInstance) {
        Collection componentAdapters = pico.getComponentAdapters();
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentAdapter.getComponentInstance(pico).equals(componentInstance)) continue;
            return componentAdapter;
        }
        return null;
    }
}

