/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.config.JacORBConfiguration;
import org.jacorb.ir.Container;
import org.jacorb.ir.IRObject;
import org.jacorb.ir.PrimitiveDef;
import org.omg.CORBA.AbstractInterfaceDef;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.Any;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainerPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExtInitializer;
import org.omg.CORBA.ExtValueDef;
import org.omg.CORBA.FixedDef;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.LocalInterfaceDef;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PrimitiveDefHelper;
import org.omg.CORBA.PrimitiveDefPOATie;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.RepositoryOperations;
import org.omg.CORBA.RepositoryPOATie;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.WstringDef;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.slf4j.Logger;

public class RepositoryImpl
extends IRObject
implements RepositoryOperations,
Configurable {
    private Container[] containers;
    private Container delegate;
    private POA poa;
    private Configuration configuration = null;
    private Logger logger = null;
    private boolean patchPragmaPrefix;

    public RepositoryImpl(String classpath, String outfile, URLClassLoader loader, ORB orb) throws Exception {
        this.def_kind = DefinitionKind.dk_Repository;
        this.name = "Repository";
        StringTokenizer strtok = new StringTokenizer(classpath, File.pathSeparator);
        String[] paths = new String[strtok.countTokens()];
        this.containers = new Container[paths.length];
        this.configure(JacORBConfiguration.getConfiguration(null, orb, false));
        this.poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
        Policy[] policies = new Policy[]{this.poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), this.poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
        POA ifrPOA = this.poa.create_POA("InterfaceRepositoryPOA", this.poa.the_POAManager(), policies);
        for (int i = 0; i < policies.length; ++i) {
            policies[i].destroy();
        }
        RepositoryPOATie servant = new RepositoryPOATie(this);
        ifrPOA.activate_object_with_id("IfR".getBytes(), servant);
        Repository myRef = RepositoryHelper.narrow(ifrPOA.servant_to_reference(servant));
        int i = 0;
        while (strtok.hasMoreTokens()) {
            paths[i] = strtok.nextToken();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("found path: " + paths[i]);
            }
            this.containers[i] = new Container(this, paths[i], null, loader, this.poa, this.logger);
            ++i;
        }
        this.delegate = this.containers[0];
        PrintWriter out = new PrintWriter(new FileOutputStream(outfile), true);
        out.println(orb.object_to_string(myRef));
        this.setReference(myRef);
        out.close();
        ifrPOA.the_POAManager().activate();
        this.poa.the_POAManager().activate();
        if (this.logger.isInfoEnabled()) {
            URL[] urls = loader.getURLs();
            StringBuffer sb = new StringBuffer("IR configured for class path: ");
            for (int i2 = 0; i2 < urls.length; ++i2) {
                sb.append(urls[i2].toString()).append("\n");
            }
            this.logger.info(sb.toString());
        }
    }

    @Override
    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("org.jacorb.ir");
        this.patchPragmaPrefix = this.configuration.getAttributeAsBoolean("jacorb.ir.patch_pragma_prefix", false);
    }

    private String idToScopedName(String id) {
        return RepositoryImpl.idToScopedName(id, this.patchPragmaPrefix);
    }

    public static String idToScopedName(String id, boolean patchPrefix) {
        int firstSeparator;
        String scoped = "";
        if (!id.startsWith("IDL:") || !id.endsWith(":1.0")) {
            return null;
        }
        String base = id.substring(id.indexOf(58) + 1, id.lastIndexOf(58)).replace(fileSeparator, '/');
        if (base.startsWith("omg.org")) {
            base = "org/omg" + base.substring(7);
        }
        if (patchPrefix && (firstSeparator = base.indexOf(47)) >= 0) {
            base = base.substring(0, firstSeparator).replace('.', '/') + "/" + base.substring(firstSeparator + 1);
        }
        StringTokenizer strtok = new StringTokenizer(base, "/");
        int i = 0;
        while (strtok.hasMoreTokens()) {
            scoped = scoped + "::" + strtok.nextToken();
            ++i;
        }
        return scoped;
    }

    @Override
    public Contained lookup_id(String search_id) {
        String name;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup_id: " + search_id);
        }
        if ((name = this.idToScopedName(search_id)) == null) {
            return null;
        }
        return this.lookup(name);
    }

    @Override
    public org.omg.CORBA.PrimitiveDef get_primitive(PrimitiveKind kind) {
        try {
            return PrimitiveDefHelper.narrow(this.poa.servant_to_reference(new PrimitiveDefPOATie(new PrimitiveDef(kind.value()))));
        }
        catch (Exception e) {
            this.logger.error("unexpected exception", e);
            return null;
        }
    }

    @Override
    public StringDef create_string(int bound) {
        return null;
    }

    @Override
    public WstringDef create_wstring(int bound) {
        return null;
    }

    @Override
    public FixedDef create_fixed(short digits, short scale) {
        return null;
    }

    @Override
    public SequenceDef create_sequence(int bound, IDLType element_type) {
        return null;
    }

    @Override
    public ArrayDef create_array(int length, IDLType element_type) {
        return null;
    }

    @Override
    public TypeCode get_canonical_typecode(TypeCode tc) {
        return null;
    }

    @Override
    public Contained lookup(String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup : " + name);
        }
        Contained result = null;
        for (int i = 0; i < this.containers.length && (result = this.containers[i].lookup(name)) == null; ++i) {
        }
        return result;
    }

    @Override
    public Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup_name: " + search_name);
        }
        Contained[] result = null;
        Vector<Contained[]> intermediate = new Vector<Contained[]>();
        for (int i = 0; i < this.containers.length; ++i) {
            intermediate.addElement(this.containers[i].lookup_name(search_name, levels_to_search, limit_type, exclude_inherited));
        }
        int size = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            size += ((Object[])intermediate.elementAt(i)).length;
        }
        result = new Contained[size];
        int start = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            Contained[] src = (Contained[])intermediate.elementAt(i);
            System.arraycopy(src, 0, result, start, src.length);
            start += src.length;
        }
        return result;
    }

    @Override
    public Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited) {
        Contained[] result = null;
        Vector<Contained[]> intermediate = new Vector<Contained[]>();
        for (int i = 0; i < this.containers.length; ++i) {
            intermediate.addElement(this.containers[i].contents(limit_type, exclude_inherited));
        }
        int size = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            size += ((Object[])intermediate.elementAt(i)).length;
        }
        result = new Contained[size];
        int start = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            Contained[] src = (Contained[])intermediate.elementAt(i);
            System.arraycopy(src, 0, result, start, src.length);
            start += src.length;
        }
        return result;
    }

    @Override
    public Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs) {
        Contained[] c = this.contents(limit_type, exclude_inherited);
        int size = max_returned_objs > c.length ? max_returned_objs : c.length;
        Description[] result = new Description[size];
        for (int i = 0; i < size; ++i) {
            result[i] = new Description();
            org.omg.CORBA.ContainedPackage.Description cd_descr = c[i].describe();
            result[i].contained_object = c[i];
            result[i].kind = cd_descr.kind;
            result[i].value = cd_descr.value;
        }
        return result;
    }

    @Override
    void define() {
    }

    public void loadContents() {
        int i;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Repository loads contents...");
        }
        for (i = 0; i < this.containers.length; ++i) {
            this.containers[i].loadContents();
        }
        for (i = 0; i < this.containers.length; ++i) {
            this.containers[i].define();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Repository contents loaded");
        }
    }

    @Override
    public ModuleDef create_module(String id, String name, String version2) {
        return this.delegate.create_module(id, name, version2);
    }

    @Override
    public ConstantDef create_constant(String id, String name, String version2, IDLType type, Any value) {
        return this.delegate.create_constant(id, name, version2, type, value);
    }

    @Override
    public StructDef create_struct(String id, String name, String version2, StructMember[] members) {
        return this.delegate.create_struct(id, name, version2, members);
    }

    @Override
    public UnionDef create_union(String id, String name, String version2, IDLType discriminator_type, UnionMember[] members) {
        return this.delegate.create_union(id, name, version2, discriminator_type, members);
    }

    @Override
    public EnumDef create_enum(String id, String name, String version2, String[] members) {
        return this.delegate.create_enum(id, name, version2, members);
    }

    @Override
    public AliasDef create_alias(String id, String name, String version2, IDLType original_type) {
        return this.delegate.create_alias(id, name, version2, original_type);
    }

    @Override
    public ExceptionDef create_exception(String id, String name, String version2, StructMember[] member) {
        return this.delegate.create_exception(id, name, version2, member);
    }

    @Override
    public InterfaceDef create_interface(String id, String name, String version2, InterfaceDef[] base_interfaces) {
        return this.delegate.create_interface(id, name, version2, base_interfaces);
    }

    @Override
    public ValueBoxDef create_value_box(String id, String name, String version2, IDLType type) {
        return this.delegate.create_value_box(id, name, version2, type);
    }

    @Override
    public ValueDef create_value(String id, String name, String version2, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers) {
        return this.delegate.create_value(id, name, version2, is_custom, is_abstract, base_value, is_truncatable, abstract_base_values, supported_interfaces, initializers);
    }

    @Override
    public NativeDef create_native(String id, String name, String version2) {
        return this.delegate.create_native(id, name, version2);
    }

    @Override
    public void destroy() {
        this.delegate.destroy();
    }

    @Override
    public AbstractInterfaceDef create_abstract_interface(String id, String name, String version2, AbstractInterfaceDef[] baseInterfaces) {
        throw new NO_IMPLEMENT("NYI");
    }

    @Override
    public ExtValueDef create_ext_value(String id, String name, String version2, boolean isCustom, boolean isAbstract, ValueDef baseValue, boolean isTruncatable, ValueDef[] abstractBaseValues, InterfaceDef[] supportedInterfaces, ExtInitializer[] initializers) {
        throw new NO_IMPLEMENT("NYI");
    }

    @Override
    public LocalInterfaceDef create_local_interface(String id, String name, String version2, InterfaceDef[] baseInterfaces) {
        throw new NO_IMPLEMENT("NYI");
    }
}

