/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.AttrDecl;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definition;
import org.jacorb.idl.Definitions;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.InitDecl;
import org.jacorb.idl.Interface;
import org.jacorb.idl.MemberList;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.OpDecl;
import org.jacorb.idl.Operation;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.StateMember;
import org.jacorb.idl.Truncatable;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.ValueAbsDecl;
import org.jacorb.idl.ValueInheritanceSpec;
import org.jacorb.idl.parser;

public class ValueDecl
extends Value {
    private MemberList stateMembers = new MemberList(ValueDecl.new_num());
    private List operations = new ArrayList();
    private List exports = new ArrayList();
    private List factories = new ArrayList();
    private ValueInheritanceSpec inheritanceSpec;
    private boolean isCustomMarshalled = false;
    private boolean hasStatefulBases = false;
    private boolean hasBody = false;

    public ValueDecl(int num) {
        super(num);
    }

    public void setValueElements(Definitions d) {
        this.hasBody = true;
        Iterator i = d.v.iterator();
        while (i.hasNext()) {
            Declaration dec = ((Definition)i.next()).get_declaration();
            dec.setPackage(this.name);
            if (dec instanceof StateMember) {
                this.stateMembers.v.add(dec);
                continue;
            }
            if (dec instanceof OpDecl) {
                this.operations.add(dec);
                continue;
            }
            if (dec instanceof InitDecl) {
                this.factories.add(dec);
                continue;
            }
            this.exports.add(dec);
        }
        this.stateMembers.setContainingType(this);
        this.stateMembers.setPackage(this.name);
        this.stateMembers.setEnclosingSymbol(this);
        i = this.operations.iterator();
        while (i.hasNext()) {
            ((OpDecl)i.next()).setEnclosingSymbol(this);
        }
        i = this.exports.iterator();
        while (i.hasNext()) {
            ((IdlSymbol)i.next()).setEnclosingSymbol(this);
        }
        i = this.factories.iterator();
        while (i.hasNext()) {
            ((IdlSymbol)i.next()).setEnclosingSymbol(this);
        }
    }

    public void setInheritanceSpec(ValueInheritanceSpec spec) {
        this.inheritanceSpec = spec;
    }

    public ValueInheritanceSpec getInheritanceSpec() {
        return this.inheritanceSpec;
    }

    public void isCustomMarshalled(boolean flag) {
        this.isCustomMarshalled = flag;
    }

    public boolean isCustomMarshalled() {
        return this.isCustomMarshalled;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.stateMembers.setPackage(s);
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setPackage(s);
        }
        Iterator i = this.operations.iterator();
        while (i.hasNext()) {
            ((IdlSymbol)i.next()).setPackage(s);
        }
        i = this.exports.iterator();
        while (i.hasNext()) {
            ((IdlSymbol)i.next()).setPackage(s);
        }
        i = this.factories.iterator();
        while (i.hasNext()) {
            ((IdlSymbol)i.next()).setPackage(s);
        }
    }

    @Override
    public TypeDeclaration declaration() {
        return this;
    }

    @Override
    public void parse() {
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.parse();
        }
        boolean justAnotherOne = false;
        if (this.isCustomMarshalled() && this.inheritanceSpec != null && this.inheritanceSpec.truncatable != null) {
            parser.error("Valuetype " + this.typeName() + " may no be BOTH custom AND truncatable", this.token);
        }
        ConstrTypeSpec ctspec = new ConstrTypeSpec(ValueDecl.new_num());
        try {
            this.escapeName();
            ScopedName.definePseudoScope(this.full_name());
            ctspec.c_type_spec = this;
            NameTable.define(this.full_name(), IDLTypes.TYPE);
            TypeMap.typedef(this.full_name(), ctspec);
        }
        catch (NameAlreadyDefined nad) {
            Object forwardDeclaration = parser.get_pending(this.full_name());
            if (forwardDeclaration != null) {
                if (!(forwardDeclaration instanceof ValueDecl)) {
                    parser.error("Forward declaration types mismatch for " + this.full_name() + ": name already defined with another type", this.token);
                }
                if (this.stateMembers.size() != 0) {
                    justAnotherOne = true;
                }
                if (!this.full_name().equals("org.omg.CORBA.TypeCode") && this.stateMembers.size() != 0) {
                    TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
                }
            }
            parser.error("Valuetype " + this.typeName() + " already defined", this.token);
        }
        if (this.hasBody) {
            Enumeration e;
            parser.logger.log(Level.WARNING, "valueDecl.parse(): exports (but not attributes)");
            for (IdlSymbol idlSymbol : this.exports) {
                if (idlSymbol instanceof AttrDecl) continue;
                idlSymbol.parse();
            }
            parser.logger.log(Level.WARNING, "valueDecl.parse(): members");
            ScopedName.addRecursionScope(this.typeName());
            this.stateMembers.parse();
            ScopedName.removeRecursionScope(this.typeName());
            parser.logger.log(Level.WARNING, "valueDecl.parse(): operations");
            for (IdlSymbol idlSymbol : this.operations) {
                idlSymbol.parse();
            }
            parser.logger.log(Level.WARNING, "valueDecl.parse(): exports(attributes)");
            for (IdlSymbol idlSymbol : this.exports) {
                if (!(idlSymbol instanceof AttrDecl)) continue;
                idlSymbol.parse();
                e = ((AttrDecl)idlSymbol).getOperations();
                while (e.hasMoreElements()) {
                    this.operations.add(e.nextElement());
                }
            }
            parser.logger.log(Level.WARNING, "valueDecl.parse(): factories");
            for (IdlSymbol idlSymbol : this.factories) {
                idlSymbol.parse();
            }
            parser.logger.log(Level.WARNING, "valueDecl.parse(): check inheritance");
            if (this.inheritanceSpec != null) {
                ConstrTypeSpec ts;
                ScopedName scopedName;
                HashSet<String> h = new HashSet<String>();
                e = this.inheritanceSpec.getValueTypes();
                while (e.hasMoreElements()) {
                    scopedName = (ScopedName)e.nextElement();
                    ts = this.unwindTypedefs(scopedName);
                    if (ts.declaration() instanceof Value) {
                        if (h.contains(ts.full_name())) {
                            parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec + " (repeated inheritance not allowed).", this.token);
                        }
                        h.add(ts.full_name());
                        continue;
                    }
                    parser.logger.log(Level.SEVERE, " Declaration is " + ts.declaration().getClass());
                    parser.fatal_error("Non-value type in inheritance spec: " + Environment.NL + "\t" + this.inheritanceSpec, this.token);
                }
                e = this.inheritanceSpec.getSupportedInterfaces();
                while (e.hasMoreElements()) {
                    scopedName = (ScopedName)e.nextElement();
                    ts = (ConstrTypeSpec)scopedName.resolvedTypeSpec().typeSpec();
                    if (ts.declaration() instanceof Interface) continue;
                    parser.fatal_error("Non-interface type in supported interfaces list: " + Environment.NL + "\t" + this.inheritanceSpec, this.token);
                }
            }
            NameTable.parsed_interfaces.put(this.full_name(), "");
            parser.remove_pending(this.full_name());
        } else if (!justAnotherOne) {
            parser.set_pending(this.full_name(), this);
        }
    }

    private ConstrTypeSpec unwindTypedefs(ScopedName scopedName) {
        TypeSpec resolvedTSpec = scopedName.resolvedTypeSpec();
        while (resolvedTSpec instanceof AliasTypeSpec) {
            resolvedTSpec = ((AliasTypeSpec)resolvedTSpec).originalType();
        }
        if (!(resolvedTSpec instanceof ConstrTypeSpec)) {
            if (parser.logger.isLoggable(Level.ALL)) {
                parser.logger.log(Level.ALL, "Illegal inheritance spec, not a constr. type but " + resolvedTSpec.getClass() + ", name " + scopedName);
            }
            parser.fatal_error("Illegal inheritance spec (not a constr. type): " + this.inheritanceSpec, this.token);
        }
        return (ConstrTypeSpec)resolvedTSpec;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            parser.logger.log(Level.SEVERE, "was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public String toString() {
        return this.full_name();
    }

    @Override
    public String holderName() {
        return this.javaName() + "Holder";
    }

    @Override
    public String helperName() {
        return this.javaName() + "Helper";
    }

    @Override
    public String typeName() {
        return this.full_name();
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        String baseType = "null";
        if (this.hasStatefulBases && this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
            baseType = ((ScopedName)this.inheritanceSpec.v.get(0)).resolvedName() + "Helper.type()";
        }
        StringBuffer result = new StringBuffer("org.omg.CORBA.ORB.init().create_value_tc (\"" + this.id() + "\", " + "\"" + this.name + "\", " + "(short)" + (this.isCustomMarshalled() ? 1 : 0) + ", " + baseType + ", " + "new org.omg.CORBA.ValueMember[] {");
        knownTypes.add(this);
        Iterator i = this.stateMembers.v.iterator();
        while (i.hasNext()) {
            HashSet knownTypesLocal = new HashSet(knownTypes);
            StateMember m = (StateMember)i.next();
            result.append(this.getValueMemberExpression(m, knownTypesLocal));
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        knownTypes.remove(this);
        result.append("})");
        return result.toString();
    }

    private String getValueMemberExpression(StateMember m, Set knownTypes) {
        TypeSpec typeSpec = m.typeSpec();
        if (typeSpec.full_name() != null && !typeSpec.full_name().equals("IDL:*primitive*:1.0") && TypeMap.typemap.containsKey(typeSpec.full_name())) {
            typeSpec = TypeMap.map(typeSpec.full_name());
        }
        String memberTypeExpression = typeSpec.getTypeCodeExpression(knownTypes);
        int access = m.isPublic ? 1 : 0;
        return "new org.omg.CORBA.ValueMember (\"" + m.name + "\", \"" + typeSpec.id() + "\", \"" + this.name + "\", \"1.0\", " + memberTypeExpression + ", null, " + "(short)" + access + ")";
    }

    @Override
    public void print(PrintWriter ps) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.hasBody) {
            return;
        }
        try {
            String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
            File dir2 = new File(path);
            if (!dir2.exists() && !dir2.mkdirs()) {
                parser.fatal_error("Unable to create " + path, null);
            }
            this.printClass(dir2);
            this.printFactory(dir2);
            this.printHelper(dir2);
            this.printHolder(dir2);
            Iterator i = this.exports.iterator();
            while (i.hasNext()) {
                ((IdlSymbol)i.next()).print(null);
            }
        }
        catch (IOException e) {
            parser.fatal_error("I/O error writing " + this.javaName() + ": " + e, null);
        }
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        return "((org.omg.CORBA_2_3.portable.OutputStream)" + streamname + ")" + ".write_value (" + var_name + ", (String)null);";
    }

    @Override
    public String printReadExpression(String streamname) {
        return "(" + this.javaName() + ")" + "((org.omg.CORBA_2_3.portable.InputStream)" + streamname + ")" + ".read_value (\"" + this.id() + "\")";
    }

    @Override
    public String printReadStatement(String var_name, String streamname) {
        return var_name + " = " + this.printReadExpression(streamname);
    }

    private void printClass(File dir2) throws IOException {
        File outfile = new File(dir2, this.name + ".java");
        if (this.hasBody && GlobalInputStream.isMoreRecentThan(outfile)) {
            Truncatable trunc;
            ScopedName scopedName;
            PrintWriter out = new PrintWriter(new FileWriter(outfile));
            if (this.pack_name.length() > 0) {
                out.println("package " + this.pack_name + ";" + Environment.NL);
            }
            this.printClassComment("valuetype", this.name, out);
            out.println("public abstract class " + this.name);
            StringBuffer extendsBuffer = new StringBuffer("extends ");
            StringBuffer implementsBuffer = new StringBuffer("implements ");
            if (this.isCustomMarshalled()) {
                implementsBuffer.append("org.omg.CORBA.portable.CustomValue");
            } else {
                implementsBuffer.append("org.omg.CORBA.portable.StreamableValue");
            }
            if (this.inheritanceSpec != null) {
                Enumeration enumeration;
                boolean first = true;
                Enumeration e = this.inheritanceSpec.getValueTypes();
                if (e.hasMoreElements() || this.inheritanceSpec.truncatable != null) {
                    ConstrTypeSpec ts;
                    if (e.hasMoreElements()) {
                        scopedName = (ScopedName)e.nextElement();
                        ts = this.unwindTypedefs(scopedName);
                        if (ts.c_type_spec instanceof ValueAbsDecl) {
                            implementsBuffer.append(", " + ts.toString());
                        } else {
                            first = false;
                            extendsBuffer.append(ts.toString());
                        }
                    }
                    while (e.hasMoreElements()) {
                        scopedName = (ScopedName)e.nextElement();
                        ts = (ConstrTypeSpec)scopedName.resolvedTypeSpec().typeSpec();
                        if (ts.c_type_spec instanceof ValueAbsDecl) {
                            implementsBuffer.append(", " + scopedName.toString());
                            continue;
                        }
                        if (first) {
                            extendsBuffer.append(scopedName.toString());
                            first = false;
                            continue;
                        }
                        extendsBuffer.append(", " + scopedName.toString());
                    }
                    if (this.inheritanceSpec.truncatable != null) {
                        extendsBuffer.append((first ? "" : ", ") + this.inheritanceSpec.truncatable.scopedName);
                    }
                }
                if ((enumeration = this.inheritanceSpec.getSupportedInterfaces()).hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        ScopedName sne = (ScopedName)enumeration.nextElement();
                        implementsBuffer.append(", " + sne);
                        if (Interface.abstractInterfaces != null && Interface.abstractInterfaces.contains(sne.toString())) continue;
                        implementsBuffer.append("Operations");
                    }
                }
            }
            if (extendsBuffer.length() > 8) {
                this.hasStatefulBases = true;
                out.println("\t" + extendsBuffer.toString());
            }
            out.println("\t" + implementsBuffer.toString());
            out.println("{");
            this.printSerialVersionUID(out);
            out.print("\tprivate String[] _truncatable_ids = {\"" + this.id() + "\"");
            StringBuffer sb = new StringBuffer();
            if (this.inheritanceSpec != null && (trunc = this.inheritanceSpec.truncatable) != null) {
                sb.append(", \"" + trunc.getId() + "\"");
                scopedName = trunc.scopedName;
                while (scopedName != null) {
                    Truncatable t;
                    ValueDecl v = (ValueDecl)((ConstrTypeSpec)scopedName.resolvedTypeSpec()).c_type_spec;
                    if (v.inheritanceSpec == null || (t = v.inheritanceSpec.truncatable) == null) break;
                    sb.append(", \"" + t.getId() + "\"");
                    scopedName = t.scopedName;
                }
            }
            out.println(sb.toString() + "};");
            Iterator i = this.stateMembers.v.iterator();
            while (i.hasNext()) {
                ((StateMember)i.next()).print(out);
                out.println();
            }
            i = this.operations.iterator();
            while (i.hasNext()) {
                ((Operation)i.next()).printSignature(out, true);
                out.println();
            }
            if (!this.isCustomMarshalled()) {
                this.printWriteMethod(out);
                this.printReadMethod(out);
            }
            out.println("\tpublic String[] _truncatable_ids()");
            out.println("\t{");
            out.println("\t\treturn _truncatable_ids;");
            out.println("\t}");
            out.println("\tpublic org.omg.CORBA.TypeCode _type()");
            out.println("\t{");
            out.println("\t\treturn " + this.javaName() + "Helper.type();");
            out.println("\t}");
            out.println("}");
            out.close();
        }
    }

    private void printFactory(File dir2) throws IOException {
        if (this.factories.size() == 0) {
            return;
        }
        File outfile = new File(dir2, this.name + "ValueFactory.java");
        if (this.hasBody && GlobalInputStream.isMoreRecentThan(outfile)) {
            PrintWriter out = new PrintWriter(new FileWriter(outfile));
            if (this.pack_name.length() > 0) {
                out.println("package " + this.pack_name + ";" + Environment.NL);
            }
            this.printClassComment("valuetype", this.name, out);
            out.println("public interface  " + this.name + "ValueFactory");
            out.println("\textends org.omg.CORBA.portable.ValueFactory");
            out.println("{");
            Iterator i = this.factories.iterator();
            while (i.hasNext()) {
                ((InitDecl)i.next()).print(out, this.name);
            }
            out.println("}");
            out.close();
        }
    }

    private void printWriteMethod(PrintWriter out) {
        out.println("\tpublic void _write (org.omg.CORBA.portable.OutputStream os)");
        out.println("\t{");
        if (this.hasStatefulBases) {
            out.println("\t\tsuper._write(os);");
        }
        Iterator i = this.stateMembers.v.iterator();
        while (i.hasNext()) {
            out.println("\t\t" + ((StateMember)i.next()).writeStatement("os"));
        }
        out.println("\t}" + Environment.NL);
    }

    private void printReadMethod(PrintWriter out) {
        out.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream os)");
        out.println("\t{");
        if (this.hasStatefulBases) {
            out.println("\t\tsuper._read(os);");
        }
        Iterator i = this.stateMembers.v.iterator();
        while (i.hasNext()) {
            out.println("\t\t" + ((StateMember)i.next()).readStatement("os"));
        }
        out.println("\t}" + Environment.NL);
    }

    private void printHelper(File dir2) throws IOException {
        File outfile = new File(dir2, this.name + "Helper.java");
        if (this.hasBody && GlobalInputStream.isMoreRecentThan(outfile)) {
            PrintWriter out = new PrintWriter(new FileWriter(outfile));
            if (this.pack_name.length() > 0) {
                out.println("package " + this.pack_name + ";" + Environment.NL);
            }
            this.printClassComment("valuetype", this.name, out);
            out.println("public abstract class " + this.name + "Helper");
            out.println("{");
            out.println("\tprivate volatile static org.omg.CORBA.TypeCode _type = null;");
            out.println("\tpublic static void insert (org.omg.CORBA.Any a, " + this.javaName() + " v)");
            out.println("\t{");
            out.println("\t\ta.insert_Value (v, v._type());");
            out.println("\t}");
            out.println("\tpublic static " + this.javaName() + " extract " + "(org.omg.CORBA.Any a)");
            out.println("\t{");
            out.println("\t\treturn (" + this.javaName() + ")a.extract_Value();");
            out.println("\t}");
            out.println("\tpublic static org.omg.CORBA.TypeCode type()");
            out.println("\t{");
            out.println("\t\tif (_type == null)");
            out.println("\t\t{");
            out.println("\t\t\tsynchronized(" + this.name + "Helper.class)");
            out.println("\t\t\t{");
            out.println("\t\t\t\tif (_type == null)");
            out.println("\t\t\t\t{");
            out.println("\t\t\t\t\t_type = " + this.getTypeCodeExpression() + ";");
            out.println("\t\t\t\t}");
            out.println("\t\t\t}");
            out.println("\t\t}");
            out.println("\t\treturn _type;");
            out.println("\t}" + Environment.NL);
            out.println("\tpublic static String id()");
            out.println("\t{");
            out.println("\t\treturn \"" + this.id() + "\";");
            out.println("\t}");
            out.println("\tpublic static " + this.javaName() + " read " + "(org.omg.CORBA.portable.InputStream is)");
            out.println("\t{");
            out.println("\t\treturn (" + this.javaName() + ")((org.omg.CORBA_2_3.portable.InputStream)is).read_value (\"" + this.id() + "\");");
            out.println("\t}");
            out.println("\tpublic static void write (org.omg.CORBA.portable.OutputStream os, " + this.javaName() + " val)");
            out.println("\t{");
            out.println("\t\t((org.omg.CORBA_2_3.portable.OutputStream)os).write_value (val, \"" + this.id() + "\");");
            out.println("\t}");
            for (InitDecl d : this.factories) {
                d.printHelperMethod(out, this.name);
            }
            out.println("}");
            out.close();
        }
    }

    private void printHolder(File dir2) throws IOException {
        File outfile = new File(dir2, this.name + "Holder.java");
        if (this.hasBody && GlobalInputStream.isMoreRecentThan(outfile)) {
            PrintWriter out = new PrintWriter(new FileWriter(outfile));
            if (this.pack_name.length() > 0) {
                out.println("package " + this.pack_name + ";" + Environment.NL);
            }
            this.printClassComment("valuetype", this.name, out);
            out.println("public" + parser.getFinalString() + " class " + this.name + "Holder");
            out.println("\timplements org.omg.CORBA.portable.Streamable");
            out.println("{");
            out.println("\tpublic " + this.javaName() + " value;");
            out.println("\tpublic " + this.name + "Holder () {}");
            out.println("\tpublic " + this.name + "Holder (final " + this.javaName() + " initial)");
            out.println("\t{");
            out.println("\t\tvalue = initial;");
            out.println("\t}");
            out.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream is)");
            out.println("\t{");
            out.println("\t\tvalue = " + this.javaName() + "Helper.read (is);");
            out.println("\t}");
            out.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream os)");
            out.println("\t{");
            out.println("\t\t" + this.javaName() + "Helper.write (os, value);");
            out.println("\t}");
            out.println("\tpublic org.omg.CORBA.TypeCode _type ()");
            out.println("\t{");
            out.println("\t\treturn value._type ();");
            out.println("\t}");
            out.println("}");
            out.close();
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + ".insert_Value(" + varname + ", " + varname + "._type());");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = (" + resulttype + ")" + anyname + ".extract_Value();");
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitValue(this);
    }
}

