/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definitions;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class Module
extends Declaration
implements Scope {
    public Definitions spec;
    private ScopeData scopeData;
    private String unreplacedName = null;

    public Module(int num) {
        super(num);
        this.pack_name = "";
    }

    @Override
    public void setScopeData(ScopeData data) {
        this.scopeData = data;
    }

    @Override
    public ScopeData getScopeData() {
        return this.scopeData;
    }

    @Override
    public void setPackage(String s) {
        if (this.unreplacedName == null) {
            this.unreplacedName = s;
        }
        s = parser.pack_replace(s);
        if (this.pack_name.length() > 0) {
            this.pack_name = s + "." + this.pack_name;
            this.spec.setPackage(s);
        } else {
            this.pack_name = s;
            if (lexer.needsJavaEscape(this)) {
                this.pack_name = "_" + s;
            }
            this.name = this.pack_name;
            this.spec.setPackage(this.pack_name);
        }
    }

    @Override
    String full_name() {
        return this.pack_name;
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
        this.spec.set_included(i);
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        this.spec.setEnclosingSymbol(this);
    }

    @Override
    public void parse() {
        try {
            NameTable.define(this.unreplacedName, this.full_name(), IDLTypes.MODULE);
        }
        catch (NameAlreadyDefined nad) {
            parser.error("Module name " + this.full_name() + " already defined", this.token);
        }
        this.spec.parse();
    }

    @Override
    public void print(PrintWriter ps) {
        if (parser.generateIR) {
            try {
                File f;
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir2 = new File(path);
                if (!dir2.exists() && !dir2.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir2, "_" + this.originalModuleName() + "Module.java"))) {
                    PrintWriter moduleWriter = new PrintWriter(new FileWriter(f));
                    moduleWriter.println("package " + this.pack_name + ";" + Environment.NL);
                    moduleWriter.println("/**" + Environment.NL + "* IR module information, generated by the JacORB IDL compiler" + Environment.NL + " */");
                    moduleWriter.println("public class _" + this.originalModuleName() + "Module {}");
                    moduleWriter.close();
                }
            }
            catch (IOException io) {
                parser.logger.log(Level.WARNING, "Exception: ", io);
            }
        }
        this.spec.print(ps);
    }

    public String originalModuleName() {
        return this.unreplacedName;
    }

    public Definitions getDefinitions() {
        return this.spec;
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitModule(this);
    }

    public String toString() {
        return "module " + this.name;
    }
}

