/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IllegalRedefinition;
import org.jacorb.idl.InterfaceBody;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ReplyHandler;
import org.jacorb.idl.ReplyHandlerTypeSpec;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class Interface
extends TypeDeclaration
implements Scope {
    public InterfaceBody body = null;
    public SymbolList inheritanceSpec = null;
    private String[] ids = null;
    private boolean is_local = false;
    private boolean is_abstract = false;
    private ScopeData scopeData;
    private boolean parsed = false;
    private ReplyHandler replyHandler = null;
    private Hashtable irInfoTable = new Hashtable();
    protected static HashSet abstractInterfaces;

    public Interface(int num) {
        super(num);
        this.pack_name = "";
    }

    @Override
    public void setScopeData(ScopeData data) {
        this.scopeData = data;
    }

    @Override
    public ScopeData getScopeData() {
        return this.scopeData;
    }

    @Override
    public void setPackage(String s) {
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "Interface setPackage " + s);
        }
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.body != null) {
            this.body.setPackage(s);
        }
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setPackage(s);
        }
    }

    public void set_abstract() {
        this.is_abstract = true;
    }

    @Override
    public TypeDeclaration declaration() {
        return this;
    }

    @Override
    public String typeName() {
        return this.full_name();
    }

    @Override
    public Object clone() {
        throw new RuntimeException("Don't clone me, i am an interface!");
    }

    private ConstrTypeSpec unwindTypedefs(ScopedName scopedName) {
        TypeSpec resolvedTSpec = scopedName.resolvedTypeSpec();
        while (resolvedTSpec instanceof AliasTypeSpec) {
            resolvedTSpec = ((AliasTypeSpec)resolvedTSpec).originalType();
        }
        if (!(resolvedTSpec instanceof ConstrTypeSpec)) {
            if (parser.logger.isLoggable(Level.ALL)) {
                parser.logger.log(Level.ALL, "Illegal inheritance spec in Interface.unwindTypeDefs, not a constr. type but " + resolvedTSpec.getClass() + ", name " + scopedName);
            }
            parser.fatal_error("Illegal inheritance spec in Interface.unwindTypeDefs (not a constr. type): " + this.inheritanceSpec, this.token);
        }
        return (ConstrTypeSpec)resolvedTSpec;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setEnclosingSymbol(s);
        }
    }

    public void set_locality(boolean local) {
        this.is_local = local;
    }

    @Override
    public String getTypeCodeExpression() {
        if (parser.generatedHelperPortability != 0 && this.is_local) {
            return "org.omg.CORBA.ORB.init().create_local_interface_tc(\"" + this.id() + "\", \"" + this.name + "\")";
        }
        if (this.is_abstract) {
            return "org.omg.CORBA.ORB.init().create_abstract_interface_tc(\"" + this.id() + "\", \"" + this.name + "\")";
        }
        return "org.omg.CORBA.ORB.init().create_interface_tc(\"" + this.id() + "\", \"" + this.name + "\")";
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        return this.getTypeCodeExpression();
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public String holderName() {
        return this.toString() + "Holder";
    }

    @Override
    public String helperName() {
        return this.toString() + "Helper";
    }

    @Override
    public String toString() {
        return this.getFullName(this.typeName());
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
    }

    @Override
    public String printReadExpression(String Streamname) {
        return this.javaName() + "Helper.read(" + Streamname + ")";
    }

    @Override
    public String printWriteStatement(String var_name, String Streamname) {
        return this.javaName() + "Helper.write(" + Streamname + "," + var_name + ");";
    }

    @Override
    public void parse() {
        boolean justAnotherOne;
        block20: {
            justAnotherOne = false;
            if (this.parsed) {
                return;
            }
            this.escapeName();
            ConstrTypeSpec ctspec = new ConstrTypeSpec(Interface.new_num());
            if (this.is_abstract) {
                if (parser.logger.isLoggable(Level.ALL)) {
                    parser.logger.log(Level.ALL, "Adding " + this.full_name() + " to abstract interface list");
                }
                if (abstractInterfaces == null) {
                    abstractInterfaces = new HashSet();
                }
                abstractInterfaces.add(this.full_name());
            }
            try {
                ScopedName.definePseudoScope(this.full_name());
                ctspec.c_type_spec = this;
                if (this.is_pseudo) {
                    NameTable.define(this.full_name(), IDLTypes.PSEUDO_INTERFACE);
                } else {
                    NameTable.define(this.full_name(), IDLTypes.INTERFACE);
                }
                TypeMap.typedef(this.full_name(), ctspec);
            }
            catch (IllegalRedefinition ill) {
                parser.fatal_error("Cannot redefine " + this.token.str_val + " in nested scope as " + ill.newDef, this.token);
            }
            catch (NameAlreadyDefined nad) {
                Object forwardDeclaration = parser.get_pending(this.full_name());
                if (forwardDeclaration == null) break block20;
                if (!(forwardDeclaration instanceof Interface)) {
                    parser.error("Forward declaration types mismatch for " + this.full_name() + ": name already defined with another type", this.token);
                }
                if (this.body == null) {
                    justAnotherOne = true;
                }
                if (this.full_name().equals("CORBA.TypeCode") || this.full_name().equals("org.omg.CORBA.TypeCode") || this.body == null) break block20;
                TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
            }
        }
        if (this.body != null) {
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                if (parser.logger.isLoggable(Level.ALL)) {
                    parser.logger.log(Level.ALL, "Checking inheritanceSpec of " + this.full_name());
                }
                HashSet<String> h = new HashSet<String>();
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ScopedName name = (ScopedName)e.nextElement();
                    ConstrTypeSpec ts = this.unwindTypedefs(name);
                    if (ts.declaration() instanceof Interface) {
                        if (h.contains(ts.full_name())) {
                            parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec + " (repeated inheritance not allowed).", this.token);
                        }
                        h.add(ts.full_name());
                        continue;
                    }
                    parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec + " (ancestor " + ts.full_name() + " not an interface)", this.token);
                }
                this.body.set_ancestors(this.inheritanceSpec);
            }
            this.body.parse();
            NameTable.parsed_interfaces.put(this.full_name(), "");
            if (parser.generate_ami_callback) {
                this.replyHandler = new ReplyHandler(this);
                this.replyHandler.parse();
            }
        } else if (!justAnotherOne) {
            parser.set_pending(this.full_name(), this);
        }
        this.parsed = true;
    }

    InterfaceBody getBody() {
        if (parser.get_pending(this.full_name()) != null) {
            parser.fatal_error(this.full_name() + " is forward declared and still pending!", this.token);
        } else if (this.body == null) {
            if ((Interface)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec != this) {
                this.body = ((Interface)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec).getBody();
            }
            if (this.body == null) {
                parser.fatal_error(this.full_name() + " still has an empty body!", this.token);
            }
        }
        return this.body;
    }

    protected PrintWriter openOutput(String typeName) {
        String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
        File dir2 = new File(path);
        if (!dir2.exists() && !dir2.mkdirs()) {
            parser.fatal_error("Unable to create " + path, null);
        }
        try {
            File f = new File(dir2, typeName + ".java");
            if (GlobalInputStream.isMoreRecentThan(f)) {
                PrintWriter ps = new PrintWriter(new FileWriter(f));
                return ps;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open output file for " + typeName + " (" + e + ")");
        }
    }

    protected void printPackage(PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";" + Environment.NL);
        }
    }

    protected void printSuperclassImports(PrintWriter ps) {
        if (this.inheritanceSpec.v.isEmpty()) {
            return;
        }
        if ("".equals(this.pack_name)) {
            return;
        }
        for (ScopedName sn : this.inheritanceSpec.v) {
            if (sn.resolvedName().indexOf(46) >= 0) continue;
            ps.print("import ");
            ps.print(sn.toString());
            ps.println(';');
        }
    }

    protected void printInterface() {
        PrintWriter ps;
        block16: {
            block15: {
                ps = this.openOutput(this.name);
                if (ps == null) {
                    return;
                }
                this.printPackage(ps);
                this.printSuperclassImports(ps);
                this.printClassComment("interface", this.name, ps);
                if (!this.is_pseudo) break block15;
                ps.println("public abstract class " + this.name);
                if (this.inheritanceSpec.v.size() <= 0) break block16;
                StringBuffer pseudo_bases = new StringBuffer();
                StringBuffer regular_bases = new StringBuffer();
                String comma = " ";
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ScopedName sn = (ScopedName)e.nextElement();
                    String name = sn.resolvedName();
                    if (sn.is_pseudo()) {
                        pseudo_bases.append(comma + name);
                    } else {
                        regular_bases.append(comma + name);
                    }
                    if (this.inheritanceSpec.v.size() <= 1) continue;
                    comma = ",";
                }
                if (pseudo_bases.length() > 0) {
                    ps.println("\textends " + pseudo_bases.toString());
                }
                if (regular_bases.length() <= 0) break block16;
                ps.println("\timplements " + regular_bases.toString());
                break block16;
            }
            ps.println("public interface " + this.name);
            if (this.is_abstract) {
                ps.print("\textends org.omg.CORBA.portable.IDLEntity");
            } else {
                ps.print("\textends " + this.name + "Operations");
                if (this.is_local) {
                    ps.print(", org.omg.CORBA.LocalInterface, org.omg.CORBA.portable.IDLEntity");
                } else {
                    ps.print(", org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity");
                }
            }
            if (this.inheritanceSpec.v.size() > 0) {
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ScopedName sne = (ScopedName)e.nextElement();
                    if (sne.resolvedTypeSpec() instanceof ReplyHandlerTypeSpec && parser.generate_ami_callback) {
                        ps.print(", " + sne);
                        continue;
                    }
                    ConstrTypeSpec ts = this.unwindTypedefs(sne);
                    ps.print(", " + ts);
                }
            }
        }
        ps.println(Environment.NL + "{");
        if (this.is_pseudo) {
            this.printSerialVersionUID(ps);
        }
        if (this.body != null) {
            this.body.printInterfaceMethods(ps);
            if (this.is_abstract) {
                this.body.printConstants(ps);
                this.body.printOperationSignatures(ps);
            }
        }
        ps.println("}");
        ps.close();
    }

    protected void printOperations() {
        PrintWriter ps = this.openOutput(this.name + "Operations");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printSuperclassImports(ps);
        this.printImport(ps);
        this.printClassComment("interface", this.name, ps);
        ps.println("public interface " + this.name + "Operations");
        if (this.inheritanceSpec.v.size() > 0) {
            ps.print("\textends ");
            Enumeration e = this.inheritanceSpec.v.elements();
            do {
                ScopedName sne = (ScopedName)e.nextElement();
                if (abstractInterfaces != null && abstractInterfaces.contains(sne.toString())) {
                    ps.print(sne);
                } else if (sne.resolvedTypeSpec() instanceof ReplyHandlerTypeSpec && parser.generate_ami_callback) {
                    ps.print(sne + "Operations");
                } else {
                    ConstrTypeSpec ts = this.unwindTypedefs(sne);
                    ps.print(ts + "Operations");
                }
                if (!e.hasMoreElements()) continue;
                ps.print(" , ");
            } while (e.hasMoreElements());
            ps.print(Environment.NL);
        }
        ps.println("{");
        if (this.body != null) {
            this.body.printConstants(ps);
            this.body.printOperationSignatures(ps);
        }
        ps.println("}");
        ps.close();
    }

    protected void printHolder() {
        PrintWriter ps = this.openOutput(this.name + "Holder");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printClassComment("interface", this.name, ps);
        ps.print("public" + parser.getFinalString() + " class " + this.name + "Holder");
        ps.print("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\t public " + this.name + " value;");
        ps.println("\tpublic " + this.name + "Holder()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "Holder (final " + this.name + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.name + "Helper.type();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + this.name + "Helper.read (in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + this.name + "Helper.write (_out,value);");
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printNarrow(PrintWriter ps, boolean checked, boolean forCorbaObject) {
        ps.print("\tpublic static " + this.typeName());
        ps.print(checked ? " narrow" : " unchecked_narrow");
        ps.println(forCorbaObject ? "(final org.omg.CORBA.Object obj)" : "(final java.lang.Object obj)");
        ps.println("\t{");
        ps.println("\t\tif (obj == null)");
        ps.println("\t\t{");
        ps.println("\t\t\treturn null;");
        ps.println("\t\t}");
        ps.println("\t\telse if (obj instanceof " + this.typeName() + ")");
        ps.println("\t\t{");
        ps.println("\t\t\treturn (" + this.typeName() + ")obj;");
        ps.println("\t\t}");
        if (parser.generate_stubs && !this.is_local) {
            if (checked && forCorbaObject) {
                ps.println("\t\telse if (obj._is_a(\"" + this.id() + "\"))");
                this.printStubInterposition(ps);
                this.printElseNarrowFailed(ps);
            } else if (!checked && forCorbaObject) {
                ps.println("\t\telse");
                this.printStubInterposition(ps);
            } else if (checked && !forCorbaObject) {
                ps.println("\t\telse if (obj instanceof org.omg.CORBA.Object &&");
                ps.println("\t\t         ((org.omg.CORBA.Object)obj)._is_a(\"" + this.id() + "\"))");
                this.printStubInterposition(ps);
                this.printElseNarrowFailed(ps);
            } else if (!checked && !forCorbaObject) {
                ps.println("\t\tif (obj instanceof org.omg.CORBA.Object)");
                this.printStubInterposition(ps);
                this.printElseNarrowFailed(ps);
            }
        } else {
            this.printElseNarrowFailed(ps);
        }
        ps.println("\t}");
    }

    protected void printStubInterposition(PrintWriter ps) {
        String stub_name = Interface.stubName(this.typeName());
        ps.println("\t\t{");
        ps.println("\t\t\t" + stub_name + " stub;");
        ps.println("\t\t\tstub = new " + stub_name + "();");
        ps.println("\t\t\tstub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
        ps.println("\t\t\treturn stub;");
        ps.println("\t\t}");
    }

    protected void printElseNarrowFailed(PrintWriter ps) {
        ps.println("\t\telse");
        ps.println("\t\t{");
        ps.println("\t\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Narrow failed\");");
        ps.println("\t\t}");
    }

    protected void printHelper() {
        PrintWriter ps = this.openOutput(this.name + "Helper");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printImport(ps);
        this.printClassComment("interface", this.name, ps);
        ps.println("public abstract class " + this.name + "Helper");
        ps.println("{");
        ps.println("\tprivate volatile static org.omg.CORBA.TypeCode _type;");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        ps.println("\t{");
        ps.println("\t\tif (_type == null)");
        ps.println("\t\t{");
        ps.println("\t\t\tsynchronized(" + this.name + "Helper.class)");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tif (_type == null)");
        ps.println("\t\t\t\t{");
        ps.println("\t\t\t\t\t_type = " + this.getTypeCodeExpression() + ";");
        ps.println("\t\t\t\t}");
        ps.println("\t\t\t}");
        ps.println("\t\t}");
        ps.println("\t\treturn _type;");
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic static void insert (final org.omg.CORBA.Any any, final " + this.typeName() + " s)");
        ps.println("\t{");
        if (this.is_abstract) {
            ps.println("\t\tif (s instanceof org.omg.CORBA.Object)");
            ps.println("\t\t{");
            ps.println("\t\t\tany.insert_Object((org.omg.CORBA.Object)s);");
            ps.println("\t\t}");
            ps.println("\t\telse if (s instanceof java.io.Serializable)");
            ps.println("\t\t{");
            ps.println("\t\t\tany.insert_Value((java.io.Serializable)s);");
            ps.println("\t\t}");
            ps.println("\t\telse");
            ps.println("\t\t{");
            ps.println("\t\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Failed to insert in helper\");");
            ps.println("\t\t}");
        } else {
            ps.println("\t\t\tany.insert_Object(s);");
        }
        ps.println("\t}");
        ps.println("\tpublic static " + this.typeName() + " extract(final org.omg.CORBA.Any any)");
        ps.println("\t{");
        if (this.is_abstract) {
            ps.println("\t\ttry");
            ps.println("\t\t{");
            ps.println("\t\torg.omg.CORBA.Object __o = any.extract_Object();" + Environment.NL);
            ps.println("\t\t" + this.name + " __r = narrow(__o);" + Environment.NL);
            ps.println("\t\treturn __r;");
            ps.println("\t\t}");
            ps.println("\t\tcatch (org.omg.CORBA.BAD_OPERATION ex)");
            ps.println("\t\t{");
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\treturn (" + this.typeName() + ")any.extract_Value();");
            ps.println("\t\t\t}");
            ps.println("\t\t\tcatch (ClassCastException e)");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\tthrow new org.omg.CORBA.MARSHAL(e.getMessage());");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
        } else if (parser.useUncheckedNarrow) {
            ps.println("\t\treturn unchecked_narrow(any.extract_Object());");
        } else {
            ps.println("\t\treturn narrow(any.extract_Object()) ;");
        }
        ps.println("\t}");
        this.printIdMethod(ps);
        ps.println("\tpublic static " + this.name + " read(final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        if (this.is_local) {
            ps.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
        } else if (this.is_abstract) {
            ps.println("\t\treturn narrow(((org.omg.CORBA_2_3.portable.InputStream)in).read_abstract_interface());");
        } else {
            String stubClass;
            String string = stubClass = parser.generate_stubs ? Interface.stubName(this.typeName()) + ".class" : "";
            if (parser.useUncheckedNarrow) {
                ps.println("\t\treturn unchecked_narrow(in.read_Object(" + stubClass + "));");
            } else {
                ps.println("\t\treturn narrow(in.read_Object(" + stubClass + "));");
            }
        }
        ps.println("\t}");
        ps.println("\tpublic static void write(final org.omg.CORBA.portable.OutputStream _out, final " + this.typeName() + " s)");
        ps.println("\t{");
        if (this.is_local) {
            ps.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
        } else if (this.is_abstract) {
            ps.println("\t\t((org.omg.CORBA_2_3.portable.OutputStream)_out).write_abstract_interface(s);");
        } else {
            ps.println("\t\t_out.write_Object(s);");
        }
        ps.println("\t}");
        if (this.is_abstract) {
            this.printNarrow(ps, true, false);
            this.printNarrow(ps, false, false);
        } else if (this.hasAbstractBase()) {
            this.printNarrow(ps, true, true);
            this.printNarrow(ps, true, false);
            this.printNarrow(ps, false, true);
            this.printNarrow(ps, false, false);
        } else {
            this.printNarrow(ps, true, true);
            this.printNarrow(ps, false, true);
        }
        ps.println("}");
        ps.close();
    }

    public String[] get_ids() {
        if (this.ids == null) {
            HashSet<String> base_ids = new HashSet<String>();
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                Iterator i = this.inheritanceSpec.v.iterator();
                while (i.hasNext()) {
                    TypeSpec ts = ((ScopedName)i.next()).resolvedTypeSpec();
                    if (ts instanceof ConstrTypeSpec) {
                        Interface base = (Interface)((ConstrTypeSpec)ts).c_type_spec;
                        base_ids.addAll(Arrays.asList(base.get_ids()));
                        continue;
                    }
                    if (!(ts instanceof ReplyHandlerTypeSpec)) continue;
                    base_ids.add("IDL:omg.org/Messaging/ReplyHandler:1.0");
                }
            }
            this.ids = new String[base_ids.size() + 1];
            this.ids[0] = this.id();
            int i = 1;
            Iterator j = base_ids.iterator();
            while (j.hasNext()) {
                this.ids[i] = (String)j.next();
                ++i;
            }
        }
        return this.ids;
    }

    protected boolean hasAbstractBase() {
        if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
            Iterator i = this.inheritanceSpec.v.iterator();
            while (i.hasNext()) {
                TypeSpec ts = ((ScopedName)i.next()).resolvedTypeSpec();
                if (!(ts instanceof ConstrTypeSpec)) continue;
                Interface base = (Interface)((ConstrTypeSpec)ts).c_type_spec;
                if (!base.is_abstract && !base.hasAbstractBase()) continue;
                return true;
            }
        }
        return false;
    }

    protected void printStub() {
        PrintWriter ps = this.openOutput("_" + this.name + "Stub");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printImport(ps);
        this.printClassComment("interface", this.name, ps);
        ps.println("public class _" + this.name + "Stub");
        ps.println("\textends org.omg.CORBA.portable.ObjectImpl");
        ps.println("\timplements " + this.javaName());
        ps.println("{");
        this.printSerialVersionUID(ps);
        ps.print("\tprivate String[] ids = {");
        String[] ids = this.get_ids();
        for (int i = 0; i < ids.length - 1; ++i) {
            ps.print("\"" + ids[i] + "\",");
        }
        ps.println("\"" + ids[ids.length - 1] + "\"};");
        ps.println("\tpublic String[] _ids()");
        ps.println("\t{");
        ps.println("\t\treturn ids;");
        ps.println("\t}" + Environment.NL);
        if (!parser.cldc10) {
            ps.print("\tpublic final static java.lang.Class _opsClass = ");
            if (!this.pack_name.equals("")) {
                ps.print(this.pack_name + ".");
            }
            if (this.is_abstract) {
                ps.println(this.name + ".class;");
            } else {
                ps.println(this.name + "Operations.class;");
            }
        } else {
            String fullName = null;
            fullName = !this.pack_name.equals("") ? this.pack_name + "." + this.name : this.name;
            ps.println("\tpublic static final java.lang.Class _opsClass;");
            ps.println("\tstatic");
            ps.println("\t{");
            ps.println("\t\ttry");
            ps.println("\t\t{");
            ps.print("\t\t\t_opsClass = Class.forName(\"");
            if (!this.pack_name.equals("")) {
                ps.print(this.pack_name + ".");
            }
            ps.println(this.name + "Operations\");");
            ps.println("\t\t}");
            ps.println("\t\tcatch(ClassNotFoundException cnfe)");
            ps.println("\t\t{");
            ps.println("\t\t\tthrow new RuntimeException(\"Class " + fullName + " was not found.\");");
            ps.println("\t\t}");
            ps.println("\t}" + Environment.NL);
        }
        this.body.printStubMethods(ps, this.name, this.is_local, this.is_abstract);
        ps.println("}");
        ps.close();
    }

    protected void printImplSkeleton() {
        PrintWriter ps = this.openOutput(this.name + "POA");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printImport(ps);
        this.printClassComment("interface", this.name, ps);
        ps.print("public abstract class " + this.name + "POA" + Environment.NL);
        ps.println("\textends org.omg.PortableServer.Servant");
        ps.println("\timplements org.omg.CORBA.portable.InvokeHandler, " + this.javaName() + "Operations");
        ps.println("{");
        this.body.printOperationsHash(ps);
        ps.print("\tprivate String[] ids = {");
        String[] ids = this.get_ids();
        for (int i = 0; i < ids.length - 1; ++i) {
            ps.print("\"" + ids[i] + "\",");
        }
        ps.println("\"" + ids[ids.length - 1] + "\"};");
        ps.println("\tpublic " + this.javaName() + " _this()");
        ps.println("\t{");
        ps.println("\t\torg.omg.CORBA.Object __o = _this_object() ;");
        ps.println("\t\t" + this.javaName() + " __r = " + this.javaName() + "Helper.narrow(__o);");
        ps.println("\t\treturn __r;");
        ps.println("\t}");
        ps.println("\tpublic " + this.javaName() + " _this(org.omg.CORBA.ORB orb)");
        ps.println("\t{");
        ps.println("\t\torg.omg.CORBA.Object __o = _this_object(orb) ;");
        ps.println("\t\t" + this.javaName() + " __r = " + this.javaName() + "Helper.narrow(__o);");
        ps.println("\t\treturn __r;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.portable.OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream _input, org.omg.CORBA.portable.ResponseHandler handler)");
        ps.println("\t\tthrows org.omg.CORBA.SystemException");
        ps.println("\t{");
        if (this.body.getMethods().length > 0) {
            ps.println("\t\torg.omg.CORBA.portable.OutputStream _out = null;");
            ps.println("\t\t// do something");
        }
        this.body.printSkelInvocations(ps);
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic String[] _all_interfaces(org.omg.PortableServer.POA poa, byte[] obj_id)");
        ps.println("\t{");
        ps.println("\t\treturn ids;");
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printTieSkeleton() {
        PrintWriter ps = this.openOutput(this.name + "POATie");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        ps.println("import org.omg.PortableServer.POA;");
        this.printImport(ps);
        this.printClassComment("interface", this.name, ps);
        ps.println("public class " + this.name + "POATie");
        ps.println("\textends " + this.name + "POA");
        ps.println("{");
        ps.println("\tprivate " + this.name + "Operations _delegate;" + Environment.NL);
        ps.println("\tprivate POA _poa;");
        ps.println("\tpublic " + this.name + "POATie(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "POATie(" + this.name + "Operations delegate, POA poa)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t\t_poa = poa;");
        ps.println("\t}");
        ps.println("\tpublic " + this.javaName() + " _this()");
        ps.println("\t{");
        ps.println("\t\torg.omg.CORBA.Object __o = _this_object() ;");
        ps.println("\t\t" + this.javaName() + " __r = " + this.javaName() + "Helper.narrow(__o);");
        ps.println("\t\treturn __r;");
        ps.println("\t}");
        ps.println("\tpublic " + this.javaName() + " _this(org.omg.CORBA.ORB orb)");
        ps.println("\t{");
        ps.println("\t\torg.omg.CORBA.Object __o = _this_object(orb) ;");
        ps.println("\t\t" + this.javaName() + " __r = " + this.javaName() + "Helper.narrow(__o);");
        ps.println("\t\treturn __r;");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "Operations _delegate()");
        ps.println("\t{");
        ps.println("\t\treturn _delegate;");
        ps.println("\t}");
        ps.println("\tpublic void _delegate(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        ps.println("\tpublic POA _default_POA()");
        ps.println("\t{");
        ps.println("\t\tif (_poa != null)");
        ps.println("\t\t{");
        ps.println("\t\t\treturn _poa;");
        ps.println("\t\t}");
        ps.println("\t\treturn super._default_POA();");
        ps.println("\t}");
        this.body.printDelegatedMethods(ps);
        ps.println("}");
        ps.close();
    }

    protected void printIRHelper() {
        PrintWriter ps = this.openOutput(this.name + "IRHelper");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        ps.println(Environment.NL + "/**");
        ps.println(" * This class contains generated Interface Repository information.");
        ps.println(" * @author JacORB IDL compiler.");
        ps.println(" */" + Environment.NL);
        ps.println("public class " + this.name + "IRHelper");
        ps.println("{");
        String HASHTABLE = System.getProperty("java.version").startsWith("1.1") ? "com.sun.java.util.collections.Hashtable" : "java.util.Hashtable";
        ps.println("\tpublic static " + HASHTABLE + " irInfo = new " + HASHTABLE + "();");
        ps.println("\tstatic");
        ps.println("\t{");
        this.body.getIRInfo(this.irInfoTable);
        Enumeration e = this.irInfoTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ps.println("\t\tirInfo.put(\"" + key + "\", \"" + (String)this.irInfoTable.get(key) + "\");");
        }
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printLocalBase() {
        PrintWriter ps = this.openOutput("_" + this.name + "LocalBase");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        ps.println(Environment.NL + "/**");
        ps.println(" * Abstract base class for implementations of local interface " + this.name);
        ps.println(" * @author JacORB IDL compiler.");
        ps.println(" */" + Environment.NL);
        ps.println("public abstract class _" + this.name + "LocalBase");
        ps.println("\textends org.omg.CORBA.LocalObject");
        ps.println("\timplements " + this.name);
        ps.println("{");
        this.printSerialVersionUID(ps);
        ps.print("\tprivate String[] _type_ids = {");
        String[] ids = this.get_ids();
        for (int i = 0; i < ids.length - 1; ++i) {
            ps.print("\"" + ids[i] + "\",");
        }
        ps.println("\"" + ids[ids.length - 1] + "\"};");
        ps.print("\tpublic String[] _ids()");
        ps.println("\t{");
        ps.println("\t\treturn(String[])_type_ids.clone();");
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printLocalTie() {
        PrintWriter ps = this.openOutput(this.name + "LocalTie");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printImport(ps);
        this.printClassComment("interface", this.name, ps);
        ps.println("public class " + this.name + "LocalTie");
        ps.println("\textends _" + this.name + "LocalBase");
        ps.println("{");
        this.printSerialVersionUID(ps);
        ps.println("\tprivate " + this.name + "Operations _delegate;" + Environment.NL);
        ps.println("\tpublic " + this.name + "LocalTie(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "Operations _delegate()");
        ps.println("\t{");
        ps.println("\t\treturn _delegate;");
        ps.println("\t}");
        ps.println("\tpublic void _delegate(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        this.body.printDelegatedMethods(ps);
        ps.println("}");
        ps.close();
    }

    @Override
    public void print(PrintWriter _ps) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.body != null) {
            this.printInterface();
            if (!this.is_pseudo) {
                if (!this.is_abstract) {
                    this.printOperations();
                }
                this.printHelper();
                this.printHolder();
                if (parser.generate_stubs && !this.is_local) {
                    this.printStub();
                }
                if (parser.generate_skeletons && !this.is_local && !this.is_abstract) {
                    this.printImplSkeleton();
                    this.printTieSkeleton();
                }
                if (parser.generateIR) {
                    this.printIRHelper();
                }
                if (this.is_local) {
                    this.printLocalBase();
                    this.printLocalTie();
                }
            }
            this.body.print(null);
            if (this.replyHandler != null) {
                this.replyHandler.print(_ps);
            }
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        if (this.is_abstract) {
            throw new RuntimeException("DII stubs not yet implemented for abstract interfaces");
        }
        ps.println("\t\t" + anyname + ".insert_Object(" + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + this.helperName() + ".extract(" + anyname + ");");
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitInterface(this);
    }

    private static final String stubName(String typeName) {
        String stub_name = typeName.indexOf(46) > -1 ? typeName.substring(0, typeName.lastIndexOf(46)) + "._" + typeName.substring(typeName.lastIndexOf(46) + 1) + "Stub" : "_" + typeName + "Stub";
        return stub_name;
    }
}

