/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.property.LocalProperties;

public class Target
implements TaskContainer {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private List dependencies = null;
    private List children = new ArrayList();
    private Location location = Location.UNKNOWN_LOCATION;
    private Project project;
    private String description = null;

    public Target() {
    }

    public Target(Target other) {
        this.name = other.name;
        this.ifCondition = other.ifCondition;
        this.unlessCondition = other.unlessCondition;
        this.dependencies = other.dependencies;
        this.location = other.location;
        this.project = other.project;
        this.description = other.description;
        this.children = other.children;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setDepends(String depS) {
        Iterator iter = Target.parseDepends(depS, this.getName(), "depends").iterator();
        while (iter.hasNext()) {
            this.addDependency((String)iter.next());
        }
    }

    public static List parseDepends(String depends, String targetName, String attributeName) {
        ArrayList<String> list = new ArrayList<String>();
        if (depends.length() > 0) {
            StringTokenizer tok = new StringTokenizer(depends, ",", true);
            while (tok.hasMoreTokens()) {
                String token2 = tok.nextToken().trim();
                if ("".equals(token2) || ",".equals(token2)) {
                    throw new BuildException("Syntax Error: " + attributeName + " attribute of target \"" + targetName + "\" contains an empty string.");
                }
                list.add(token2);
                if (!tok.hasMoreTokens()) continue;
                token2 = tok.nextToken();
                if (tok.hasMoreTokens() && ",".equals(token2)) continue;
                throw new BuildException("Syntax Error: " + attributeName + " attribute for target \"" + targetName + "\" ends with a \",\" " + "character");
            }
        }
        return list;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addTask(Task task) {
        this.children.add(task);
    }

    public void addDataType(RuntimeConfigurable r) {
        this.children.add(r);
    }

    public Task[] getTasks() {
        ArrayList tasks = new ArrayList(this.children.size());
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Task)) continue;
            tasks.add(o);
        }
        return tasks.toArray(new Task[tasks.size()]);
    }

    public void addDependency(String dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList(2);
        }
        this.dependencies.add(dependency);
    }

    public Enumeration getDependencies() {
        return Collections.enumeration(this.dependencies == null ? Collections.EMPTY_LIST : this.dependencies);
    }

    public boolean dependsOn(String other) {
        Project p = this.getProject();
        Hashtable t = p == null ? null : p.getTargets();
        return p != null && p.topoSort(this.getName(), t, false).contains(t.get(other));
    }

    public void setIf(String property) {
        this.ifCondition = property == null ? "" : property;
    }

    public String getIf() {
        return "".equals(this.ifCondition) ? null : this.ifCondition;
    }

    public void setUnless(String property) {
        this.unlessCondition = property == null ? "" : property;
    }

    public String getUnless() {
        return "".equals(this.unlessCondition) ? null : this.unlessCondition;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this.testIfAllows()) {
            this.project.log(this, "Skipped because property '" + this.project.replaceProperties(this.ifCondition) + "' not set.", 3);
            return;
        }
        if (!this.testUnlessAllows()) {
            this.project.log(this, "Skipped because property '" + this.project.replaceProperties(this.unlessCondition) + "' set.", 3);
            return;
        }
        LocalProperties localProperties = LocalProperties.get(this.getProject());
        localProperties.enterScope();
        try {
            for (int i = 0; i < this.children.size(); ++i) {
                Object o = this.children.get(i);
                if (o instanceof Task) {
                    Task task = (Task)o;
                    task.perform();
                    continue;
                }
                ((RuntimeConfigurable)o).maybeConfigure(this.project);
            }
        }
        finally {
            localProperties.exitScope();
        }
    }

    public final void performTasks() {
        RuntimeException thrown = null;
        this.project.fireTargetStarted(this);
        try {
            this.execute();
        }
        catch (RuntimeException exc) {
            thrown = exc;
            throw exc;
        }
        finally {
            this.project.fireTargetFinished(this, thrown);
        }
    }

    void replaceChild(Task el, RuntimeConfigurable o) {
        int index;
        while ((index = this.children.indexOf(el)) >= 0) {
            this.children.set(index, o);
        }
    }

    void replaceChild(Task el, Task o) {
        int index;
        while ((index = this.children.indexOf(el)) >= 0) {
            this.children.set(index, o);
        }
    }

    private boolean testIfAllows() {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this.getProject());
        Object o = propertyHelper.parseProperties(this.ifCondition);
        return propertyHelper.testIfCondition(o);
    }

    private boolean testUnlessAllows() {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this.getProject());
        Object o = propertyHelper.parseProperties(this.unlessCondition);
        return propertyHelper.testUnlessCondition(o);
    }
}

