/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.tools.ant.taskdefs.condition.Os;

public class PathTokenizer {
    private StringTokenizer tokenizer;
    private String lookahead = null;
    private boolean onNetWare = Os.isFamily("netware");
    private boolean dosStyleFilesystem;

    public PathTokenizer(String path) {
        this.tokenizer = this.onNetWare ? new StringTokenizer(path, ":;", true) : new StringTokenizer(path, ":;", false);
        this.dosStyleFilesystem = File.pathSeparatorChar == ';';
    }

    public boolean hasMoreTokens() {
        if (this.lookahead != null) {
            return true;
        }
        return this.tokenizer.hasMoreTokens();
    }

    public String nextToken() throws NoSuchElementException {
        String token2 = null;
        if (this.lookahead != null) {
            token2 = this.lookahead;
            this.lookahead = null;
        } else {
            token2 = this.tokenizer.nextToken().trim();
        }
        if (!this.onNetWare) {
            if (token2.length() == 1 && Character.isLetter(token2.charAt(0)) && this.dosStyleFilesystem && this.tokenizer.hasMoreTokens()) {
                String nextToken = this.tokenizer.nextToken().trim();
                if (nextToken.startsWith("\\") || nextToken.startsWith("/")) {
                    token2 = token2 + ":" + nextToken;
                } else {
                    this.lookahead = nextToken;
                }
            }
        } else {
            String nextToken;
            if (token2.equals(File.pathSeparator) || token2.equals(":")) {
                token2 = this.tokenizer.nextToken().trim();
            }
            if (this.tokenizer.hasMoreTokens() && !(nextToken = this.tokenizer.nextToken().trim()).equals(File.pathSeparator)) {
                if (nextToken.equals(":")) {
                    if (!(token2.startsWith("/") || token2.startsWith("\\") || token2.startsWith(".") || token2.startsWith(".."))) {
                        String oneMore = this.tokenizer.nextToken().trim();
                        if (!oneMore.equals(File.pathSeparator)) {
                            token2 = token2 + ":" + oneMore;
                        } else {
                            token2 = token2 + ":";
                            this.lookahead = oneMore;
                        }
                    }
                } else {
                    this.lookahead = nextToken;
                }
            }
        }
        return token2;
    }
}

