/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.Xid;
import net.sf.ehcache.Element;
import net.sf.ehcache.transaction.Command;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;
import net.sf.ehcache.transaction.xa.VersionAwareWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XATransactionContext
implements TransactionContext {
    private final Set<Object> removedKeys = new HashSet<Object>();
    private final Set<Object> addedKeys = new HashSet<Object>();
    private final List<VersionAwareCommand> commands = new ArrayList<VersionAwareCommand>();
    private final ConcurrentMap<Object, Element> commandElements = new ConcurrentHashMap<Object, Element>();
    private final EhcacheXAStore store;
    private final Xid xid;
    private final boolean bypassValidation;
    private int sizeModifier;

    public XATransactionContext(Xid xid, EhcacheXAStore store) {
        this.store = store;
        this.xid = xid;
        this.bypassValidation = store.isBypassingValidation();
    }

    @Override
    public Element get(Object key) {
        return this.removedKeys.contains(key) ? null : (Element)this.commandElements.get(key);
    }

    @Override
    public boolean isRemoved(Object key) {
        return this.removedKeys.contains(key);
    }

    @Override
    public Collection getAddedKeys() {
        return Collections.unmodifiableSet(this.addedKeys);
    }

    @Override
    public Collection getRemovedKeys() {
        return Collections.unmodifiableSet(this.removedKeys);
    }

    @Override
    public void addCommand(Command command, Element element) {
        VersionAwareWrapper wrapper;
        Object key = null;
        if (element != null) {
            key = element.getObjectKey();
        }
        if (key != null) {
            long version2 = this.bypassValidation ? 0L : this.store.checkout(key, this.xid);
            wrapper = new VersionAwareWrapper(command, version2, key);
            this.commandElements.put(element.getObjectKey(), element);
        } else {
            wrapper = new VersionAwareWrapper(command);
        }
        if (key != null) {
            if (command.isPut(key)) {
                boolean removed = this.removedKeys.remove(key);
                boolean added = this.addedKeys.add(key);
                if (removed || added && !this.store.getUnderlyingStore().containsKey(key)) {
                    ++this.sizeModifier;
                }
            } else if (command.isRemove(key)) {
                this.removedKeys.add(key);
                if (this.addedKeys.remove(key) || this.store.getUnderlyingStore().containsKey(key)) {
                    --this.sizeModifier;
                }
            }
        }
        this.commands.add(wrapper);
    }

    @Override
    public List<VersionAwareCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    @Override
    public Object[] getUpdatedKeys() {
        ArrayList<Object> keys = new ArrayList<Object>(this.getCommands().size());
        for (VersionAwareCommand command : this.getCommands()) {
            Object key = command.getKey();
            if (key == null) continue;
            keys.add(key);
        }
        return keys.toArray(new Object[keys.size()]);
    }

    @Override
    public int getSizeModifier() {
        return this.sizeModifier;
    }
}

