/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.strategy;

import net.sf.ehcache.hibernate.regions.EhcacheEntityRegion;
import net.sf.ehcache.hibernate.strategy.AbstractEhcacheAccessStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cfg.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonStrictReadWriteEhcacheEntityRegionAccessStrategy
extends AbstractEhcacheAccessStrategy<EhcacheEntityRegion>
implements EntityRegionAccessStrategy {
    private final Settings settings;

    public NonStrictReadWriteEhcacheEntityRegionAccessStrategy(EhcacheEntityRegion region, Settings settings) {
        super(region, settings);
        this.settings = settings;
    }

    public EntityRegion getRegion() {
        return (EntityRegion)this.region;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return ((EhcacheEntityRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version2, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && ((EhcacheEntityRegion)this.region).get(key) != null) {
            return false;
        }
        ((EhcacheEntityRegion)this.region).put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version2) throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        ((EhcacheEntityRegion)this.region).remove(key);
    }

    public boolean insert(Object key, Object value, Object version2) throws CacheException {
        return false;
    }

    public boolean afterInsert(Object key, Object value, Object version2) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.remove(key);
        return false;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        this.unlockItem(key, lock);
        return false;
    }

    @Override
    public void remove(Object key) throws CacheException {
        ((EhcacheEntityRegion)this.region).remove(key);
    }
}

