/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtils {
    private static Class[] integerClasses = new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class};
    private static Class[] decimalClasses = new Class[]{Float.class, Double.class, BigDecimal.class};

    public static boolean isByteShortIntegerOrLong(Number number) {
        return number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long;
    }

    public static boolean isFloatOrDouble(Number number) {
        return number instanceof Float || number instanceof Double;
    }

    public static BigInteger getBigInteger(Number number) {
        BigInteger bigInteger = null;
        bigInteger = NumberUtils.isByteShortIntegerOrLong(number) ? BigInteger.valueOf(number.longValue()) : (NumberUtils.isFloatOrDouble(number) ? new BigDecimal(number.doubleValue()).toBigInteger() : (number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : new BigDecimal(number.doubleValue()).toBigInteger())));
        return bigInteger;
    }

    public static BigDecimal getBigDecimal(Number number) {
        BigDecimal bigDecimal = null;
        bigDecimal = number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long ? new BigDecimal(number.longValue()) : (number instanceof Float || number instanceof Double ? BigDecimal.valueOf(number.doubleValue()) : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.doubleValue()))));
        return bigDecimal;
    }

    public static Class<? extends Number> getCommonNumberClass(Class<? extends Number> numberClass1, Class<? extends Number> numberClass2) {
        int indexInteger1 = NumberUtils.getIndex(integerClasses, numberClass1);
        if (indexInteger1 >= 0) {
            int indexInteger2 = NumberUtils.getIndex(integerClasses, numberClass2);
            if (indexInteger2 >= 0) {
                if (indexInteger1 >= indexInteger2) {
                    return integerClasses[indexInteger1];
                }
                return integerClasses[indexInteger2];
            }
            return BigDecimal.class;
        }
        int indexDecimal1 = NumberUtils.getIndex(decimalClasses, numberClass1);
        if (indexDecimal1 >= 0) {
            int indexDecimal2 = NumberUtils.getIndex(decimalClasses, numberClass2);
            if (indexDecimal2 >= 0) {
                if (indexDecimal1 >= indexDecimal2) {
                    return decimalClasses[indexDecimal1];
                }
                return decimalClasses[indexDecimal2];
            }
            return BigDecimal.class;
        }
        return BigDecimal.class;
    }

    private static int getIndex(Class[] classes, Class<? extends Number> numberClass) {
        for (int i = 0; i < classes.length; ++i) {
            if (numberClass != classes[i]) continue;
            return i;
        }
        return -1;
    }
}

