/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.parser;

import java.util.ArrayList;
import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.FieldTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.PrimitiveTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.signature.parser.IImportedClassesProvider;
import net.entropysoft.transmorph.signature.parser.ITypeSignatureParser;
import net.entropysoft.transmorph.signature.parser.InvalidSignatureException;
import net.entropysoft.transmorph.signature.parser.JavaLangImportedClassesProvider;
import net.entropysoft.transmorph.signature.parser.JavaSyntaxTypeSignatureLexer;
import net.entropysoft.transmorph.signature.parser.PrimitiveTypeUtils;

public class JavaSyntaxTypeSignatureParser
implements ITypeSignatureParser {
    private JavaSyntaxTypeSignatureLexer lexer;
    private boolean acceptGenerics = true;
    private IImportedClassesProvider[] importedClassesProviders = new IImportedClassesProvider[]{new JavaLangImportedClassesProvider()};

    public JavaSyntaxTypeSignatureParser() {
    }

    public JavaSyntaxTypeSignatureParser(String typeSignature) {
        this.setTypeSignature(typeSignature);
    }

    public FullTypeSignature parseTypeSignature() throws InvalidSignatureException {
        FullTypeSignature typeSignature = this.parseJavaTypeSignature();
        this.lexer.nextToken(JavaSyntaxTypeSignatureLexer.TokenType.END_OF_TOKENS);
        return typeSignature;
    }

    public void setTypeSignature(String signature) {
        this.lexer = new JavaSyntaxTypeSignatureLexer(signature);
    }

    public boolean isAcceptGenerics() {
        return this.acceptGenerics;
    }

    public void setAcceptGenerics(boolean acceptGenerics) {
        this.acceptGenerics = acceptGenerics;
    }

    public IImportedClassesProvider[] getImportedClasses() {
        return this.importedClassesProviders;
    }

    public void setImportedClassesProviders(IImportedClassesProvider ... importedClasses) {
        this.importedClassesProviders = importedClasses;
    }

    public FullTypeSignature parseJavaTypeSignature() {
        FullTypeSignature typeSignature = this.parsePrimitiveTypeSignature();
        if (typeSignature == null) {
            typeSignature = this.parseClassTypeSignature();
        }
        JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.peekToken(0);
        while (token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.ARRAY) {
            typeSignature = new ArrayTypeSignature(typeSignature);
            this.lexer.nextToken();
            token2 = this.lexer.peekToken(0);
        }
        return typeSignature;
    }

    public FieldTypeSignature parseFieldTypeSignature() {
        FullTypeSignature typeSignature = this.parseJavaTypeSignature();
        if (!(typeSignature instanceof FieldTypeSignature)) {
            throw new InvalidSignatureException("Invalid signature", this.lexer.peekToken((int)0).tokenStart);
        }
        return (FieldTypeSignature)typeSignature;
    }

    private PrimitiveTypeSignature parsePrimitiveTypeSignature() {
        JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.peekToken(0);
        Character primitiveChar = PrimitiveTypeUtils.getChar(token2.text);
        if (primitiveChar != null) {
            JavaSyntaxTypeSignatureLexer.Token token1 = this.lexer.peekToken(1);
            if (token1.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.END_OF_TOKENS || token1.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.ARRAY) {
                this.lexer.nextToken();
                return new PrimitiveTypeSignature(primitiveChar.charValue());
            }
        }
        return null;
    }

    private ClassTypeSignature parseClassTypeSignature() {
        String outerClassName = this.parseOuterClassName();
        TypeArgSignature[] typeArgSignatures = new TypeArgSignature[]{};
        JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.peekToken(0);
        if (this.acceptGenerics && token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.TYPE_ARG_BEGIN) {
            typeArgSignatures = this.parseTypeArgs();
        }
        ClassTypeSignature classTypeSignature = new ClassTypeSignature(outerClassName, typeArgSignatures, null);
        token2 = this.lexer.peekToken(0);
        if (token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.INNER_CLASS_PREFIX) {
            classTypeSignature = this.parseInnerClasses(classTypeSignature);
        }
        return classTypeSignature;
    }

    private String parseOuterClassName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lexer.nextToken((JavaSyntaxTypeSignatureLexer.TokenType)JavaSyntaxTypeSignatureLexer.TokenType.JAVA_ID).text);
        JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.peekToken(0);
        boolean isFullyQualifiedName = false;
        while (token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.PACKAGE_SEPARATOR) {
            isFullyQualifiedName = true;
            token2 = this.lexer.nextToken();
            sb.append('.');
            token2 = this.lexer.nextToken(JavaSyntaxTypeSignatureLexer.TokenType.JAVA_ID);
            sb.append(token2.text);
            token2 = this.lexer.peekToken(0);
        }
        if (!isFullyQualifiedName) {
            return this.getFullyQualifiedName(sb.toString());
        }
        return sb.toString();
    }

    public String getFullyQualifiedName(String shortName) {
        for (IImportedClassesProvider importedClassesProvider : this.importedClassesProviders) {
            if (!importedClassesProvider.isImported(shortName)) continue;
            return importedClassesProvider.getFullyQualifiedName(shortName);
        }
        return shortName;
    }

    private TypeArgSignature[] parseTypeArgs() {
        this.lexer.nextToken(JavaSyntaxTypeSignatureLexer.TokenType.TYPE_ARG_BEGIN);
        ArrayList<TypeArgSignature> typeArgSignatures = new ArrayList<TypeArgSignature>();
        typeArgSignatures.add(this.parseTypeArg());
        JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.peekToken(0);
        while (token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.TYPE_ARG_SEPARATOR) {
            this.lexer.nextToken();
            typeArgSignatures.add(this.parseTypeArg());
            token2 = this.lexer.peekToken(0);
        }
        this.lexer.nextToken(JavaSyntaxTypeSignatureLexer.TokenType.TYPE_ARG_END);
        return typeArgSignatures.toArray(new TypeArgSignature[typeArgSignatures.size()]);
    }

    private TypeArgSignature parseTypeArg() {
        JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.peekToken(0);
        if (token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.TYPE_ARG_QUESTION_MARK) {
            this.lexer.nextToken();
            token2 = this.lexer.peekToken(0);
            if (token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.JAVA_ID && token2.text.equals("extends")) {
                this.lexer.nextToken();
                return new TypeArgSignature(TypeArgSignature.UPPERBOUND_WILDCARD, this.parseFieldTypeSignature());
            }
            if (token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.JAVA_ID && token2.text.equals("super")) {
                this.lexer.nextToken();
                return new TypeArgSignature(TypeArgSignature.LOWERBOUND_WILDCARD, this.parseFieldTypeSignature());
            }
            return new TypeArgSignature(TypeArgSignature.UNBOUNDED_WILDCARD, null);
        }
        return new TypeArgSignature(TypeArgSignature.NO_WILDCARD, this.parseFieldTypeSignature());
    }

    private ClassTypeSignature parseInnerClass(ClassTypeSignature ownerClassTypeSignature) {
        this.lexer.nextToken(JavaSyntaxTypeSignatureLexer.TokenType.INNER_CLASS_PREFIX);
        JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.nextToken(JavaSyntaxTypeSignatureLexer.TokenType.JAVA_ID);
        String id = token2.text;
        token2 = this.lexer.peekToken(0);
        TypeArgSignature[] typeArgSignatures = new TypeArgSignature[]{};
        if (this.acceptGenerics && token2.tokenType == JavaSyntaxTypeSignatureLexer.TokenType.TYPE_ARG_BEGIN) {
            typeArgSignatures = this.parseTypeArgs();
        }
        return new ClassTypeSignature(id, typeArgSignatures, ownerClassTypeSignature);
    }

    private ClassTypeSignature parseInnerClasses(ClassTypeSignature ownerClassTypeSignature) {
        ClassTypeSignature classTypeSignature = this.parseInnerClass(ownerClassTypeSignature);
        while (true) {
            JavaSyntaxTypeSignatureLexer.Token token2 = this.lexer.peekToken(0);
            if (token2.tokenType != JavaSyntaxTypeSignatureLexer.TokenType.INNER_CLASS_PREFIX) {
                return classTypeSignature;
            }
            classTypeSignature = this.parseInnerClass(classTypeSignature);
        }
    }
}

