/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.PrimitiveTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.type.GenericArrayTypeImpl;
import net.entropysoft.transmorph.type.ParameterizedTypeImpl;
import net.entropysoft.transmorph.type.WildcardTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactory {
    private static Map<Character, Class<?>> primitiveTypesMap = new HashMap();
    private ClassLoader classLoader;

    public TypeFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Type getType(FullTypeSignature typeSignature) throws ClassNotFoundException {
        if (typeSignature.isPrimitiveType()) {
            return this.getType((PrimitiveTypeSignature)typeSignature);
        }
        if (typeSignature.isArrayType()) {
            return this.getType((ArrayTypeSignature)typeSignature);
        }
        if (typeSignature.isClassType()) {
            return this.getType((ClassTypeSignature)typeSignature);
        }
        if (typeSignature.isTypeVar()) {
            throw new ClassNotFoundException("Type variable not supported");
        }
        throw new ClassNotFoundException("Signature type not supported");
    }

    public Type getType(PrimitiveTypeSignature primitiveTypeSignature) {
        return primitiveTypesMap.get(Character.valueOf(primitiveTypeSignature.getPrimitiveTypeChar()));
    }

    public GenericArrayType getType(ArrayTypeSignature arrayTypeSignature) throws ClassNotFoundException {
        Type componentType = this.getType(arrayTypeSignature.getComponentTypeSignature());
        return new GenericArrayTypeImpl(componentType);
    }

    public Type getType(ClassTypeSignature classTypeSignature) throws ClassNotFoundException {
        TypeArgSignature[] typeArgSignatures = classTypeSignature.getTypeArgSignatures();
        if (typeArgSignatures.length == 0) {
            return this.getClass(classTypeSignature);
        }
        Class rawType = (Class)this.getType(classTypeSignature.getTypeErasureSignature());
        Type ownerType = classTypeSignature.getOwnerTypeSignature() == null ? null : this.getType(classTypeSignature.getOwnerTypeSignature());
        Type[] actualTypeArguments = new Type[typeArgSignatures.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            actualTypeArguments[i] = this.getType(typeArgSignatures[i]);
        }
        return new ParameterizedTypeImpl(rawType, actualTypeArguments, ownerType);
    }

    private Class<?> getClass(ClassTypeSignature typeErasureSignature) throws ClassNotFoundException {
        String className = typeErasureSignature.getClassName();
        return Class.forName(className, true, this.classLoader);
    }

    private Type getType(TypeArgSignature typeArgSignature) throws ClassNotFoundException {
        char wildcard = typeArgSignature.getWildcard();
        if (wildcard == TypeArgSignature.NO_WILDCARD) {
            return this.getType(typeArgSignature.getFieldTypeSignature());
        }
        if (wildcard == TypeArgSignature.UNBOUNDED_WILDCARD) {
            return new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
        }
        if (wildcard == TypeArgSignature.LOWERBOUND_WILDCARD) {
            return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{this.getType(typeArgSignature.getFieldTypeSignature())});
        }
        if (wildcard == TypeArgSignature.UPPERBOUND_WILDCARD) {
            return new WildcardTypeImpl(new Type[]{this.getType(typeArgSignature.getFieldTypeSignature())}, new Type[0]);
        }
        throw new ClassNotFoundException("Invalid wildcard in type arg signature");
    }

    static {
        primitiveTypesMap.put(Character.valueOf('Z'), Boolean.TYPE);
        primitiveTypesMap.put(Character.valueOf('B'), Byte.TYPE);
        primitiveTypesMap.put(Character.valueOf('C'), Character.TYPE);
        primitiveTypesMap.put(Character.valueOf('D'), Double.TYPE);
        primitiveTypesMap.put(Character.valueOf('F'), Float.TYPE);
        primitiveTypesMap.put(Character.valueOf('I'), Integer.TYPE);
        primitiveTypesMap.put(Character.valueOf('J'), Long.TYPE);
        primitiveTypesMap.put(Character.valueOf('S'), Short.TYPE);
    }
}

