/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToCollection
extends AbstractContainerConverter {
    private Class<? extends Set> defaultSetClass = HashSet.class;
    private Class<? extends List> defaultListClass = ArrayList.class;

    public CollectionToCollection() {
        this.useObjectPool = true;
    }

    public Class<? extends Set> getDefaultSetClass() {
        return this.defaultSetClass;
    }

    public void setDefaultSetClass(Class<? extends Set> defaultSetClass) {
        this.defaultSetClass = defaultSetClass;
    }

    public Class<? extends List> getDefaultListClass() {
        return this.defaultListClass;
    }

    public void setDefaultListClass(Class<? extends List> defaultListClass) {
        this.defaultListClass = defaultListClass;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        TypeReference<?>[] destinationTypeArguments;
        Collection<Object> destinationCollection;
        if (sourceObject == null) {
            return null;
        }
        Collection sourceCollection = (Collection)sourceObject;
        try {
            destinationCollection = this.createDestinationCollection(sourceCollection, destinationType);
        }
        catch (Exception e) {
            throw new ConverterException("Could not create destination collection", e);
        }
        if (destinationCollection == null) {
            throw new ConverterException("Could not create destination collection");
        }
        if (this.useObjectPool) {
            context.getConvertedObjectPool().add(this, sourceObject, destinationType, destinationCollection);
        }
        if ((destinationTypeArguments = destinationType.getTypeArguments()).length == 0) {
            destinationTypeArguments = new TypeReference[]{TypeReference.get(Object.class)};
        }
        for (Object obj : sourceCollection) {
            Object convertedObj = this.elementConverter.convert(context, obj, destinationTypeArguments[0]);
            destinationCollection.add(convertedObj);
        }
        return destinationCollection;
    }

    private Collection<Object> createDestinationCollection(Collection sourceObject, TypeReference<?> destinationType) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ConverterException {
        Class<? extends Collection> clazz = this.getConcreteCollectionDestinationClass(sourceObject, destinationType);
        if (clazz == null) {
            throw new ConverterException(MessageFormat.format("Cannot find a concrete class for destination collection ''{0}''", destinationType.toHumanString()));
        }
        return clazz.newInstance();
    }

    protected Class<? extends Collection> getConcreteCollectionDestinationClass(Collection sourceObject, TypeReference<?> destinationType) throws ClassNotFoundException {
        if (destinationType.hasRawType(Set.class)) {
            return this.defaultSetClass;
        }
        if (destinationType.hasRawType(List.class)) {
            return this.defaultListClass;
        }
        if (destinationType.hasRawType(Collection.class)) {
            if (sourceObject instanceof Set) {
                return this.defaultSetClass;
            }
            return this.defaultListClass;
        }
        Class<?> destinationClass = destinationType.getRawType();
        if (destinationClass.isInterface() || Modifier.isAbstract(destinationClass.getModifiers())) {
            return null;
        }
        try {
            destinationClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
        return destinationClass;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isRawTypeSubOf(Collection.class);
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof Collection;
    }
}

