/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToBoolean
extends AbstractConverter {
    private String trueString = "true";
    private String falseString = "false";
    private boolean caseSensitive = true;

    public StringToBoolean() {
        this.useObjectPool = true;
    }

    public String getTrueString() {
        return this.trueString;
    }

    public void setTrueString(String trueString) {
        this.trueString = trueString;
    }

    public String getFalseString() {
        return this.falseString;
    }

    public void setFalseString(String falseString) {
        this.falseString = falseString;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Could not convert null to boolean primitive type");
            }
            return null;
        }
        String sourceString = (String)sourceObject;
        if (this.caseSensitive) {
            if (sourceString.equals(this.trueString)) {
                return true;
            }
            if (sourceString.equals(this.falseString)) {
                return false;
            }
            throw new ConverterException("Could not convert '" + sourceString + "' to a boolean");
        }
        if (sourceString.equalsIgnoreCase(this.trueString)) {
            return true;
        }
        if (sourceString.equalsIgnoreCase(this.falseString)) {
            return false;
        }
        throw new ConverterException("Could not convert '" + sourceString + "' to a boolean");
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.hasRawType(Boolean.TYPE) || destinationType.hasRawType(Boolean.class);
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof String;
    }
}

