/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.context;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.context.UsedConverter;
import net.entropysoft.transmorph.signature.formatter.ITypeSignatureFormatter;
import net.entropysoft.transmorph.signature.formatter.JavaSyntaxTypeSignatureFormatter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsedConverters {
    private final List<UsedConverter> usedConvertersList = new ArrayList<UsedConverter>();
    private final Set<UsedConverter> usedConvertersSet = new HashSet<UsedConverter>();

    public void clear() {
        this.usedConvertersList.clear();
        this.usedConvertersSet.clear();
    }

    public void addUsedConverter(IConverter converter, Object sourceObject, TypeReference<?> destinationType) {
        UsedConverter usedConverter = new UsedConverter(converter, sourceObject == null ? null : sourceObject.getClass(), destinationType);
        if (!this.usedConvertersSet.contains(usedConverter)) {
            this.usedConvertersSet.add(usedConverter);
            this.usedConvertersList.add(usedConverter);
        }
    }

    public UsedConverter[] getUsedConverters() {
        return this.usedConvertersList.toArray(new UsedConverter[this.usedConvertersList.size()]);
    }

    public String toString() {
        return this.toString(new JavaSyntaxTypeSignatureFormatter());
    }

    public String toString(ITypeSignatureFormatter formatter) {
        StringBuilder sb = new StringBuilder();
        for (UsedConverter usedConverter : this.usedConvertersList) {
            String sourceName = this.getUsedConverterSourceName(usedConverter, formatter);
            String destinationName = this.getUsedConverterDestinationName(usedConverter, formatter);
            sb.append(MessageFormat.format("Converter ''{0}'' used to convert from ''{1}'' to destination type ''{2}''.", usedConverter.getConverter().getClass().getSimpleName(), sourceName, destinationName));
            sb.append('\n');
        }
        return sb.toString();
    }

    private String getUsedConverterDestinationName(UsedConverter usedConverter, ITypeSignatureFormatter typeSignatureFormatter) {
        String destinationName = typeSignatureFormatter.format(usedConverter.getDestinationType().getTypeSignature());
        return destinationName;
    }

    private String getUsedConverterSourceName(UsedConverter usedConverter, ITypeSignatureFormatter typeSignatureFormatter) {
        if (usedConverter.getSourceObjectClass() == null) {
            return "null";
        }
        TypeReference<?> sourceTypeReference = TypeReference.get(usedConverter.getSourceObjectClass());
        String sourceName = typeSignatureFormatter.format(sourceTypeReference.getTypeSignature());
        return sourceName;
    }
}

