/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.statecomposer;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.Group.Group;
import fr.esrf.TangoApi.Group.GroupCmdReply;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.esrf.TangoApi.StateUtilities;
import fr.soleil.tango.statecomposer.PriorityStateManager;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.tango.utils.CaseInsensitiveMap;
import org.tango.utils.DevFailedUtils;

public final class StateResolver {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private final Map<String, String> errorReportMap = Collections.synchronizedMap(new CaseInsensitiveMap());
    private Group group;
    private final PriorityStateManager priorityStateManager;
    private final boolean isSynchronous;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private final StateRefresher refresher = new StateRefresher();
    private final long period;

    public void configurePriorities(String[] priorities) {
        for (String state : priorities) {
            int priority;
            String tmpState;
            StringTokenizer tmpPriorityTokens = new StringTokenizer(state.trim(), ",");
            if (tmpPriorityTokens.countTokens() != 2 || !StateUtilities.isStateExist(tmpState = tmpPriorityTokens.nextToken().trim().toUpperCase())) continue;
            try {
                priority = Integer.valueOf(tmpPriorityTokens.nextToken().trim());
            }
            catch (NumberFormatException e) {
                priority = 0;
            }
            this.putStatePriority(StateUtilities.getStateForName(tmpState), priority);
        }
    }

    public StateResolver(long period, boolean isSynchronous) {
        this.priorityStateManager = new PriorityStateManager();
        this.isSynchronous = isSynchronous;
        this.period = period;
    }

    public void putStatePriority(DevState state, int priority) {
        this.priorityStateManager.putStatePriority(state, priority);
    }

    public void setMonitoredDevicesGroup(Group group) {
        this.group = group;
    }

    public void setMonitoredDevices(int timeout, String ... deviceNameList) throws DevFailed {
        if (deviceNameList.length > 0 && !deviceNameList[0].equals("")) {
            LinkedHashSet<String> deviceNameSet = new LinkedHashSet<String>();
            for (String element : deviceNameList) {
                deviceNameSet.add(element.trim());
            }
            this.group = new Group("statecomposer");
            this.group.add(deviceNameSet.toArray(new String[deviceNameSet.size()]));
            try {
                this.group.set_timeout_millis(timeout, true);
            }
            catch (DevFailed devFailed) {}
        } else {
            throw DevFailedUtils.newDevFailed("INIT_ERROR", "property DeviceNameList is not configured");
        }
    }

    public void start(String threadName) {
        if (!this.isSynchronous) {
            this.executor = Executors.newScheduledThreadPool(1, new ThreadFact(threadName));
            this.future = this.executor.scheduleAtFixedRate(this.refresher, 0L, this.period, TimeUnit.MILLISECONDS);
        }
    }

    public void start() {
        this.start("");
    }

    public boolean isStarted() {
        boolean isStarted = true;
        if (this.priorityStateManager.getDeviceStateNumberArray().length == 0) {
            isStarted = false;
        }
        return isStarted;
    }

    public void stop() {
        if (!this.isSynchronous && this.future != null) {
            this.future.cancel(true);
            this.executor.shutdownNow();
        }
    }

    public Map<String, String> getErrorReportMap() {
        return new CaseInsensitiveMap<String>(this.errorReportMap);
    }

    public DevState getState() {
        DevState stateResult = this.isSynchronous ? this.stateReader() : this.refresher.getState();
        return stateResult;
    }

    public short[] getDeviceStateNumberArray() {
        return this.priorityStateManager.getDeviceStateNumberArray();
    }

    public Map<String, DevState> getDeviceStates() {
        return this.priorityStateManager.getDeviceStateMap();
    }

    public String[] getDeviceStateArray() {
        return this.priorityStateManager.getDeviceStateArray();
    }

    public int getPriorityForState(DevState state) {
        return this.priorityStateManager.getPriorityForState(state);
    }

    private DevState stateReader() {
        GroupCmdReplyList tmpReplyList = null;
        DevState stateResult = null;
        try {
            tmpReplyList = this.group.command_inout("State", true);
        }
        catch (DevFailed e) {
            this.errorReportMap.put(this.group.get_name(), DATE_FORMAT.format(new Date()) + " : Received error for State " + DevFailedUtils.toString(e));
        }
        if (tmpReplyList != null) {
            Enumeration tmpReplyEnumeration = tmpReplyList.elements();
            while (tmpReplyEnumeration.hasMoreElements()) {
                GroupCmdReply tmpReply = (GroupCmdReply)tmpReplyEnumeration.nextElement();
                try {
                    DeviceData tmpDeviceData = tmpReply.get_data();
                    DevState tmpState = tmpDeviceData.extractDevState();
                    this.priorityStateManager.putDeviceState(tmpReply.dev_name(), tmpState);
                }
                catch (DevFailed e) {
                    this.errorReportMap.put(tmpReply.dev_name(), DATE_FORMAT.format(new Date()) + " : Received error for State " + DevFailedUtils.toString(e));
                    this.priorityStateManager.putDeviceState(tmpReply.dev_name(), DevState.UNKNOWN);
                }
                stateResult = this.priorityStateManager.getHighestPriorityState();
            }
        }
        return stateResult;
    }

    public Group getGroup() {
        return this.group;
    }

    private class StateRefresher
    implements Runnable {
        private DevState state = DevState.UNKNOWN;

        private StateRefresher() {
        }

        @Override
        public void run() {
            this.state = StateResolver.this.stateReader();
        }

        public DevState getState() {
            return this.state;
        }
    }

    private static class ThreadFact
    implements ThreadFactory {
        private static final AtomicInteger THREAD_NR = new AtomicInteger(0);
        private final String threadName;

        public ThreadFact(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.threadName + "-StateResolver-" + THREAD_NR.incrementAndGet());
        }
    }
}

