/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.errorstrategy;

import fr.esrf.Tango.DevFailed;
import fr.soleil.tango.errorstrategy.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.utils.DevFailedUtils;

public final class RetriableTask<T> {
    private final int tries;
    private final int delay;
    private final Logger logger = LoggerFactory.getLogger(RetriableTask.class);

    public RetriableTask(int tries, int delay) {
        this.tries = tries;
        this.delay = delay;
    }

    public T execute(Task<T> taskToWrap) throws DevFailed {
        int triesLeft = this.tries;
        while (true) {
            try {
                return taskToWrap.call();
            }
            catch (DevFailed e) {
                if (--triesLeft <= 0) {
                    this.logger.error("Caught exception, all retries done for error: {}", (Object)DevFailedUtils.toString(e));
                    throw e;
                }
                this.logger.info("Caught exception, retrying... Error was: {}" + DevFailedUtils.toString(e));
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (triesLeft > 0) continue;
                return null;
            }
            break;
        }
    }
}

