/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import fr.soleil.tango.clientapi.Properties;
import fr.soleil.tango.clientapi.command.ITangoCommand;
import fr.soleil.tango.clientapi.factory.ProxyFactory;
import fr.soleil.tango.clientapi.util.TypeConversionUtil;
import fr.soleil.tango.errorstrategy.RetriableTask;
import fr.soleil.tango.errorstrategy.Task;
import java.util.Arrays;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public final class RealCommand
implements ITangoCommand {
    private static final String DESC = "input type not supported";
    private static final String TANGO_WRONG_DATA_ERROR = "TANGO_WRONG_DATA_ERROR";
    private DeviceProxy devProxy;
    private final String commandName;
    private final DeviceData inData = new DeviceData();
    private DeviceData outData;
    private int arginType;
    private int argoutType;
    private final int delay = Properties.getDelay();
    private final int retries = Properties.getRetries();

    public RealCommand(final String deviceName, final String commandName) throws DevFailed {
        this.commandName = commandName;
        Task<Void> task = new Task<Void>(){

            @Override
            public Void call() throws DevFailed {
                RealCommand.this.devProxy = ProxyFactory.getInstance().createDeviceProxy(deviceName);
                RealCommand.this.arginType = ((RealCommand)RealCommand.this).devProxy.command_query((String)commandName).in_type;
                RealCommand.this.argoutType = ((RealCommand)RealCommand.this).devProxy.command_query((String)commandName).out_type;
                return null;
            }
        };
        RetriableTask<Void> retriable = new RetriableTask<Void>(this.retries, this.delay);
        retriable.execute(task);
    }

    public RealCommand(String commandName) throws DevFailed {
        this(commandName.substring(0, commandName.lastIndexOf("/")), commandName.substring(commandName.lastIndexOf("/") + 1));
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void execute() throws DevFailed {
        Task<Void> task = new Task<Void>(){

            @Override
            public Void call() throws DevFailed {
                if (RealCommand.this.isArginVoid()) {
                    RealCommand.this.outData = RealCommand.this.devProxy.command_inout(RealCommand.this.commandName);
                } else {
                    RealCommand.this.outData = RealCommand.this.devProxy.command_inout(RealCommand.this.commandName, RealCommand.this.inData);
                }
                return null;
            }
        };
        RetriableTask<Void> retriable = new RetriableTask<Void>(this.retries, this.delay);
        retriable.execute(task);
    }

    @Override
    public void execute(Object value) throws DevFailed {
        this.insert(value);
        this.execute();
    }

    @Override
    public Object executeExtract(Object value) throws DevFailed {
        this.insert(value);
        this.execute();
        return this.extract();
    }

    @Override
    public Object executeExtract() throws DevFailed {
        this.execute();
        return this.extract();
    }

    @Override
    public void insertMixArgin(String[] numberArgin, String[] stringArgin) throws DevFailed {
        if (this.arginType == 18) {
            double[] d = TypeConversionUtil.castToType(double[].class, numberArgin);
            DevVarDoubleStringArray dvdsa = new DevVarDoubleStringArray(d, stringArgin);
            this.inData.insert(dvdsa);
        } else if (this.arginType == 17) {
            int[] in = TypeConversionUtil.castToType(int[].class, numberArgin);
            DevVarLongStringArray dvlsa = new DevVarLongStringArray(in, stringArgin);
            this.inData.insert(dvlsa);
        } else {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, DESC);
        }
    }

    @Override
    public void insertMixArgin(double[] numberArgin, String[] stringArgin) throws DevFailed {
        if (this.arginType == 18) {
            DevVarDoubleStringArray dvdsa = new DevVarDoubleStringArray(numberArgin, stringArgin);
            this.inData.insert(dvdsa);
        } else if (this.arginType == 17) {
            int[] in = TypeConversionUtil.castToType(int[].class, numberArgin);
            DevVarLongStringArray dvlsa = new DevVarLongStringArray(in, stringArgin);
            this.inData.insert(dvlsa);
        } else {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, DESC);
        }
    }

    @Override
    public void insertMixArgin(int[] numberArgin, String[] stringArgin) throws DevFailed {
        if (this.arginType != 17) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, DESC);
        }
        int[] in = TypeConversionUtil.castToType(int[].class, numberArgin);
        DevVarLongStringArray dvlsa = new DevVarLongStringArray(in, stringArgin);
        this.inData.insert(dvlsa);
    }

    @Override
    public String extractToString(String separator) throws DevFailed {
        String argout = "";
        if (this.isArgoutScalar()) {
            argout = InsertExtractUtils.extract(this.outData, String.class);
        } else if (!this.isArgoutVoid()) {
            String[] result = InsertExtractUtils.extract(this.outData, String[].class);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                buff.append(result[i]);
                if (i == result.length - 1) continue;
                buff.append(separator);
            }
            argout = buff.toString();
        }
        return argout;
    }

    @Override
    public String[] getNumMixArrayArgout() throws DevFailed {
        String[] argout;
        if (this.argoutType == 18) {
            DevVarDoubleStringArray dvdsa = this.outData.extractDoubleStringArray();
            argout = TypeConversionUtil.castToType(String[].class, dvdsa.dvalue);
        } else if (this.argoutType == 17) {
            DevVarLongStringArray dvlsa = this.outData.extractLongStringArray();
            argout = TypeConversionUtil.castToType(String[].class, dvlsa.lvalue);
        } else {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, DESC);
        }
        return argout;
    }

    @Override
    public String[] getStringMixArrayArgout() throws DevFailed {
        String[] argout;
        if (this.argoutType == 18) {
            DevVarDoubleStringArray dvdsa = this.outData.extractDoubleStringArray();
            argout = Arrays.copyOf(dvdsa.svalue, dvdsa.svalue.length);
        } else if (this.argoutType == 17) {
            DevVarLongStringArray dvlsa = this.outData.extractLongStringArray();
            argout = Arrays.copyOf(dvlsa.svalue, dvlsa.svalue.length);
        } else {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, DESC);
        }
        return argout;
    }

    @Override
    public double[] getNumDoubleMixArrayArgout() throws DevFailed {
        double[] argout;
        if (this.argoutType == 18) {
            DevVarDoubleStringArray dvdsa = this.outData.extractDoubleStringArray();
            argout = Arrays.copyOf(dvdsa.dvalue, dvdsa.dvalue.length);
        } else if (this.argoutType == 17) {
            DevVarLongStringArray dvlsa = this.outData.extractLongStringArray();
            argout = TypeConversionUtil.castToType(double[].class, dvlsa.lvalue);
        } else {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, DESC);
        }
        return argout;
    }

    @Override
    public int[] getNumLongMixArrayArgout() throws DevFailed {
        if (this.argoutType != 17) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, DESC);
        }
        DevVarLongStringArray dvlsa = this.outData.extractLongStringArray();
        int[] argout = Arrays.copyOf(dvlsa.lvalue, dvlsa.lvalue.length);
        return argout;
    }

    @Override
    public boolean isArginScalar() throws DevFailed {
        return TangoUtil.SCALARS.contains(this.arginType);
    }

    @Override
    public boolean isArginSpectrum() throws DevFailed {
        return TangoUtil.SPECTRUMS.contains(this.arginType);
    }

    @Override
    public boolean isArginVoid() throws DevFailed {
        return this.arginType == 0;
    }

    @Override
    public boolean isArgoutVoid() throws DevFailed {
        return this.argoutType == 0;
    }

    @Override
    public boolean isArgoutSpectrum() throws DevFailed {
        return TangoUtil.SPECTRUMS.contains(this.argoutType);
    }

    @Override
    public boolean isArginMixFormat() throws DevFailed {
        return this.arginType == 18 || this.arginType == 17;
    }

    @Override
    public boolean isArgoutScalar() throws DevFailed {
        return TangoUtil.SCALARS.contains(this.argoutType);
    }

    @Override
    public boolean isArgoutMixFormat() throws DevFailed {
        return this.argoutType == 18 || this.argoutType == 17;
    }

    @Override
    public DeviceProxy getDeviceProxy() {
        return this.devProxy;
    }

    @Override
    public int getArginType() throws DevFailed {
        return this.arginType;
    }

    @Override
    public int getArgoutType() throws DevFailed {
        return this.argoutType;
    }

    private void insert(Object value) throws DevFailed {
        InsertExtractUtils.insert(this.inData, this.arginType, value);
    }

    private Object extract() throws DevFailed {
        return InsertExtractUtils.extract(this.outData);
    }

    @Override
    public void setTimeout(int timeout) throws DevFailed {
        this.devProxy.set_timeout_millis(timeout);
    }
}

