/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceData;
import fr.soleil.tango.clientapi.command.ICommandInserter;
import fr.soleil.tango.clientapi.util.TypeConversionUtil;

public final class CommandInserters {

    public static final class DoubleStringInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            throw new NumberFormatException("Type DoubleStringArray not supported");
        }
    }

    public static final class LongStringInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            throw new NumberFormatException("Type LongStringArray not supported");
        }
    }

    public static final class IntInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(int[].class, values));
        }
    }

    public static final class ULong64InserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert_u64(TypeConversionUtil.castToType(long[].class, values));
        }
    }

    public static final class Long64InserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(long[].class, values));
        }
    }

    public static final class ULongInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert_ul(TypeConversionUtil.castToType(int[].class, values));
        }
    }

    public static final class DoubleInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(double[].class, values));
        }
    }

    public static final class UShortInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert_us(TypeConversionUtil.castToType(short[].class, values));
        }
    }

    public static final class FloatInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(float[].class, values));
        }
    }

    public static final class CharInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(byte[].class, values));
        }
    }

    public static final class ShortInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(short[].class, values));
        }
    }

    public static final class StringInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object values) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(String[].class, values));
        }
    }

    public static final class DevEncodedInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            throw new NumberFormatException("Type DevEncoded not supported");
        }
    }

    public static final class ULong64Inserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert_u64(TypeConversionUtil.castToType(Long.TYPE, value));
        }
    }

    public static final class UCharInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert_uc(TypeConversionUtil.castToType(Byte.TYPE, value));
        }
    }

    public static final class UShortInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert_us(TypeConversionUtil.castToType(Integer.TYPE, value));
        }
    }

    public static final class ULongInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert_ul(TypeConversionUtil.castToType(Long.TYPE, value));
        }
    }

    public static final class FloatInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(Float.TYPE, value).floatValue());
        }
    }

    public static final class IntInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(Integer.TYPE, value));
        }
    }

    public static final class LongInserterArray
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(long[].class, value));
        }
    }

    public static final class LongInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(Long.TYPE, value));
        }
    }

    public static final class ShortInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(Short.TYPE, value));
        }
    }

    public static final class DoubleInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(Double.class, value));
        }
    }

    public static final class BooleanInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(Boolean.class, value));
        }
    }

    public static final class StateInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(DevState.class, value));
        }
    }

    public static final class StringInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) throws DevFailed {
            dd.insert(TypeConversionUtil.castToType(String.class, value));
        }
    }

    public static final class VoidInserter
    implements ICommandInserter {
        @Override
        public void insert(DeviceData dd, Object value) {
        }
    }
}

