/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoDs.TangoConst;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import fr.soleil.tango.clientapi.Properties;
import fr.soleil.tango.clientapi.attribute.ITangoAttribute;
import fr.soleil.tango.clientapi.factory.ProxyFactory;
import fr.soleil.tango.errorstrategy.RetriableTask;
import fr.soleil.tango.errorstrategy.Task;
import java.lang.reflect.Array;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public final class RealAttribute
implements ITangoAttribute {
    private static final String TANGO_WRONG_DATA_ERROR = "TANGO_WRONG_DATA_ERROR";
    private final Logger logger = LoggerFactory.getLogger(RealAttribute.class);
    private AttributeProxy attributeProxy;
    private DeviceAttribute deviceAttribute = null;
    private int dataType;
    private AttrDataFormat dataFormat;
    private AttrWriteType writeType;
    private final String attributeName;
    private final int delay;
    private final int retries;

    public RealAttribute(final String attributeName) throws DevFailed {
        this.attributeName = attributeName;
        this.delay = Properties.getDelay();
        this.retries = Properties.getRetries();
        Task<Void> task = new Task<Void>(){

            @Override
            public Void call() throws DevFailed {
                RealAttribute.this.attributeProxy = ProxyFactory.getInstance().createAttributeProxy(attributeName);
                RealAttribute.this.deviceAttribute = RealAttribute.this.attributeProxy.read();
                AttributeInfo info = RealAttribute.this.attributeProxy.get_info();
                RealAttribute.this.dataType = info.data_type;
                RealAttribute.this.dataFormat = info.data_format;
                RealAttribute.this.writeType = info.writable;
                return null;
            }
        };
        RetriableTask<Void> retriable = new RetriableTask<Void>(this.retries, this.delay);
        retriable.execute(task);
    }

    @Override
    public Object extract() throws DevFailed {
        return InsertExtractUtils.extractRead(this.deviceAttribute, this.dataFormat);
    }

    @Override
    public <T> T extract(Class<T> type) throws DevFailed {
        return InsertExtractUtils.extractRead(this.deviceAttribute, this.dataFormat, type);
    }

    @Override
    public void insert(Object value) throws DevFailed {
        InsertExtractUtils.insert(this.deviceAttribute, value);
    }

    @Override
    public void write() throws DevFailed {
        Task<Void> task = new Task<Void>(){

            @Override
            public Void call() throws DevFailed {
                RealAttribute.this.logger.debug("writing on {}", (Object)RealAttribute.this.attributeName);
                RealAttribute.this.attributeProxy.write(RealAttribute.this.deviceAttribute);
                RealAttribute.this.logger.debug("writing {} DONE", (Object)RealAttribute.this.attributeName);
                return null;
            }
        };
        RetriableTask<Void> retriable = new RetriableTask<Void>(this.retries, this.delay);
        retriable.execute(task);
    }

    @Override
    public void update() throws DevFailed {
        Task<Void> task = new Task<Void>(){

            @Override
            public Void call() throws DevFailed {
                RealAttribute.this.deviceAttribute = RealAttribute.this.attributeProxy.read();
                AttributeInfo info = RealAttribute.this.attributeProxy.get_info();
                RealAttribute.this.dataType = info.data_type;
                RealAttribute.this.dataFormat = info.data_format;
                RealAttribute.this.writeType = info.writable;
                return null;
            }
        };
        RetriableTask<Void> retriable = new RetriableTask<Void>(this.retries, this.delay);
        retriable.execute(task);
    }

    @Override
    public void insertImage(int dimX, int dimY, Object values) throws DevFailed {
        if (!this.dataFormat.equals(AttrDataFormat.IMAGE)) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, "this attribute is spectrum");
        }
        InsertExtractUtils.insert(this.deviceAttribute, values, dimX, dimY);
    }

    @Override
    public Object extractArray() throws DevFailed {
        return InsertExtractUtils.extractReadArray(this.deviceAttribute, this.dataFormat);
    }

    @Override
    public Object extractWrittenArray() throws DevFailed {
        return InsertExtractUtils.extractWriteArray(this.deviceAttribute, this.writeType, this.dataFormat);
    }

    @Override
    public <T> Object extractArray(Class<T> type) throws DevFailed {
        Class<?> typeConv = Array.newInstance(type, 0).getClass();
        return InsertExtractUtils.extractReadArray(this.deviceAttribute, this.dataFormat, typeConv);
    }

    @Override
    public <T> Object extractWrittenArray(Class<T> type) throws DevFailed {
        Class<?> typeConv = Array.newInstance(type, 0).getClass();
        return InsertExtractUtils.extractWriteArray(this.deviceAttribute, this.writeType, this.dataFormat, typeConv);
    }

    @Override
    public Object extractWritten() throws DevFailed {
        return InsertExtractUtils.extractWrite(this.deviceAttribute, this.writeType, this.dataFormat);
    }

    @Override
    public <T> T extractWritten(Class<T> type) throws DevFailed {
        return InsertExtractUtils.extractWrite(this.deviceAttribute, this.dataFormat, this.writeType, type);
    }

    @Override
    public <T> T[] extractSpecOrImage(Class<T> type) throws DevFailed {
        if (this.dataFormat.equals(AttrDataFormat.SCALAR)) {
            throw DevFailedUtils.newDevFailed("FORMAT_ERROR", "attribute must be spectrum or image");
        }
        Class<?> typeConv = Array.newInstance(type, 0).getClass();
        return (Object[])InsertExtractUtils.extractReadArray(this.deviceAttribute, this.dataFormat, typeConv);
    }

    @Override
    public <T> T[] extractWrittenSpecOrImage(Class<T> type) throws DevFailed {
        if (this.dataFormat.equals(AttrDataFormat.SCALAR)) {
            throw DevFailedUtils.newDevFailed("FORMAT_ERROR", "attribute must be spectrum or image");
        }
        Class<?> typeConv = Array.newInstance(type, 0).getClass();
        return (Object[])InsertExtractUtils.extractWriteArray(this.deviceAttribute, this.writeType, this.dataFormat, typeConv);
    }

    @Override
    public String extractToString(String separator, String endSeparator) throws DevFailed {
        String str = "";
        if (this.dataFormat.equals(AttrDataFormat.SCALAR)) {
            str = InsertExtractUtils.extractRead(this.deviceAttribute, this.dataFormat, String.class);
        } else if (this.dataFormat.equals(AttrDataFormat.SPECTRUM)) {
            String[] s = InsertExtractUtils.extractRead(this.deviceAttribute, this.dataFormat, String[].class);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < s.length; ++i) {
                buff.append(s[i]);
                if (i == s.length - 1) continue;
                buff.append(separator);
            }
            str = buff.toString();
        } else if (this.dataFormat.equals(AttrDataFormat.IMAGE)) {
            int dimx = this.deviceAttribute.getDimX();
            int dimy = this.deviceAttribute.getDimY();
            String[] s = InsertExtractUtils.extractRead(this.deviceAttribute, this.dataFormat, String[].class);
            StringBuffer buff = new StringBuffer(s.length);
            for (int i = 0; i < dimy; ++i) {
                for (int j = 0; j < dimx; ++j) {
                    buff.append(s[i * dimx + j]);
                    if (j == dimx - 1) continue;
                    buff.append(separator);
                }
                if (i == dimy - 1) continue;
                buff.append(endSeparator);
            }
            str = buff.toString();
        }
        return str;
    }

    @Override
    public boolean isNumber() {
        boolean isNumber = true;
        if (this.dataType == 1 || this.dataType == 8) {
            isNumber = false;
        }
        return isNumber;
    }

    @Override
    public boolean isBoolean() {
        boolean isBoolean = false;
        if (this.dataType == 1) {
            isBoolean = true;
        }
        return isBoolean;
    }

    @Override
    public boolean isString() {
        boolean isString = false;
        if (this.dataType == 8) {
            isString = true;
        }
        return isString;
    }

    @Override
    public boolean isWritable() {
        boolean isWritable = false;
        if (!this.writeType.equals(AttrWriteType.READ)) {
            isWritable = true;
        }
        return isWritable;
    }

    @Override
    public boolean isScalar() {
        return this.dataFormat.equals(AttrDataFormat.SCALAR);
    }

    @Override
    public boolean isSpectrum() {
        return this.dataFormat.equals(AttrDataFormat.SPECTRUM);
    }

    @Override
    public boolean isImage() {
        return this.dataFormat.equals(AttrDataFormat.IMAGE);
    }

    @Override
    public AttributeProxy getAttributeProxy() {
        return this.attributeProxy;
    }

    @Override
    public DeviceAttribute getDeviceAttribute() {
        return this.deviceAttribute;
    }

    @Override
    public int getDimX() throws DevFailed {
        return this.deviceAttribute.getDimX();
    }

    @Override
    public int getDimY() throws DevFailed {
        return this.deviceAttribute.getDimY();
    }

    @Override
    public int getWrittenDimX() throws DevFailed {
        return this.deviceAttribute.getWrittenDimX();
    }

    @Override
    public int getWrittenDimY() throws DevFailed {
        return this.deviceAttribute.getWrittenDimY();
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public AttrWriteType getWriteType() {
        return this.writeType;
    }

    @Override
    public String getDeviceName() throws DevFailed {
        return TangoUtil.getfullDeviceNameForAttribute(this.attributeName);
    }

    @Override
    public long getTimestamp() throws DevFailed {
        return this.deviceAttribute.getTime();
    }

    @Override
    public AttrDataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        ToStringBuilder str = new ToStringBuilder(this);
        str.append("name", this.getAttributeName());
        String typeString = TangoConst.Tango_CmdArgTypeName[this.getDataType()];
        String formatString = TangoConst.Tango_AttrDataFormatName[this.getDataFormat().value()];
        str.append("type", typeString);
        str.append("format", formatString);
        str.append("writeType", this.getWriteType().value());
        return str.toString();
    }

    @Override
    public AttrQuality getQuality() throws DevFailed {
        return this.deviceAttribute.getQuality();
    }

    @Override
    public void setTimeout(int timeout) throws DevFailed {
        this.attributeProxy.set_timeout_millis(timeout);
    }
}

