/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoDs.TangoConst;
import fr.soleil.tango.clientapi.attribute.ITangoAttribute;
import fr.soleil.tango.clientapi.attribute.MockAttribute;
import fr.soleil.tango.clientapi.attribute.RealAttribute;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.utils.DevFailedUtils;

public final class TangoAttribute {
    private static final String ATTRIBUTE_MUST_BE_SPECTRUM_OR_IMAGE = "attribute must be spectrum or image";
    private static final String LOG_EXTRACTING = "extracting {}";
    private static final String LOG_INSERTING = "inserting {}";
    private final Logger logger = LoggerFactory.getLogger(TangoAttribute.class);
    private static final String TANGO_WRONG_DATA_ERROR = "TANGO_WRONG_DATA_ERROR";
    private static final String THIS_ATTRIBUTE_MUST_BE_A_JAVA_LANG_NUMBER = "this attribute must be a java.lang.Number";
    private final ITangoAttribute attributeImpl;

    public TangoAttribute(String name, Object mockValue) throws DevFailed {
        this.attributeImpl = new MockAttribute(name, mockValue);
    }

    public TangoAttribute(ITangoAttribute attribute) throws DevFailed {
        this.attributeImpl = attribute;
    }

    public TangoAttribute(String name) throws DevFailed {
        this.attributeImpl = new RealAttribute(name);
    }

    public void write() throws DevFailed {
        this.attributeImpl.write();
    }

    public void write(Object value) throws DevFailed {
        this.insert(value);
        this.write();
    }

    public <T> void writeImage(int dimX, int dimY, Object values) throws DevFailed {
        this.insertImage(dimX, dimY, values);
        this.write();
    }

    public void update() throws DevFailed {
        this.attributeImpl.update();
    }

    public <T> T read(Class<T> type) throws DevFailed {
        this.update();
        return this.extract(type);
    }

    public Object read() throws DevFailed {
        this.update();
        return this.extract();
    }

    public Number readAsNumber() throws DevFailed {
        this.update();
        return this.extractNumber();
    }

    public <T> Object readArray(Class<T> type) throws DevFailed {
        this.update();
        return this.extractArray(type);
    }

    public <T> Object readWrittenArray(Class<T> type) throws DevFailed {
        this.update();
        return this.extractWrittenArray(type);
    }

    public <T> T readWritten(Class<T> type) throws DevFailed {
        this.update();
        return this.extractWritten(type);
    }

    public Object readWritten() throws DevFailed {
        this.update();
        return this.extractWritten();
    }

    public Number readWrittenAsNumber() throws DevFailed {
        this.update();
        return this.extractNumberWritten();
    }

    public <T> T[] readSpecOrImage(Class<T> type) throws DevFailed {
        this.update();
        return this.extractSpecOrImage(type);
    }

    public Number[] readSpecOrImageAsNumber() throws DevFailed {
        this.update();
        return this.extractNumberSpecOrImage();
    }

    public <T> T[] readWrittenSpecOrImage(Class<T> type) throws DevFailed {
        this.update();
        return this.extractWrittenSpecOrImage(type);
    }

    public Number[] readWrittenSpecOrImageAsNumber() throws DevFailed {
        this.update();
        return this.extractNumberWrittenSpecOrImage();
    }

    public String readAsString(String separator, String endSeparator) throws DevFailed {
        this.update();
        return this.extractToString(separator, endSeparator);
    }

    public void insert(Object value) throws DevFailed {
        this.logger.debug(LOG_INSERTING, (Object)this);
        this.attributeImpl.insert(value);
    }

    public void insertImage(int dimX, int dimY, Object values) throws DevFailed {
        this.logger.debug(LOG_INSERTING, (Object)this);
        this.attributeImpl.insertImage(dimX, dimY, values);
    }

    public <T> T extract(Class<T> type) throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        return this.attributeImpl.extract(type);
    }

    public <T> Object extractArray(Class<T> type) throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        return this.attributeImpl.extractArray(type);
    }

    public <T> Object extractWrittenArray(Class<T> type) throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        return this.attributeImpl.extractWrittenArray(type);
    }

    public Number extractNumber() throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        Object result = this.attributeImpl.extract();
        if (!Number.class.isAssignableFrom(result.getClass())) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, THIS_ATTRIBUTE_MUST_BE_A_JAVA_LANG_NUMBER);
        }
        return (Number)result;
    }

    public Object extract() throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        return this.attributeImpl.extract();
    }

    public Object extractWritten() throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        return this.attributeImpl.extractWritten();
    }

    public <T> T extractWritten(Class<T> type) throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        return this.attributeImpl.extractWritten(type);
    }

    public Number extractNumberWritten() throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        Object result = this.attributeImpl.extractWritten();
        if (!Number.class.isAssignableFrom(result.getClass())) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, THIS_ATTRIBUTE_MUST_BE_A_JAVA_LANG_NUMBER);
        }
        return (Number)result;
    }

    public <T> T[] extractSpecOrImage(Class<T> type) throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        if (this.attributeImpl.getDataFormat().equals(AttrDataFormat.SCALAR)) {
            throw DevFailedUtils.newDevFailed(ATTRIBUTE_MUST_BE_SPECTRUM_OR_IMAGE);
        }
        return this.attributeImpl.extractSpecOrImage(type);
    }

    public Number[] extractNumberSpecOrImage() throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        if (this.attributeImpl.getDataFormat().equals(AttrDataFormat.SCALAR)) {
            throw DevFailedUtils.newDevFailed(ATTRIBUTE_MUST_BE_SPECTRUM_OR_IMAGE);
        }
        Object result = this.attributeImpl.extractArray();
        if (!Number.class.isAssignableFrom(result.getClass().getComponentType())) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, THIS_ATTRIBUTE_MUST_BE_A_JAVA_LANG_NUMBER);
        }
        return (Number[])result;
    }

    public <T> T[] extractWrittenSpecOrImage(Class<T> type) throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        if (this.attributeImpl.getDataFormat().equals(AttrDataFormat.SCALAR)) {
            throw DevFailedUtils.newDevFailed(ATTRIBUTE_MUST_BE_SPECTRUM_OR_IMAGE);
        }
        return this.attributeImpl.extractSpecOrImage(type);
    }

    public Number[] extractNumberWrittenSpecOrImage() throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        if (this.attributeImpl.getDataFormat().equals(AttrDataFormat.SCALAR)) {
            throw DevFailedUtils.newDevFailed(ATTRIBUTE_MUST_BE_SPECTRUM_OR_IMAGE);
        }
        Object result = this.attributeImpl.extractWrittenArray();
        if (!Number.class.isAssignableFrom(result.getClass().getComponentType())) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, THIS_ATTRIBUTE_MUST_BE_A_JAVA_LANG_NUMBER);
        }
        return (Number[])result;
    }

    public String extractToString(String separator, String endSeparator) throws DevFailed {
        this.logger.debug(LOG_EXTRACTING, (Object)this);
        return this.attributeImpl.extractToString(separator, endSeparator);
    }

    public boolean isNumber() {
        return this.attributeImpl.isNumber();
    }

    public boolean isBoolean() {
        return this.attributeImpl.isBoolean();
    }

    public boolean isString() {
        return this.attributeImpl.isString();
    }

    public boolean isWritable() {
        return this.attributeImpl.isWritable();
    }

    public boolean isScalar() {
        return this.attributeImpl.isScalar();
    }

    public boolean isSpectrum() {
        return this.attributeImpl.isSpectrum();
    }

    public boolean isImage() {
        return this.attributeImpl.isImage();
    }

    public AttributeProxy getAttributeProxy() {
        return this.attributeImpl.getAttributeProxy();
    }

    public DeviceAttribute getDeviceAttribute() {
        return this.attributeImpl.getDeviceAttribute();
    }

    public int getDimX() throws DevFailed {
        return this.attributeImpl.getDimX();
    }

    public int getDimY() throws DevFailed {
        return this.attributeImpl.getDimY();
    }

    public int getWrittenDimX() throws DevFailed {
        return this.attributeImpl.getWrittenDimX();
    }

    public int getWrittenDimY() throws DevFailed {
        return this.attributeImpl.getWrittenDimY();
    }

    public int getDataType() throws DevFailed {
        return this.attributeImpl.getDataType();
    }

    public AttrWriteType getWriteType() {
        return this.attributeImpl.getWriteType();
    }

    public long getTimestamp() throws DevFailed {
        return this.attributeImpl.getTimestamp();
    }

    public AttrQuality getQuality() throws DevFailed {
        return this.attributeImpl.getQuality();
    }

    public String getDeviceName() throws DevFailed {
        return this.attributeImpl.getDeviceName();
    }

    public String getName() {
        return this.attributeImpl.getAttributeName();
    }

    public String toString() {
        ToStringBuilder str = new ToStringBuilder(this);
        str.append("name", this.attributeImpl.getAttributeName());
        String typeString = "UNKOWN";
        try {
            typeString = TangoConst.Tango_CmdArgTypeName[this.attributeImpl.getDataType()];
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        String formatString = TangoConst.Tango_AttrDataFormatName[this.attributeImpl.getDataFormat().value()];
        str.append("type", typeString);
        str.append("format", formatString);
        str.append("writeType", this.attributeImpl.getWriteType().value());
        return str.toString();
    }

    public void setTimeout(int timeout) throws DevFailed {
        this.attributeImpl.setTimeout(timeout);
    }
}

