/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoAppender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class TangoDeviceAppender
extends AppenderSkeleton
implements TangoAppender {
    private DeviceProxy lc_dev_proxy = null;
    private String dev_name = null;

    public TangoDeviceAppender(String device_name, String appender_name, String lcd_name) throws DevFailed {
        this.setName(appender_name);
        this.dev_name = device_name;
        this.lc_dev_proxy = new DeviceProxy(lcd_name);
        try {
            DeviceData dd = new DeviceData();
            dd.insert(this.dev_name);
            this.lc_dev_proxy.command_inout_asynch("Register", dd, true);
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
        if (this.lc_dev_proxy != null) {
            try {
                DeviceData dd = new DeviceData();
                dd.insert(this.dev_name);
                this.lc_dev_proxy.command_inout_asynch("UnRegister", dd, true);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        this.lc_dev_proxy = null;
        this.dev_name = null;
    }

    public void append(LoggingEvent evt) {
        if (this.lc_dev_proxy == null) {
            return;
        }
        try {
            String[] dvsa = new String[]{String.valueOf(evt.timeStamp), evt.getLevel().toString(), evt.getLoggerName(), evt.getRenderedMessage(), "", evt.getThreadName()};
            DeviceData dd = new DeviceData();
            dd.insert(dvsa);
            this.lc_dev_proxy.command_inout_asynch("Log", dd, true);
        }
        catch (DevFailed dv) {
            this.close();
        }
    }

    @Override
    public boolean isValid() {
        if (this.lc_dev_proxy == null) {
            return false;
        }
        try {
            this.lc_dev_proxy.ping();
        }
        catch (DevFailed dv) {
            this.close();
            return false;
        }
        return true;
    }
}

