/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.PollThCmd;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.Util;
import java.util.Random;
import java.util.Vector;
import org.omg.CORBA.Any;

public class PollThread
extends Thread
implements TangoConst {
    private static final int POLL_COMMAND = 0;
    private static final int POLL_TRIGGER = 1;
    private static final int POLL_TIME_OUT = 2;
    static DeviceImpl dev_to_del = null;
    static String name_to_del = "";
    static int type_to_del = 0;
    private final PollThCmd shared_cmd;
    private final TangoMonitor p_mon;
    private final Vector works;
    private final Vector ext_trig_works;
    private final TimeVal now;
    private final TimeVal after;
    private final String[] attr_names;
    private PollThCmd local_cmd;
    private long sleep;
    private boolean polling_stop;

    PollThread(PollThCmd cmd, TangoMonitor m) {
        super("Tango poll thread");
        this.shared_cmd = cmd;
        this.p_mon = m;
        this.sleep = 1L;
        this.polling_stop = false;
        this.attr_names = new String[1];
        this.now = new TimeVal();
        long ctm = System.currentTimeMillis();
        this.now.tv_sec = (int)(ctm / 1000L);
        this.now.tv_usec = (int)(ctm - (long)(1000 * this.now.tv_sec)) * 1000;
        this.now.tv_nsec = 0;
        this.after = new TimeVal();
        this.after.tv_nsec = 0;
        this.works = new Vector();
        this.ext_trig_works = new Vector();
    }

    int get_command(long tout) {
        int ret;
        if (!this.shared_cmd.cmd_pending && !this.shared_cmd.trigger) {
            if (this.works.size() == 0) {
                this.p_mon.wait_it();
            } else if (tout > 0L) {
                this.p_mon.wait_it(tout);
            }
        }
        if (this.shared_cmd.cmd_pending) {
            this.local_cmd = this.shared_cmd;
            ret = 0;
        } else if (this.shared_cmd.trigger) {
            this.local_cmd = this.shared_cmd;
            ret = 1;
        } else {
            ret = 2;
        }
        return ret;
    }

    boolean pred_dev(WorkItem w) {
        return w.dev == dev_to_del;
    }

    boolean pred(WorkItem w) {
        if (w.dev == dev_to_del) {
            if (w.type == type_to_del) {
                return w.name.equals(name_to_del);
            }
            return false;
        }
        return false;
    }

    void execute_cmd() {
        WorkItem wo = new WorkItem();
        block0 : switch (this.local_cmd.cmd_code) {
            case 0: {
                Util.out5.println("Received a Add object command");
                wo.dev = this.local_cmd.dev;
                wo.poll_list = wo.dev.get_poll_obj_list();
                PollObj poll_obj = (PollObj)wo.poll_list.elementAt(this.local_cmd.index);
                wo.type = poll_obj.get_type();
                wo.update = poll_obj.get_upd();
                wo.name = poll_obj.get_name();
                if (wo.update != 0L) {
                    this.now.tv_usec += new Random().nextInt(500000);
                    wo.wake_up_date = this.now;
                    this.insert_in_list(wo);
                    break;
                }
                wo.wake_up_date.tv_sec = 0;
                wo.wake_up_date.tv_usec = 0;
                this.ext_trig_works.add(wo);
                break;
            }
            case 1: {
                Util.out5.println("---> Received a Rem object command");
                dev_to_del = this.local_cmd.dev;
                name_to_del = this.local_cmd.name;
                type_to_del = this.local_cmd.type;
                int nb_elt = this.works.size();
                for (int i = 0; i < nb_elt; ++i) {
                    WorkItem item = (WorkItem)this.works.elementAt(i);
                    if (item.dev != dev_to_del || item.type != type_to_del || !item.name.equals(name_to_del)) continue;
                    this.works.remove(i);
                    break block0;
                }
                break;
            }
            case 5: {
                Util.out5.println("Received a Rem device command");
                dev_to_del = this.local_cmd.dev;
                int nb_elt = this.works.size();
                for (int i = 0; i < nb_elt; ++i) {
                    WorkItem item = (WorkItem)this.works.elementAt(i);
                    if (item.dev != dev_to_del) continue;
                    this.works.remove(i);
                    --i;
                }
                break;
            }
            case 4: {
                Util.out5.println("Received a update polling period command");
                dev_to_del = this.local_cmd.dev;
                name_to_del = this.local_cmd.name;
                type_to_del = this.local_cmd.type;
                int nb_elt = this.works.size();
                for (int i = 0; i < nb_elt; ++i) {
                    WorkItem item = (WorkItem)this.works.elementAt(i);
                    if (item.dev != dev_to_del || item.type != type_to_del || !item.name.equals(name_to_del)) continue;
                    item.update = this.local_cmd.new_upd;
                    break block0;
                }
                break;
            }
            case 2: {
                Util.out5.println("Received a Start polling command");
                this.polling_stop = false;
                break;
            }
            case 3: {
                Util.out5.println("Received a Stop polling command");
                this.polling_stop = true;
            }
        }
        this.shared_cmd.cmd_pending = false;
        this.p_mon.signal();
        if (Util._tracelevel >= 5) {
            this.print_list();
        }
    }

    void one_more_poll() throws DevFailed {
        if (this.works.size() > 0) {
            WorkItem item = (WorkItem)this.works.elementAt(0);
            this.works.remove(0);
            if (!this.polling_stop) {
                if (item.type == 0) {
                    this.poll_cmd(item);
                } else {
                    this.poll_attr(item);
                }
            }
            item.wake_up_date = this.compute_new_date(item.wake_up_date, item.update);
            this.insert_in_list(item);
        }
    }

    void print_list() {
        for (int i = 0; i < this.works.size(); ++i) {
            WorkItem item = (WorkItem)this.works.elementAt(i);
            Util.out4.println("Dev name = " + item.dev.get_name() + ", obj name = " + item.name + ", next wake_up at " + item.wake_up_date.tv_sec + "," + item.wake_up_date.tv_usec);
        }
    }

    void insert_in_list(WorkItem new_work) {
        int i;
        boolean done = false;
        for (i = 0; i < this.works.size() && !done; ++i) {
            WorkItem item = (WorkItem)this.works.elementAt(i);
            if (item.wake_up_date.tv_sec < new_work.wake_up_date.tv_sec) continue;
            if (item.wake_up_date.tv_sec == new_work.wake_up_date.tv_sec) {
                if (item.wake_up_date.tv_usec < new_work.wake_up_date.tv_usec) continue;
                this.works.insertElementAt(new_work, i);
                done = true;
                continue;
            }
            this.works.insertElementAt(new_work, i);
            done = true;
        }
        if (i == this.works.size()) {
            this.works.add(new_work);
        }
    }

    TimeVal compute_new_date(TimeVal time, long upd) {
        double ori_d = (double)time.tv_sec + (double)time.tv_usec / 1000000.0;
        double new_d = ori_d + (double)upd / 1000.0;
        TimeVal ret = new TimeVal();
        ret.tv_sec = (int)new_d;
        ret.tv_usec = (int)((new_d - (double)ret.tv_sec) * 1000000.0);
        return ret;
    }

    TimeVal time_diff(TimeVal before, TimeVal after_t) {
        double bef_d = (double)before.tv_sec + (double)before.tv_usec / 1000000.0;
        double aft_d = (double)after_t.tv_sec + (double)after_t.tv_usec / 1000000.0;
        double diff_d = aft_d - bef_d;
        TimeVal result = new TimeVal();
        result.tv_sec = (int)diff_d;
        result.tv_usec = (int)((diff_d - (double)result.tv_sec) * 1000000.0);
        return result;
    }

    void compute_sleep_time() {
        if (this.works.size() > 0) {
            WorkItem item = (WorkItem)this.works.elementAt(0);
            double next = (double)item.wake_up_date.tv_sec + (double)item.wake_up_date.tv_usec / 1000000.0;
            double after_d = (double)this.after.tv_sec + (double)this.after.tv_usec / 1000000.0;
            double diff = next - after_d;
            if (diff < 0.0) {
                if (Util.fabs(diff) < 0.5) {
                    this.sleep = 0L;
                } else {
                    while (diff < 0.0 && Util.fabs(diff) > 0.5) {
                        Util.out5.println(diff + " > " + 0.5);
                        Util.out5.println("Discard one elt !!!!!!!!!!!!!");
                        item = (WorkItem)this.works.elementAt(0);
                        this.compute_new_date(item.wake_up_date, item.update);
                        this.insert_in_list(item);
                        this.works.remove(0);
                        item = (WorkItem)this.works.elementAt(0);
                        next = (double)item.wake_up_date.tv_sec + (double)item.wake_up_date.tv_usec / 1000000.0;
                        diff = next - after_d;
                    }
                    this.sleep = Util.fabs(diff) < 0.5 ? 0L : (long)(diff * 1000.0);
                }
            } else {
                this.sleep = (long)(diff * 1000.0);
            }
            Util.out5.println("Sleep for : " + this.sleep);
        }
    }

    void poll_cmd(WorkItem to_do) throws DevFailed {
        Util.out5.println("poll_cmd  --> Time = " + this.now.tv_sec + "," + this.now.tv_usec + " Dev name = " + to_do.dev.get_name() + ", Cmd name = " + to_do.name);
        TimeVal before_cmd = new TimeVal();
        TimeVal after_cmd = new TimeVal();
        try {
            long ctm = System.currentTimeMillis();
            before_cmd.tv_sec = (int)(ctm / 1000L);
            before_cmd.tv_usec = (int)(ctm - (long)(1000 * before_cmd.tv_sec)) * 1000;
            before_cmd.tv_sec -= 1002000000;
            Any in_any = ApiUtil.get_orb().create_any();
            Any argout = to_do.dev.command_inout(to_do.name, in_any);
            ctm = System.currentTimeMillis();
            after_cmd.tv_sec = (int)(ctm / 1000L);
            after_cmd.tv_usec = (int)(ctm - (long)(1000 * after_cmd.tv_sec)) * 1000;
            after_cmd.tv_sec -= 1002000000;
            TimeVal needed_time = this.time_diff(before_cmd, after_cmd);
            to_do.dev.get_dev_monitor().get_monitor();
            PollObj poll_obj = to_do.dev.get_polled_obj_by_type_name(to_do.type, to_do.name);
            poll_obj.insert_data(argout, before_cmd, needed_time);
            to_do.dev.get_dev_monitor().rel_monitor();
        }
        catch (DevFailed e) {
            long ctm = System.currentTimeMillis();
            after_cmd.tv_sec = (int)(ctm / 1000L);
            after_cmd.tv_usec = (int)(ctm - (long)(1000 * after_cmd.tv_sec)) * 1000;
            after_cmd.tv_sec -= 1002000000;
            TimeVal needed_time = this.time_diff(before_cmd, after_cmd);
            try {
                PollObj poll_obj = to_do.dev.get_polled_obj_by_type_name(to_do.type, to_do.name);
                poll_obj.insert_except(e, before_cmd, needed_time);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            to_do.dev.get_dev_monitor().rel_monitor();
        }
    }

    void poll_attr(WorkItem to_do) throws DevFailed {
        Util.out5.println("----------> Time = " + this.now.tv_sec + "," + this.now.tv_usec + " Dev name = " + to_do.dev.get_name() + ", Attr name = " + to_do.name);
        TimeVal before_cmd = new TimeVal();
        TimeVal after_cmd = new TimeVal();
        try {
            long ctm = System.currentTimeMillis();
            before_cmd.tv_sec = (int)(ctm / 1000L);
            before_cmd.tv_usec = (int)(ctm - (long)(1000 * before_cmd.tv_sec)) * 1000;
            before_cmd.tv_sec -= 1002000000;
            this.attr_names[0] = to_do.name;
            AttributeValue[] argout = to_do.dev.read_attributes(this.attr_names);
            ctm = System.currentTimeMillis();
            after_cmd.tv_sec = (int)(ctm / 1000L);
            after_cmd.tv_usec = (int)(ctm - (long)(1000 * after_cmd.tv_sec)) * 1000;
            after_cmd.tv_sec -= 1002000000;
            TimeVal needed_time = this.time_diff(before_cmd, after_cmd);
            to_do.dev.get_dev_monitor().get_monitor();
            PollObj poll_obj = to_do.dev.get_polled_obj_by_type_name(to_do.type, to_do.name);
            if (poll_obj.get_upd() > 0) {
                poll_obj.insert_data(argout[0], before_cmd, needed_time);
            }
            to_do.dev.get_dev_monitor().rel_monitor();
        }
        catch (DevFailed e) {
            Except.print_exception(e);
            long ctm = System.currentTimeMillis();
            after_cmd.tv_sec = (int)(ctm / 1000L);
            after_cmd.tv_usec = (int)(ctm - (long)(1000 * after_cmd.tv_sec)) * 1000;
            after_cmd.tv_sec -= 1002000000;
            TimeVal needed_time = this.time_diff(before_cmd, after_cmd);
            try {
                PollObj poll_obj = to_do.dev.get_polled_obj_by_type_name(to_do.type, to_do.name);
                poll_obj.insert_except(e, before_cmd, needed_time);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            to_do.dev.get_dev_monitor().rel_monitor();
        }
    }

    void one_more_trigg() throws DevFailed {
        Util.out5.println("Polling thread has received a trigger");
        WorkItem item = null;
        for (int i = 0; i < this.ext_trig_works.size(); ++i) {
            WorkItem w = (WorkItem)this.ext_trig_works.elementAt(i);
            if (w.dev != this.local_cmd.dev || w.type != this.local_cmd.type || !w.name.equals(this.local_cmd.name)) continue;
            item = w;
        }
        if (item == null) {
            Util.out5.println("Object externally triggered not found !!!");
            this.shared_cmd.trigger = false;
            this.p_mon.signal();
            return;
        }
        this.shared_cmd.trigger = false;
        this.p_mon.signal();
        WorkItem tmp = item;
        if (!this.polling_stop) {
            if (tmp.type == 0) {
                this.poll_cmd(tmp);
            } else {
                this.poll_attr(tmp);
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    int received = this.sleep != 0L ? this.get_command(this.sleep) : 2;
                    long ctm = System.currentTimeMillis();
                    this.now.tv_sec = (int)(ctm / 1000L);
                    this.now.tv_usec = (int)(ctm - (long)(1000 * this.now.tv_sec)) * 1000;
                    this.now.tv_sec -= 1002000000;
                    switch (received) {
                        case 0: {
                            this.execute_cmd();
                            break;
                        }
                        case 2: {
                            this.one_more_poll();
                            break;
                        }
                        case 1: {
                            this.one_more_trigg();
                        }
                    }
                    ctm = System.currentTimeMillis();
                    this.after.tv_sec = (int)(ctm / 1000L);
                    this.after.tv_usec = (int)(ctm - (long)(1000 * this.after.tv_sec)) * 1000;
                    this.after.tv_sec -= 1002000000;
                    this.compute_sleep_time();
                }
            }
            catch (DevFailed e) {
                Util.out2.println("OUPS !! A thread fatal exception !!!!!!!!");
                Except.print_exception(e);
                Util.out2.println("Trying to re-enter the main loop");
                continue;
            }
            break;
        }
    }

    class WorkItem {
        DeviceImpl dev;
        Vector poll_list;
        TimeVal wake_up_date = new TimeVal();
        long update;
        int type;
        String name;

        WorkItem() {
            this.poll_list = new Vector();
        }

        public String toString() {
            return this.name + " - " + this.update + " ms ";
        }
    }
}

