/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.AttrProperty;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import fr.esrf.TangoDs.WAttribute;
import java.util.Vector;

public class MultiAttribute
implements TangoConst {
    private static final AttrProperty[] def_opt_prop = new AttrProperty[]{new AttrProperty("label", "No label"), new AttrProperty("description", "No description"), new AttrProperty("unit", "No unit"), new AttrProperty("standard_unit", "No standard unit"), new AttrProperty("display_unit", "No display unit"), new AttrProperty("format", "No format"), new AttrProperty("min_value", "Not specified"), new AttrProperty("max_value", "Not specified"), new AttrProperty("min_alarm", "Not specified"), new AttrProperty("max_alarm", "Not specified"), new AttrProperty("writable_attr_name", "None")};
    protected Vector attr_list = new Vector();
    protected Vector writable_attr_list = new Vector();
    protected Vector alarm_attr_list = new Vector();

    public MultiAttribute(String dev_name, DeviceClass dev_class) throws DevFailed {
        int i;
        Util.out4.println("Entering MultiAttribute class constructor for device " + dev_name);
        Vector tmp_attr_list = dev_class.get_class_attr().get_attr_list();
        String[] attrlist = new String[tmp_attr_list.size()];
        for (int i2 = 0; i2 < tmp_attr_list.size(); ++i2) {
            attrlist[i2] = ((Attr)tmp_attr_list.get(i2)).get_name();
        }
        DbAttribute[] db_attr = new DbAttribute[]{};
        if (Util._UseDb) {
            db_attr = ApiUtil.get_db_obj().get_device_attribute_property(dev_name, attrlist);
        }
        for (i = 0; i < attrlist.length; ++i) {
            Attr attr = dev_class.get_class_attr().get_attr(((Attr)tmp_attr_list.elementAt(i)).get_name());
            Vector class_prop = attr.get_class_properties();
            Vector def_user_prop = attr.get_user_default_properties();
            Vector<AttrProperty> dev_prop = new Vector<AttrProperty>();
            if (Util._UseDb) {
                String[] propnames = db_attr[i].get_property_list();
                for (int p = 0; p < propnames.length; ++p) {
                    AttrProperty property = new AttrProperty(propnames[p], db_attr[i].get_value(p));
                    dev_prop.add(property);
                }
            }
            Vector prop_list = new Vector();
            this.concat(dev_prop, class_prop, prop_list);
            this.add_user_default(prop_list, def_user_prop);
            this.add_default(prop_list);
            Attribute attribute = attr.get_writable() == AttrWriteType.WRITE || attr.get_writable() == AttrWriteType.READ_WRITE ? new WAttribute(prop_list, attr, dev_name) : new Attribute(prop_list, attr, dev_name);
            this.attr_list.add(attribute);
            if (attribute.get_writable() == AttrWriteType.WRITE || attribute.get_writable() == AttrWriteType.READ_WRITE) {
                this.writable_attr_list.addElement(i);
            }
            if (attribute.is_alarmed() && attribute.get_writable() != AttrWriteType.WRITE) {
                this.alarm_attr_list.addElement(i);
            }
            Util.out4.println(this.attr_list.elementAt(i));
        }
        for (i = 0; i < tmp_attr_list.size(); ++i) {
            this.check_associated(i, dev_name);
        }
        Util.out4.println("Leaving MultiAttribute class constructor");
    }

    private void concat(Vector dev_prop, Vector class_prop, Vector result) {
        int i;
        for (i = 0; i < dev_prop.size(); ++i) {
            result.addElement(dev_prop.elementAt(i));
        }
        Vector tmp_result = (Vector)result.clone();
        int nb_class_check = class_prop.size();
        for (i = 0; i < nb_class_check; ++i) {
            int j;
            for (j = 0; j < tmp_result.size() && !((AttrProperty)tmp_result.elementAt(j)).get_name().equals(((AttrProperty)class_prop.elementAt(i)).get_name()); ++j) {
            }
            if (j != tmp_result.size()) continue;
            result.addElement(class_prop.elementAt(i));
        }
    }

    private void add_default(Vector prop_list) {
        int nb_opt_prop = def_opt_prop.length;
        for (int i = 0; i < nb_opt_prop; ++i) {
            int j;
            String opt_prop_name = def_opt_prop[i].get_name();
            for (j = 0; j < prop_list.size() && !((AttrProperty)prop_list.elementAt(j)).get_name().equals(opt_prop_name); ++j) {
            }
            if (j != prop_list.size()) continue;
            prop_list.addElement(def_opt_prop[i]);
        }
    }

    void add_user_default(Vector prop_list, Vector user_default) {
        int nb_user = user_default.size();
        for (int i = 0; i < nb_user; ++i) {
            int j;
            String user_prop_name = ((AttrProperty)user_default.elementAt(i)).get_name();
            for (j = 0; j < prop_list.size() && !((AttrProperty)prop_list.elementAt(j)).get_name().equals(user_prop_name); ++j) {
            }
            if (j != prop_list.size()) continue;
            prop_list.addElement(user_default.elementAt(i));
        }
    }

    void check_associated(int index, String dev_name) throws DevFailed {
        Attribute att = (Attribute)this.attr_list.elementAt(index);
        if (att.get_writable() == AttrWriteType.READ_WITH_WRITE || att.get_writable() == AttrWriteType.READ_WRITE) {
            StringBuffer o;
            Attribute tmp_att;
            int j;
            if (att.get_data_format().value() != 0) {
                StringBuffer o2 = new StringBuffer("Device --> ");
                o2.append(dev_name);
                o2.append("\nProperty writable_attr_name for attribute ");
                o2.append(att.get_name());
                o2.append(" is defined but this attribute data format is not SCALAR");
                Except.throw_exception("API_AttrOptProp", o2.toString(), "MultiAttribute.check_associated");
            }
            int tmp_ind = 0;
            String assoc_name = att.get_assoc_name();
            for (j = 0; j < this.writable_attr_list.size() && !((Attribute)this.attr_list.elementAt(tmp_ind = ((Integer)this.writable_attr_list.elementAt(j)).intValue())).get_name().equals(assoc_name); ++j) {
            }
            if (j == this.writable_attr_list.size()) {
                StringBuffer o3 = new StringBuffer("Device --> ");
                o3.append(dev_name);
                o3.append("\nProperty writable_attr_name for attribute ");
                o3.append(att.get_name());
                o3.append(" is set to ");
                o3.append(assoc_name);
                o3.append(", but this attribute does not exists or is not writable");
                Except.throw_exception("API_AttrOptProp", o3.toString(), "MultiAttribute.check_associated");
            }
            if ((tmp_att = (Attribute)this.attr_list.elementAt(tmp_ind)).get_data_format().value() != 0) {
                o = new StringBuffer("Device --> ");
                o.append(dev_name);
                o.append("\nProperty writable_attr_name for attribute ");
                o.append(att.get_name());
                o.append(" is set to ");
                o.append(assoc_name);
                o.append(", but this attribute is not of the SCALAR data format");
                Except.throw_exception("API_AttrOptProp", o.toString(), "MultiAttribute.check_assiocated");
            }
            if (tmp_att.get_data_type() != att.get_data_type()) {
                o = new StringBuffer("Device --> ");
                o.append(dev_name);
                o.append("\nProperty writable_attr_name for attribute ");
                o.append(att.get_name());
                o.append(" is set to ");
                o.append(assoc_name);
                o.append(", but these two attributes do not support the same data type");
                Except.throw_exception("API_AttrOptProp", o.toString(), "MultiAttribute.check_associated");
            }
            att.set_assoc_ind(tmp_ind);
        }
    }

    void add_attribute(String dev_name, DeviceClass dev_class, int index) throws DevFailed {
        Util.out4.println("Entering MultiAttribute::add_attribute");
        Vector tmp_attr_list = dev_class.get_class_attr().get_attr_list();
        Attr attr = (Attr)tmp_attr_list.get(index);
        DbAttribute db_attr = null;
        if (Util._UseDb) {
            db_attr = ApiUtil.get_db_obj().get_device_attribute_property(dev_name, attr.get_name());
        }
        Vector class_prop = attr.get_class_properties();
        Vector def_user_prop = attr.get_user_default_properties();
        Vector<AttrProperty> dev_prop = new Vector<AttrProperty>();
        if (Util._UseDb) {
            assert (db_attr != null);
            String[] propnames = db_attr.get_property_list();
            for (int p = 0; p < propnames.length; ++p) {
                AttrProperty property = new AttrProperty(propnames[p], db_attr.get_value(p));
                dev_prop.add(property);
            }
        }
        Vector prop_list = new Vector();
        this.concat(dev_prop, class_prop, prop_list);
        this.add_user_default(prop_list, def_user_prop);
        this.add_default(prop_list);
        Attribute attribute = attr.get_writable() == AttrWriteType.WRITE || attr.get_writable() == AttrWriteType.READ_WRITE ? new WAttribute(prop_list, attr, dev_name) : new Attribute(prop_list, attr, dev_name);
        this.attr_list.add(attribute);
        if (attribute.get_writable() == AttrWriteType.WRITE || attribute.get_writable() == AttrWriteType.READ_WRITE) {
            this.writable_attr_list.addElement(index);
        }
        if (attribute.is_alarmed() && attribute.get_writable() != AttrWriteType.WRITE) {
            this.alarm_attr_list.addElement(index);
        }
        this.check_associated(this.attr_list.size() - 1, dev_name);
        Util.out4.println("Leaving MultiAttribute::add_attribute");
    }

    public void remove_attribute(String attname) throws DevFailed {
        Attribute attr = this.get_attr_by_name(attname);
        this.attr_list.remove(attr);
    }

    public Attribute get_attr_by_name(String attr_name) throws DevFailed {
        Attribute attribute = null;
        for (int i = 0; i < this.attr_list.size(); ++i) {
            Attribute att = (Attribute)this.attr_list.elementAt(i);
            if (!att.get_name().equalsIgnoreCase(attr_name)) continue;
            attribute = att;
        }
        if (attribute == null) {
            Util.out3.println("MultiAttribute.get_attr throwing exception");
            Except.throw_exception("API_AttrNotFound", attr_name + " attribute not found", "MultiAttribute.get_attr");
        }
        return attribute;
    }

    public WAttribute get_w_attr_by_name(String attr_name) throws DevFailed {
        Attribute att = this.get_attr_by_name(attr_name);
        return (WAttribute)att;
    }

    public int get_attr_ind_by_name(String attr_name) throws DevFailed {
        int i;
        int nb_attr = this.attr_list.size();
        for (i = 0; i < nb_attr && !((Attribute)this.attr_list.elementAt(i)).get_name().equalsIgnoreCase(attr_name); ++i) {
        }
        if (i == nb_attr) {
            Util.out3.println("MultiAttribute.get_attr_ind_by_name throwing exception");
            Except.throw_exception("API_AttrNotFound", attr_name + " attribute not found", "MultiAttribute.get_attr_ind_by_name");
        }
        return i;
    }

    public boolean check_alarm() throws DevFailed {
        boolean ret = false;
        int nb_alarm = this.alarm_attr_list.size();
        for (int i = 0; i < nb_alarm; ++i) {
            boolean tmp_ret = this.check_alarm((Integer)this.alarm_attr_list.elementAt(i));
            if (!tmp_ret) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean check_alarm(String attr_name) throws DevFailed {
        return this.get_attr_by_name(attr_name).check_alarm();
    }

    public boolean check_alarm(int ind) throws DevFailed {
        return this.get_attr_by_ind(ind).check_alarm();
    }

    void add_write_value(Attribute att) {
        WAttribute assoc_att = this.get_w_attr_by_ind(att.get_assoc_ind());
        switch (att.get_data_type()) {
            case 1: {
                boolean bool_write_val = assoc_att.getBooleanWriteValue();
                att.add_write_value(bool_write_val);
                break;
            }
            case 2: {
                short sh_write_val = assoc_att.getShortWriteValue();
                att.add_write_value(sh_write_val);
                break;
            }
            case 6: {
                short ush_write_val = assoc_att.getShortWriteValue();
                att.add_write_value(ush_write_val);
                break;
            }
            case 3: {
                int lg_write_val = assoc_att.getLongWriteValue();
                att.add_write_value(lg_write_val);
                break;
            }
            case 7: {
                int ulg_write_val = assoc_att.getLongWriteValue();
                att.add_write_value(ulg_write_val);
                break;
            }
            case 23: {
                long lg64_write_val = assoc_att.getLong64WriteValue();
                att.add_write_value(lg64_write_val);
                break;
            }
            case 24: {
                long ulg64_write_val = assoc_att.getULong64WriteValue();
                att.add_write_value(ulg64_write_val);
                break;
            }
            case 5: {
                double db_write_val = assoc_att.getDoubleWriteValue();
                att.add_write_value(db_write_val);
                break;
            }
            case 8: {
                String str_write_val = assoc_att.getStringWriteValue();
                att.add_write_value(str_write_val);
            }
        }
    }

    public void read_alarm(StringBuffer status) {
        for (int i = 0; i < this.alarm_attr_list.size(); ++i) {
            Attribute att = this.get_attr_by_ind((Integer)this.alarm_attr_list.elementAt(i));
            if (att.get_quality().value() != 2) continue;
            if (att.is_min_alarm()) {
                status.append("\nAlarm : Value too low for attribute ");
                status.append(att.get_name());
            }
            if (!att.is_max_alarm()) continue;
            status.append("\nAlarm : Value too high for attribute ");
            status.append(att.get_name());
        }
    }

    public Vector get_alarm_list() {
        return this.alarm_attr_list;
    }

    public int get_attr_nb() {
        return this.attr_list.size();
    }

    public Attribute get_attr_by_ind(int ind) {
        return (Attribute)this.attr_list.elementAt(ind);
    }

    public WAttribute get_w_attr_by_ind(int ind) {
        return (WAttribute)this.attr_list.elementAt(ind);
    }
}

