/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.Tango.ZmqCallInfo;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceInterface;
import fr.esrf.TangoApi.DevicePipe;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoApi.events.ZMQutils;
import fr.esrf.TangoApi.events.ZmqEventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZmqMainThread
extends Thread {
    private static final int HearBeatSock = 0;
    private static final int EventSock = 1;
    private static final int ControlSock = 2;
    private ZMQ.Socket controlSocket;
    private ZMQ.Socket heartbeatSocket;
    private ZMQ.Socket eventSocket;
    private ZmqPollers pollers;
    private boolean stop = false;
    private Hashtable<String, EventList> connectedMap = new Hashtable();
    private int heartbeatDrift = 0;
    private int eventDrift = 0;
    private static final int NameIdx = 0;
    private static final int EndianIdx = 1;
    private static final int ZmqInfoIdx = 2;
    private static final int ValueIdx = 3;
    private static final int NbFields = 4;
    private static final long SendHwmSocket = 10000L;
    private static int zmqSubscribeCounter = 0;
    private boolean traceZmqSub = false;
    private boolean traceZmqSubRead = false;

    ZmqMainThread(ZMQ.Context context) {
        this.setName("ZmqMainThread");
        this.controlSocket = context.socket(4);
        this.heartbeatSocket = context.socket(2);
        this.eventSocket = context.socket(2);
        this.controlSocket.setLinger(0L);
        this.controlSocket.bind("inproc://control");
        this.heartbeatSocket.setLinger(0L);
        this.eventSocket.setLinger(0L);
        this.eventSocket.setSndHWM(10000L);
        try {
            this.heartbeatSocket.setReconnectIVL(-1L);
            this.eventSocket.setReconnectIVL(-1L);
        }
        catch (Exception e) {
            long longDelay = 300000L;
            this.heartbeatSocket.setReconnectIVL(longDelay);
            this.eventSocket.setReconnectIVL(longDelay);
        }
        this.pollers = new ZmqPollers(context, 3);
        this.pollers.register(this.heartbeatSocket, 1);
        this.pollers.register(this.eventSocket, 1);
        this.pollers.register(this.controlSocket, 1);
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                this.pollers.poll();
                for (int i = 0; i < this.pollers.getSize(); ++i) {
                    if (!this.pollers.pollin(i)) continue;
                    this.manageInputBuffer(i);
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }
        ApiUtil.printTrace("------------ End of ZmqMainThread ---------------");
    }

    private byte[][] readSocket(ZMQ.Socket socket, int nb) {
        int i;
        byte[][] inputs = new byte[nb][];
        if (socket == this.heartbeatSocket) {
            if (this.heartbeatDrift > 0) {
                System.err.println("------> try to resynchronize heartbeat (" + this.heartbeatDrift + ")");
                for (i = 0; i < this.heartbeatDrift; ++i) {
                    this.heartbeatSocket.recv(0);
                }
                this.heartbeatDrift = 0;
            }
        } else if (socket == this.eventSocket && this.eventDrift > 0) {
            System.err.println("------> try to resynchronize event (" + this.eventDrift + ")");
            for (i = 0; i < this.eventDrift; ++i) {
                this.eventSocket.recv(0);
            }
            this.eventDrift = 0;
        }
        for (i = 0; i < nb; ++i) {
            inputs[i] = socket.recv(0);
        }
        return inputs;
    }

    private void manageInputBuffer(int source) {
        switch (source) {
            case 2: {
                try {
                    byte[] inputBuffer = this.controlSocket.recv(0);
                    this.manageControl(inputBuffer);
                    this.controlSocket.send("".getBytes(), 0);
                }
                catch (DevFailed e) {
                    this.controlSocket.send(e.errors[0].desc.getBytes(), 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.controlSocket.send(e.toString().getBytes(), 0);
                }
                break;
            }
            case 0: {
                try {
                    byte[][] inputs = this.readSocket(this.heartbeatSocket, 3);
                    this.manageHeartbeat(inputs);
                }
                catch (DevFailed e) {
                    Except.print_exception(e);
                }
                break;
            }
            case 1: {
                try {
                    byte[][] inputs = this.readSocket(this.eventSocket, 4);
                    this.manageEvent(inputs);
                    break;
                }
                catch (DevFailed e) {
                    Except.print_exception(e);
                }
            }
        }
    }

    private String getDeviceName(String eventName) {
        int pos = eventName.lastIndexOf(46);
        return eventName.substring(0, pos);
    }

    private String getEventName(byte[] inputs) {
        String s = new String(inputs);
        int pos = s.lastIndexOf(46);
        for (int i = 0; i < 4; ++i) {
            pos = s.lastIndexOf(47, pos - 1);
        }
        return s.substring(pos + 1);
    }

    private void checkEventMessage(byte[][] inputs) throws Exception {
        if (inputs.length < 4) {
            System.err.println("NbFields=4");
            this.eventDrift = 4 - inputs.length;
            Except.throw_exception("Api_BadParameterException", "Cannot decode event  (message size !)", "ZmqMainThread.checkEventMessage()");
        }
        if (new String(inputs[0]).startsWith("tango://")) {
            return;
        }
        byte[] bytes = inputs[0];
        if (bytes.length == 1) {
            this.eventDrift = 3;
            Except.throw_exception("Api_BadParameterException", "Cannot decode event  (start with endianess)", "ZmqMainThread.checkEventMessage()");
        } else if (bytes[0] == 12 && bytes[1] == 0 && bytes[2] == 13 && bytes[3] == 14) {
            this.eventDrift = 1;
            Except.throw_exception("Api_BadParameterException", "Cannot decode event  (start with data)", "ZmqMainThread.checkEventMessage()");
        } else {
            this.eventDrift = 2;
            Except.throw_exception("Api_BadParameterException", "Cannot decode event  (start with specifications)", "ZmqMainThread.checkEventMessage()");
        }
    }

    private void manageEvent(byte[][] inputs) throws DevFailed {
        try {
            ZmqCallInfo zmqCallInfo;
            this.checkEventMessage(inputs);
            String eventName = new String(inputs[0]);
            boolean littleEndian = true;
            if (inputs[1].length > 0) {
                boolean bl = littleEndian = inputs[1][0] != 0;
            }
            if ((zmqCallInfo = ZMQutils.deMarshallZmqCallInfo(inputs[2], littleEndian)) == null) {
                throw new Exception("DeMarshalling returns null");
            }
            this.manageEventValue(eventName, ApiUtil.toLongUnsigned(zmqCallInfo.ctr), inputs[3], littleEndian, zmqCallInfo.call_is_except);
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            e.printStackTrace();
            Except.throw_exception("Api_CatchException", "API catch a " + e.toString() + " exception", "ZmqMainThread.manageEvent()");
        }
    }

    private EventCallBackStruct getEventCallBackStruct(String eventName) {
        List<String> possibleTangoHosts = EventConsumer.possibleTangoHosts;
        Hashtable<String, EventCallBackStruct> callbackMap = ZmqEventConsumer.getEventCallbackMap();
        if (callbackMap.containsKey(eventName)) {
            return callbackMap.get(eventName);
        }
        int index = eventName.indexOf("//");
        if (index > 0) {
            index = eventName.indexOf(47, index + 2);
            for (String possibleTangoHost : possibleTangoHosts) {
                String key = possibleTangoHost + eventName.substring(index);
                if (!callbackMap.containsKey(key)) continue;
                return callbackMap.get(key);
            }
        }
        return null;
    }

    private void manageEventValue(String eventName, long eventCounter, byte[] recData, boolean littleEndian, boolean isExcept) throws DevFailed {
        EventCallBackStruct callBackStruct = this.getEventCallBackStruct(eventName);
        if (callBackStruct != null) {
            DeviceAttribute attributeValue = null;
            DevicePipe devicePipe = null;
            AttributeInfoEx attributeConfig = null;
            AttDataReady dataReady = null;
            DeviceInterface deviceInterface = null;
            DevError[] devErrorList = null;
            boolean pushTheEvent = this.manageEventCounter(callBackStruct, eventName, eventCounter);
            ZMQutils.zmqEventTrace("ZMQ event from " + eventName);
            if (isExcept) {
                devErrorList = ZMQutils.deMarshallErrorList(recData, littleEndian);
            } else {
                Hashtable<String, EventChannelStruct> channelMap = EventConsumer.getChannelMap();
                EventChannelStruct eventChannelStruct = channelMap.get(callBackStruct.channel_name);
                if (eventChannelStruct != null) {
                    try {
                        int idl = callBackStruct.device.get_idl_version();
                        switch (ZMQutils.getEventType(eventName)) {
                            case 5: {
                                attributeConfig = ZMQutils.deMarshallAttributeConfig(recData, littleEndian, idl);
                                break;
                            }
                            case 8: {
                                devicePipe = ZMQutils.deMarshallPipe(recData, littleEndian, idl);
                                break;
                            }
                            case 6: {
                                dataReady = ZMQutils.deMarshallAttDataReady(recData, littleEndian);
                                break;
                            }
                            case 7: {
                                deviceInterface = ZMQutils.deMarshallAttInterfaceChange(recData, littleEndian);
                                break;
                            }
                            default: {
                                attributeValue = ZMQutils.deMarshallAttribute(recData, littleEndian, idl);
                                break;
                            }
                        }
                    }
                    catch (DevFailed e) {
                        devErrorList = e.errors;
                    }
                }
            }
            if (pushTheEvent) {
                String deviceName = this.getDeviceName(eventName);
                this.pushEventData(callBackStruct, new EventData(callBackStruct.device, deviceName, eventName, callBackStruct.event_type, 0, attributeValue, devicePipe, attributeConfig, dataReady, deviceInterface, devErrorList));
            }
        } else {
            System.err.println(eventName + " ?  NOT FOUND");
        }
    }

    private boolean manageEventCounter(EventCallBackStruct callBackStruct, String eventName, long eventCounter) throws DevFailed {
        long maxCounter;
        long delta2;
        long previousCounter = callBackStruct.getZmqCounter();
        if (previousCounter == Long.MAX_VALUE) {
            callBackStruct.setZmqCounter(eventCounter);
            if (callBackStruct.event_name.equals(TangoConst.eventNames[6])) {
                callBackStruct.setSynchronousDone(true);
            }
            int timeout = 5000;
            for (int i = 0; !callBackStruct.isSynchronousDone() && i < timeout; ++i) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }
        long delta = eventCounter - previousCounter;
        if (delta == 0L) {
            callBackStruct.setZmqCounter(eventCounter);
            return false;
        }
        if (eventCounter <= 0L) {
            callBackStruct.setZmqCounter(eventCounter);
            return false;
        }
        if (delta == 1L) {
            callBackStruct.setZmqCounter(eventCounter);
            return true;
        }
        if (delta < 0L && (delta2 = (maxCounter = ApiUtil.toLongUnsigned(-1)) - delta) == 1L) {
            callBackStruct.setZmqCounter(eventCounter);
            return true;
        }
        long nb = eventCounter - (previousCounter + 1L);
        DevError[] devErrorList = new DevError[]{new DevError("Api_MissedEvents", ErrSeverity.ERR, "Missed " + nb + " events (" + eventCounter + "-" + (previousCounter + 1L) + ") ! ZMQ queue has reached HWM or resynchronize ?", "ZmqMainThread.manageEventCounter()")};
        String deviceName = this.getDeviceName(eventName);
        this.pushEventData(callBackStruct, new EventData(callBackStruct.device, deviceName, eventName, callBackStruct.event_type, 0, null, null, null, null, null, devErrorList));
        callBackStruct.setZmqCounter(eventCounter);
        return true;
    }

    private void pushEventData(EventCallBackStruct callBackStruct, EventData eventData) {
        if (callBackStruct.use_ev_queue) {
            EventQueue ev_queue = callBackStruct.device.getEventQueue();
            ev_queue.insert_event(eventData);
        } else if (callBackStruct.callback != null) {
            callBackStruct.callback.push_event(eventData);
        }
    }

    private void manageHeartbeat(byte[][] inputs) throws DevFailed {
        String name = new String(inputs[0]);
        int start = name.indexOf("dserver/");
        if (start < 0) {
            long t = System.currentTimeMillis();
            System.err.println(ZmqMainThread.formatTime(t) + ":\n heartbeat: " + name + " cannot be parsed ! length=" + inputs[0].length);
            ZMQutils.dump(inputs[0]);
            this.heartbeatDrift = inputs[0].length == 1 ? 2 : 1;
            return;
        }
        int end = name.lastIndexOf(46);
        name = name.substring(0, end);
        ZmqEventConsumer.getInstance().push_structured_event_heartbeat(name);
        if (inputs[1].length == 0) {
            System.err.println("heartbeat " + name + ":   endianess is missing !!!");
        }
    }

    private String getConnectedEndPoint(String eventName) {
        Enumeration<String> keys = this.connectedMap.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            EventList events = this.connectedMap.get(key);
            for (String event : events) {
                if (!event.equals(eventName)) continue;
                return key;
            }
        }
        return null;
    }

    private boolean isForcedJustified(ZMQutils.ControlStructure controlStructure) {
        EventList events = this.connectedMap.get(controlStructure.endPoint);
        if (events == null) {
            return true;
        }
        if (events.size() == 0) {
            return true;
        }
        return ((String)events.get(0)).equals(controlStructure.eventName);
    }

    private boolean alreadyConnected(String endPoint) {
        return this.connectedMap.containsKey(endPoint);
    }

    private void manageControl(byte[] messageBytes) throws DevFailed {
        ZMQutils.ControlStructure controlStructure = ZMQutils.getInstance().decodeControlBuffer(messageBytes);
        ApiUtil.printTrace("From Control:\n" + controlStructure);
        switch (controlStructure.commandCode) {
            case 0: {
                this.stop = true;
                break;
            }
            case 1: {
                this.connectIfNotDone(this.heartbeatSocket, controlStructure);
                this.heartbeatSocket.subscribe(controlStructure.eventName.getBytes());
                break;
            }
            case 2: {
                this.disconnect(this.heartbeatSocket, controlStructure.eventName);
                break;
            }
            case 3: {
                this.connectIfNotDone(this.eventSocket, controlStructure);
                this.eventSocket.subscribe(controlStructure.eventName.getBytes());
                break;
            }
            case 4: {
                this.disconnect(this.eventSocket, controlStructure.eventName);
            }
        }
    }

    private void connectIfNotDone(ZMQ.Socket socket, ZMQutils.ControlStructure controlStructure) {
        this.traceZmqSubscription(controlStructure.eventName, true);
        if (controlStructure.forceReconnection || !this.alreadyConnected(controlStructure.endPoint)) {
            ApiUtil.printTrace("Set socket buffer for HWM to " + controlStructure.hwm);
            if (controlStructure.forceReconnection && this.alreadyConnected(controlStructure.endPoint)) {
                try {
                    socket.disconnect(controlStructure.endPoint);
                }
                catch (ZMQException e) {
                    System.err.println(e.getMessage());
                }
            }
            socket.setSndHWM(0L);
            socket.setRcvHWM(controlStructure.hwm);
            socket.connect(controlStructure.endPoint);
            if (!this.alreadyConnected(controlStructure.endPoint)) {
                EventList eventList = new EventList();
                eventList.add(controlStructure.eventName);
                this.connectedMap.put(controlStructure.endPoint, eventList);
            } else {
                EventList eventList = this.connectedMap.get(controlStructure.endPoint);
                String s = eventList.getEvent(controlStructure.eventName);
                if (s == null) {
                    eventList.add(controlStructure.eventName);
                }
            }
        } else {
            EventList eventList = this.connectedMap.get(controlStructure.endPoint);
            String s = eventList.getEvent(controlStructure.eventName);
            if (s == null) {
                eventList.add(controlStructure.eventName);
            }
            ApiUtil.printTrace((controlStructure.commandCode == 3 ? "Event" : "Heartbeat") + " already connected to " + controlStructure.endPoint);
        }
    }

    private void disconnect(ZMQ.Socket socket, String eventName) {
        EventList eventList;
        String endpoint = this.getConnectedEndPoint(eventName);
        if (endpoint != null && (eventList = this.connectedMap.get(endpoint)) != null) {
            socket.unsubscribe(eventName.getBytes());
            this.traceZmqSubscription(eventName, false);
            eventList.remove(eventName);
            if (eventList.size() == 0) {
                socket.disconnect(endpoint);
                this.connectedMap.remove(endpoint);
            }
        }
    }

    private void traceZmqSubscription(String eventName, boolean increase) {
        if (!this.traceZmqSubRead) {
            String s = System.getenv("TraceSubscribe");
            this.traceZmqSub = s != null && s.equals("true");
            this.traceZmqSubRead = true;
        }
        if (this.traceZmqSub) {
            String action;
            if (increase) {
                ++zmqSubscribeCounter;
                action = "subscribe";
            } else {
                --zmqSubscribeCounter;
                action = "unsubscribe";
            }
            System.out.println(new Date() + ":  #### " + zmqSubscribeCounter + " -> " + action + " eventSocket to " + eventName);
        }
    }

    private static String formatTime(long ms) {
        StringTokenizer st = new StringTokenizer(new Date(ms).toString());
        ArrayList<String> arrayList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            arrayList.add(st.nextToken());
        }
        String time = (String)arrayList.get(3);
        double d = (double)ms / 1000.0;
        long l = ms / 1000L;
        d = (d - (double)l) * 1000.0;
        ms = (long)d;
        return time + "." + ms;
    }

    private static class EventList
    extends ArrayList<String> {
        private EventList() {
        }

        private String getEvent(String eventName) {
            for (String event : this) {
                if (!event.equals(eventName)) continue;
                return event;
            }
            return null;
        }
    }

    private static class ZmqPollers
    extends ZMQ.Poller {
        private ZmqPollers(ZMQ.Context context, int size) {
            super(context, size);
        }
    }
}

