/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoQualityChangeListener;
import fr.esrf.TangoApi.events.TangoQualityChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoQualityChange
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoQualityChange(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoQualityChangeListener(ITangoQualityChangeListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoQualityChangeListener.class, listener);
        this.event_identifier = this.subscribe_quality_change_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoQualityChangeListener(ITangoQualityChangeListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoQualityChangeListener.class, listener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoQualityChange tangoQualityChange = this;
        if (EventUtil.graphicAvailable()) {
            Runnable do_work_later = new Runnable(){

                @Override
                public void run() {
                    TangoQualityChange.this.fireTangoQualityChangeEvent(tangoQualityChange, eventData);
                }
            };
            SwingUtilities.invokeLater(do_work_later);
        } else {
            this.fireTangoQualityChangeEvent(tangoQualityChange, eventData);
        }
    }

    private void fireTangoQualityChangeEvent(TangoQualityChange tangoQualityChange, EventData eventData) {
        TangoQualityChangeEvent tangoQualityChangeEvent = new TangoQualityChangeEvent(tangoQualityChange, eventData);
        ArrayList<EventListener> listeners = this.event_listeners.getListeners(ITangoQualityChangeListener.class);
        for (EventListener eventListener : listeners) {
            ((ITangoQualityChangeListener)eventListener).qualityChange(tangoQualityChangeEvent);
        }
    }
}

