/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoApi.events.NotifdEventConsumer;
import fr.esrf.TangoApi.events.ZMQutils;
import fr.esrf.TangoApi.events.ZmqEventConsumer;
import java.util.Hashtable;

public class EventConsumerUtil {
    private static EventConsumerUtil instance = null;
    private static boolean zmqTested = false;
    private static boolean zmqLoadable = true;

    public static EventConsumerUtil getInstance() {
        if (instance == null) {
            instance = new EventConsumerUtil();
        }
        return instance;
    }

    private EventConsumerUtil() {
    }

    private EventConsumer isChannelAlreadyConnected(DeviceProxy deviceProxy) {
        try {
            String adminName = deviceProxy.adm_name();
            EventChannelStruct eventChannelStruct = EventConsumer.getChannelMap().get(adminName);
            if (eventChannelStruct == null) {
                return null;
            }
            return eventChannelStruct.consumer;
        }
        catch (DevFailed e) {
            return null;
        }
    }

    public static boolean isZmqLoadable() {
        if (!zmqTested) {
            String zmqEnable = System.getenv("ZMQ_DISABLE");
            if (zmqEnable == null) {
                zmqEnable = System.getProperty("ZMQ_DISABLE");
            }
            if (zmqEnable == null || !zmqEnable.equals("true")) {
                try {
                    ZMQutils.getInstance();
                    System.out.println("========== ZMQ (" + ZMQutils.getZmqVersion() + ") event system is available ============");
                }
                catch (NoClassDefFoundError | UnsatisfiedLinkError error) {
                    System.err.println("======================================================================");
                    System.err.println("  " + error);
                    System.err.println("  Event system will be available only for notifd notification system ");
                    System.err.println("======================================================================");
                    zmqLoadable = false;
                }
            } else {
                System.err.println("======================================================================");
                System.err.println("  ZMQ event system not enabled");
                System.err.println("  Event system will be available only for notifd notification system ");
                System.err.println("======================================================================");
                zmqLoadable = false;
            }
            zmqTested = true;
        }
        return zmqLoadable;
    }

    public int subscribe_event(DeviceProxy device, String attribute, int event, CallBack callback, String[] filters, boolean stateless) throws DevFailed {
        return this.subscribe_event(device, attribute, event, callback, -1, filters, stateless);
    }

    public int subscribe_event(DeviceProxy device, String attribute, int event, int max_size, String[] filters, boolean stateless) throws DevFailed {
        return this.subscribe_event(device, attribute, event, null, max_size, filters, stateless);
    }

    public int subscribe_event(DeviceProxy device, String attribute, int event, CallBack callback, int max_size, String[] filters, boolean stateless) throws DevFailed {
        int id;
        ApiUtil.printTrace("trying to subscribe_event to " + device.name() + "/" + attribute);
        EventConsumer consumer = this.isChannelAlreadyConnected(device);
        if (consumer != null) {
            id = consumer.subscribe_event(device, attribute, event, callback, max_size, filters, stateless);
        } else if (EventConsumerUtil.isZmqLoadable()) {
            try {
                id = ZmqEventConsumer.getInstance().subscribe_event(device, attribute, event, callback, max_size, filters, stateless);
            }
            catch (DevFailed e) {
                ApiUtil.printTrace(e.errors[0].desc);
                if (e.errors[0].desc.equals("Command ZmqEventSubscriptionChange not found")) {
                    id = this.subscribeEventWithNotifd(device, attribute, event, callback, max_size, filters, stateless);
                }
                throw e;
            }
        } else {
            id = this.subscribeEventWithNotifd(device, attribute, event, callback, max_size, filters, stateless);
        }
        return id;
    }

    public int subscribe_event(DeviceProxy device, int event, CallBack callback, int max_size, boolean stateless) throws DevFailed {
        ApiUtil.printTrace("INTERFACE_CHANGE: trying to subscribe_event to " + device.name());
        EventConsumer consumer = this.isChannelAlreadyConnected(device);
        if (consumer != null) {
            int n = consumer.subscribe_event(device, event, callback, max_size, stateless);
        }
        int id = ZmqEventConsumer.getInstance().subscribe_event(device, event, callback, max_size, stateless);
        return id;
    }

    private int subscribeEventWithNotifd(DeviceProxy device, String attribute, int event, CallBack callback, int max_size, String[] filters, boolean stateless) throws DevFailed {
        int id = NotifdEventConsumer.getInstance().subscribe_event(device, attribute, event, callback, max_size, filters, stateless);
        ApiUtil.printTrace(device.name() + "/" + attribute + "  connected to Notifd event system");
        return id;
    }

    public void unsubscribe_event(int event_id) throws DevFailed {
        Hashtable<String, EventCallBackStruct> callBackMap = EventConsumer.getEventCallbackMap();
        EventCallBackStruct callbackStruct = EventConsumer.getCallBackStruct(callBackMap, event_id);
        if (callbackStruct != null) {
            callbackStruct.consumer.unsubscribe_event(event_id);
        }
    }
}

