/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInterface;
import fr.esrf.TangoApi.DevicePipe;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumerUtil;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoApi.events.IEventConsumer;
import fr.esrf.TangoApi.events.KeepAliveThread;
import fr.esrf.TangoApi.events.NotifdEventConsumer;
import fr.esrf.TangoApi.events.ZmqEventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.StructuredPushConsumerPOA;

public abstract class EventConsumer
extends StructuredPushConsumerPOA
implements TangoConst,
IEventConsumer {
    protected static int subscribe_event_id = 0;
    protected static Hashtable<String, EventChannelStruct> channel_map = new Hashtable();
    protected static Hashtable<String, String> device_channel_map = new Hashtable();
    protected static Hashtable<String, EventCallBackStruct> event_callback_map = new Hashtable();
    protected static Hashtable<String, EventCallBackStruct> failed_event_callback_map = new Hashtable();
    static List<String> possibleTangoHosts = new ArrayList<String>();

    protected abstract void checkDeviceConnection(DeviceProxy var1, String var2, DeviceData var3, String var4) throws DevFailed;

    protected abstract void connect_event_channel(ConnectionStructure var1) throws DevFailed;

    protected abstract boolean reSubscribe(EventChannelStruct var1, EventCallBackStruct var2);

    protected abstract void removeFilters(EventCallBackStruct var1) throws DevFailed;

    protected abstract String getEventSubscriptionCommandName();

    protected abstract void checkIfAlreadyConnected(DeviceProxy var1, String var2, String var3, CallBack var4, int var5, boolean var6) throws DevFailed;

    protected abstract void setAdditionalInfoToEventCallBackStruct(EventCallBackStruct var1, String var2, String var3, String var4, String[] var5, EventChannelStruct var6) throws DevFailed;

    protected abstract void unsubscribeTheEvent(EventCallBackStruct var1) throws DevFailed;

    protected abstract void checkIfHeartbeatSkipped(String var1, EventChannelStruct var2);

    protected EventConsumer() throws DevFailed {
        KeepAliveThread.getInstance();
    }

    static Hashtable<String, EventChannelStruct> getChannelMap() {
        return channel_map;
    }

    static Hashtable<String, EventCallBackStruct> getEventCallbackMap() {
        return event_callback_map;
    }

    @Override
    public void disconnect_structured_push_consumer() {
        System.out.println("calling EventConsumer.disconnect_structured_push_consumer()");
    }

    @Override
    public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        System.out.println("calling EventConsumer.offer_change()");
    }

    private EventChannelStruct getEventChannelStruct(String channelName) {
        if (channel_map.containsKey(channelName)) {
            return channel_map.get(channelName);
        }
        int index = channelName.indexOf("//");
        if (index > 0) {
            index = channelName.indexOf(47, index + 2);
            for (String possibleTangoHost : possibleTangoHosts) {
                String key = possibleTangoHost + channelName.substring(index);
                if (!channel_map.containsKey(key)) continue;
                return channel_map.get(key);
            }
        }
        return null;
    }

    protected void push_structured_event_heartbeat(String channelName) {
        try {
            EventChannelStruct eventChannelStruct;
            if (channelName.startsWith("tango://") && (eventChannelStruct = this.getEventChannelStruct(channelName)) != null) {
                eventChannelStruct.last_heartbeat = System.currentTimeMillis();
                return;
            }
            Enumeration<String> keys = channel_map.keys();
            boolean found = false;
            while (keys.hasMoreElements() && !found) {
                String name = keys.nextElement();
                EventChannelStruct eventChannelStruct2 = channel_map.get(name);
                String admDeviceName = eventChannelStruct2.adm_device_proxy.name();
                if (!admDeviceName.equalsIgnoreCase(channelName)) continue;
                eventChannelStruct2.last_heartbeat = System.currentTimeMillis();
                found = true;
            }
            if (!found) {
                System.err.println(channelName + " Not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String callEventSubscriptionAndConnect(DeviceProxy device, String attribute, String eventType) throws DevFailed {
        String deviceName = device.name();
        if (attribute == null) {
            attribute = "";
        }
        String[] info = new String[]{deviceName, attribute, "subscribe", eventType, Integer.toString(device.get_idl_version())};
        DeviceData argIn = new DeviceData();
        argIn.insert(info);
        String cmdName = this.getEventSubscriptionCommandName();
        ApiUtil.printTrace(device.get_adm_dev().name() + ".command_inout(\"" + cmdName + "\") for " + deviceName + "/" + attribute + "." + eventType);
        DeviceData argOut = device.get_adm_dev().command_inout(cmdName, argIn);
        ApiUtil.printTrace("    command_inout done.");
        this.checkDeviceConnection(device, attribute, argOut, eventType);
        int tangoVersion = argOut.extractLongStringArray().lvalue[0];
        ApiUtil.printTrace(deviceName + ": TANGO release is " + tangoVersion);
        if (tangoVersion > 930) {
            String[] strings = argOut.extractLongStringArray().svalue;
            String fullDeviceName = strings[strings.length - 2];
            return fullDeviceName.substring(0, fullDeviceName.lastIndexOf("/"));
        }
        return device.fullName();
    }

    @Override
    public int subscribe_event(DeviceProxy device, String attribute, int event, CallBack callback, String[] filters, boolean stateless) throws DevFailed {
        return this.subscribe_event(device, attribute, event, callback, -1, filters, stateless);
    }

    @Override
    public int subscribe_event(DeviceProxy device, String attribute, int event, int max_size, String[] filters, boolean stateless) throws DevFailed {
        return this.subscribe_event(device, attribute, event, null, max_size, filters, stateless);
    }

    @Override
    public int subscribe_event(DeviceProxy device, String attribute, int event, CallBack callback, int max_size, String[] filters, boolean stateless) throws DevFailed {
        String event_name = eventNames[event];
        ApiUtil.printTrace("=============> subscribing for " + device.name() + (attribute == null ? "" : "/" + attribute) + "." + event_name);
        this.checkIfAlreadyConnected(device, attribute, event_name, callback, max_size, stateless);
        if (callback == null && max_size >= 0 && device.getEventQueue() == null) {
            if (max_size > 0) {
                device.setEventQueue(new EventQueue(max_size));
            } else {
                device.setEventQueue(new EventQueue());
            }
        }
        ApiUtil.printTrace("calling callEventSubscriptionAndConnect() method");
        String att = attribute == null ? null : attribute.toLowerCase();
        String deviceName = this.callEventSubscriptionAndConnect(device, att, event_name);
        ApiUtil.printTrace("call callEventSubscriptionAndConnect() method done");
        String callback_key = deviceName.toLowerCase();
        try {
            if (device.get_idl_version() >= 5) {
                switch (event_name) {
                    case "intr_change": {
                        callback_key = callback_key + "." + event_name;
                        break;
                    }
                    case "pipe": {
                        callback_key = callback_key + "/" + attribute + "." + event_name;
                        break;
                    }
                    default: {
                        callback_key = callback_key + "/" + attribute + ".idl" + device.get_idl_version() + "_" + event_name;
                        break;
                    }
                }
            } else {
                callback_key = callback_key + "/" + attribute + "." + event_name;
            }
        }
        catch (DevFailed e) {
            if (!stateless || e.errors[0].desc.equals("Command ZmqEventSubscriptionChange not found")) {
                throw e;
            }
            EventCallBackStruct new_event_callback_struct = new EventCallBackStruct(device, attribute, event_name, "", callback, max_size, ++subscribe_event_id, event, filters, false);
            failed_event_callback_map.put(callback_key, new_event_callback_struct);
            return subscribe_event_id;
        }
        String channelName = device_channel_map.get(deviceName);
        if (channelName == null) {
            int start = deviceName.indexOf(47, "tango:// ".length());
            deviceName = deviceName.substring(start + 1);
            channelName = device_channel_map.get(deviceName);
        }
        EventChannelStruct event_channel_struct = channel_map.get(channelName);
        event_channel_struct.last_subscribed = System.currentTimeMillis();
        EventCallBackStruct failed_struct = failed_event_callback_map.get(callback_key);
        int evnt_id = failed_struct == null ? ++subscribe_event_id : failed_struct.id;
        EventCallBackStruct new_event_callback_struct = new EventCallBackStruct(device, attribute, event_name, channelName, callback, max_size, evnt_id, event, filters, true);
        this.setAdditionalInfoToEventCallBackStruct(new_event_callback_struct, deviceName, attribute, event_name, filters, event_channel_struct);
        event_callback_map.put(callback_key, new_event_callback_struct);
        if (event == 0 || event == 2 || event == 8 || event == 3 || event == 4 || event == 7 || event == 5) {
            new PushAttrValueLater(new_event_callback_struct).start();
        }
        return evnt_id;
    }

    static void subscribeIfNotDone() {
        Enumeration<String> callbackKeys = failed_event_callback_map.keys();
        while (callbackKeys.hasMoreElements()) {
            String callbackKey = callbackKeys.nextElement();
            EventCallBackStruct eventCallBackStruct = failed_event_callback_map.get(callbackKey);
            if (eventCallBackStruct.consumer != null) {
                try {
                    EventConsumer.subscribeIfNotDone(eventCallBackStruct, callbackKey);
                }
                catch (DevFailed e) {
                    EventConsumer.sendErrorToCallback(eventCallBackStruct, callbackKey, e);
                }
                continue;
            }
            if (EventConsumerUtil.isZmqLoadable()) {
                try {
                    eventCallBackStruct.consumer = ZmqEventConsumer.getInstance();
                    EventConsumer.subscribeIfNotDone(eventCallBackStruct, callbackKey);
                    return;
                }
                catch (DevFailed e) {
                    if (e.errors[0].desc.equals("Command ZmqEventSubscriptionChange not found")) {
                        try {
                            eventCallBackStruct.consumer = NotifdEventConsumer.getInstance();
                            EventConsumer.subscribeIfNotDone(eventCallBackStruct, callbackKey);
                            return;
                        }
                        catch (DevFailed e2) {
                            System.err.println(e2.errors[0].desc);
                            eventCallBackStruct.consumer = null;
                            EventConsumer.sendErrorToCallback(eventCallBackStruct, callbackKey, e2);
                            continue;
                        }
                    }
                    eventCallBackStruct.consumer = null;
                    EventConsumer.sendErrorToCallback(eventCallBackStruct, callbackKey, e);
                    continue;
                }
            }
            try {
                eventCallBackStruct.consumer = NotifdEventConsumer.getInstance();
                EventConsumer.subscribeIfNotDone(eventCallBackStruct, callbackKey);
                return;
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
                EventConsumer.sendErrorToCallback(eventCallBackStruct, callbackKey, e);
            }
        }
    }

    private static void sendErrorToCallback(EventCallBackStruct cs, String callbackKey, DevFailed e) {
        int source = cs.consumer instanceof NotifdEventConsumer ? 1 : 0;
        EventData eventData = new EventData(cs.device, callbackKey, cs.event_name, source, cs.event_type, null, null, null, null, null, e.errors);
        if (cs.use_ev_queue) {
            EventQueue ev_queue = cs.device.getEventQueue();
            ev_queue.insert_event(eventData);
        } else {
            cs.callback.push_event(eventData);
        }
    }

    private static void subscribeIfNotDone(EventCallBackStruct eventCallBackStruct, String callbackKey) throws DevFailed {
        eventCallBackStruct.consumer.subscribe_event(eventCallBackStruct.device, eventCallBackStruct.attr_name, eventCallBackStruct.event_type, eventCallBackStruct.callback, eventCallBackStruct.max_size, eventCallBackStruct.filters, false);
        failed_event_callback_map.remove(callbackKey);
    }

    static EventCallBackStruct getCallBackStruct(Hashtable map, int id) {
        Enumeration keys = map.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            EventCallBackStruct callback_struct = (EventCallBackStruct)map.get(name);
            if (callback_struct.id != id) continue;
            return callback_struct;
        }
        return null;
    }

    private void removeCallBackStruct(Hashtable map, EventCallBackStruct cb_struct) throws DevFailed {
        this.removeFilters(cb_struct);
        String callback_key = cb_struct.device.name().toLowerCase() + "/" + cb_struct.attr_name + "." + cb_struct.event_name;
        map.remove(callback_key);
    }

    @Override
    public void unsubscribe_event(int event_id) throws DevFailed {
        EventCallBackStruct callbackStruct = EventConsumer.getCallBackStruct(event_callback_map, event_id);
        if (callbackStruct != null) {
            this.removeCallBackStruct(event_callback_map, callbackStruct);
            this.unsubscribeTheEvent(callbackStruct);
        } else {
            callbackStruct = EventConsumer.getCallBackStruct(failed_event_callback_map, event_id);
            if (callbackStruct != null) {
                this.removeCallBackStruct(failed_event_callback_map, callbackStruct);
            } else {
                Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, the event id (" + event_id + ") specified does not correspond with any known one", "EventConsumer.unsubscribe_event()");
            }
        }
    }

    void reSubscribeByName(EventChannelStruct event_channel_struct, String name) {
        Enumeration<EventCallBackStruct> callback_structs = event_callback_map.elements();
        while (callback_structs.hasMoreElements()) {
            EventCallBackStruct callback_struct = callback_structs.nextElement();
            if (!callback_struct.channel_name.equals(name)) continue;
            this.reSubscribe(event_channel_struct, callback_struct);
        }
    }

    void pushReceivedException(EventChannelStruct event_channel_struct, EventCallBackStruct callback_struct, DevError error) {
        try {
            if (event_channel_struct != null) {
                if (event_channel_struct.consumer instanceof NotifdEventConsumer && !callback_struct.filter_ok) {
                    callback_struct.filter_id = NotifdEventConsumer.getInstance().add_filter_for_channel(event_channel_struct, callback_struct.filter_constraint);
                    callback_struct.filter_ok = true;
                }
            } else {
                return;
            }
            int eventSource = event_channel_struct.consumer instanceof NotifdEventConsumer ? 1 : 0;
            DevError[] errors = new DevError[]{error};
            String domain_name = callback_struct.device.name();
            if (callback_struct.attr_name != null) {
                domain_name = domain_name + "/" + callback_struct.attr_name.toLowerCase();
            }
            EventData event_data = new EventData(event_channel_struct.adm_device_proxy, domain_name, callback_struct.event_name, callback_struct.event_type, eventSource, null, null, null, null, null, errors);
            CallBack callback = callback_struct.callback;
            event_data.device = callback_struct.device;
            event_data.name = callback_struct.device.name();
            event_data.event = callback_struct.event_name;
            if (callback_struct.use_ev_queue) {
                EventQueue ev_queue = callback_struct.device.getEventQueue();
                ev_queue.insert_event(event_data);
            } else {
                callback.push_event(event_data);
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    void readAttributeAndPush(EventChannelStruct eventChannelStruct, EventCallBackStruct callbackStruct) {
        boolean found = false;
        for (int i = 0; !found && i < eventNames.length; ++i) {
            found = callbackStruct.event_name.equals(eventNames[i]);
        }
        if (!found) {
            return;
        }
        DeviceAttribute deviceAttribute = null;
        DevicePipe devicePipe = null;
        AttributeInfoEx info = null;
        DeviceInterface deviceInterface = null;
        DevError[] err = null;
        String domain_name = callbackStruct.device.name() + "/" + callbackStruct.attr_name;
        boolean old_transp = callbackStruct.device.get_transparency_reconnection();
        callbackStruct.device.set_transparency_reconnection(true);
        try {
            callbackStruct.setSynchronousDone(false);
            if (callbackStruct.event_name.equals(eventNames[5])) {
                info = callbackStruct.device.get_attribute_info_ex(callbackStruct.attr_name);
            } else if (callbackStruct.event_name.equals(eventNames[8])) {
                devicePipe = callbackStruct.device.readPipe(callbackStruct.attr_name);
            } else if (callbackStruct.event_name.equals(eventNames[7])) {
                deviceInterface = new DeviceInterface(callbackStruct.device);
            } else {
                deviceAttribute = callbackStruct.device.read_attribute(callbackStruct.attr_name);
            }
            callbackStruct.setSynchronousDone(true);
            ++eventChannelStruct.has_notifd_closed_the_connection;
        }
        catch (DevFailed e) {
            err = e.errors;
        }
        callbackStruct.device.set_transparency_reconnection(old_transp);
        EventData eventData = new EventData(callbackStruct.device, domain_name, callbackStruct.event_name, callbackStruct.event_type, this.getSource(eventChannelStruct.consumer), deviceAttribute, devicePipe, info, null, deviceInterface, err);
        if (callbackStruct.use_ev_queue) {
            EventQueue ev_queue = callbackStruct.device.getEventQueue();
            ev_queue.insert_event(eventData);
        } else {
            callbackStruct.callback.push_event(eventData);
        }
    }

    private int getSource(EventConsumer consumer) {
        return consumer instanceof NotifdEventConsumer ? 1 : 0;
    }

    protected class ConnectionStructure {
        String tangoHost;
        String channelName;
        String attributeName;
        String deviceName;
        String eventName;
        Database database;
        DeviceData deviceData = null;
        boolean reconnect = false;

        ConnectionStructure(String tangoHost, String channelName, String deviceName, String attributeName, String eventName, Database database, DeviceData deviceData, boolean reconnect) {
            this.tangoHost = tangoHost;
            this.channelName = channelName;
            this.deviceName = deviceName;
            this.attributeName = attributeName;
            this.eventName = eventName;
            this.database = database;
            this.deviceData = deviceData;
            this.reconnect = reconnect;
        }

        ConnectionStructure(String tangoHost, String name, Database dbase, boolean reconnect) {
            this(tangoHost, name, null, null, null, dbase, null, reconnect);
        }

        public String toString() {
            return "channel name: " + this.channelName + "\ndatabase:     " + this.database + "\nreconnect:    " + this.reconnect;
        }
    }

    class PushAttrValueLater
    extends Thread {
        private EventCallBackStruct cb_struct;

        PushAttrValueLater(EventCallBackStruct cb_struct) {
            this.cb_struct = cb_struct;
        }

        @Override
        public void run() {
            DeviceAttribute deviceAttribute = null;
            DevicePipe devicePipe = null;
            AttributeInfoEx attributeInfo = null;
            DeviceInterface deviceInterface = null;
            DevError[] err = null;
            String eventName = this.cb_struct.device.name();
            if (this.cb_struct.event_type != 7) {
                eventName = eventName + "/" + this.cb_struct.attr_name.toLowerCase();
            }
            try {
                if (this.cb_struct.event_type == 7) {
                    deviceInterface = new DeviceInterface(this.cb_struct.device);
                } else if (this.cb_struct.event_type == 8) {
                    devicePipe = this.cb_struct.device.readPipe(this.cb_struct.attr_name);
                } else if (this.cb_struct.event_type == 5) {
                    attributeInfo = this.cb_struct.device.get_attribute_info_ex(this.cb_struct.attr_name);
                } else {
                    deviceAttribute = this.cb_struct.device.read_attribute(this.cb_struct.attr_name);
                }
            }
            catch (DevFailed e) {
                err = e.errors;
            }
            int eventSource = this.cb_struct.consumer instanceof NotifdEventConsumer ? 1 : 0;
            EventData event_data = new EventData(this.cb_struct.device, eventName, this.cb_struct.event_name, this.cb_struct.event_type, eventSource, deviceAttribute, devicePipe, attributeInfo, null, deviceInterface, err);
            if (this.cb_struct.use_ev_queue) {
                EventQueue ev_queue = this.cb_struct.device.getEventQueue();
                ev_queue.insert_event(event_data);
            } else {
                this.cb_struct.callback.push_event(event_data);
            }
            this.cb_struct.setSynchronousDone(true);
        }
    }
}

