/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrValUnion;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevPipeDataElt;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.PipeBlob;
import fr.esrf.TangoApi.PipeBlobBuilder;
import fr.esrf.TangoDs.Except;
import fr.esrf.utils.ArrayUtils;
import java.lang.reflect.Array;
import org.omg.CORBA.BAD_PARAM;

public class PipeDataElement {
    private DevPipeDataElt element;
    private static final String SCALAR = "Scalar";
    private static final String ARRAY = "Array";

    public PipeDataElement(DevPipeDataElt element) {
        this.element = element;
    }

    public PipeDataElement(String name, boolean value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.bool_att_value(new boolean[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, boolean[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.bool_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, short value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.short_att_value(new short[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, short[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.short_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, short[] value, boolean asUChar) {
        AttrValUnion attrValUnion = new AttrValUnion();
        if (asUChar) {
            byte[] unsigned = new byte[value.length];
            for (int i = 0; i < value.length; ++i) {
                unsigned[i] = (byte)(value[i] & 0xFF);
            }
            attrValUnion.uchar_att_value(unsigned);
        } else {
            attrValUnion.short_att_value(value);
        }
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, int value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.long_att_value(new int[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, int[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.long_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, int[] value, boolean asUShort) {
        AttrValUnion attrValUnion = new AttrValUnion();
        if (asUShort) {
            short[] unsigned = new short[value.length];
            for (int i = 0; i < value.length; ++i) {
                unsigned[i] = (short)(value[i] & 0xFFFF);
            }
            attrValUnion.ushort_att_value(unsigned);
        } else {
            attrValUnion.long_att_value(value);
        }
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, long value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.long64_att_value(new long[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, long[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.long64_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, long[] value, boolean asULong) {
        AttrValUnion attrValUnion = new AttrValUnion();
        if (asULong) {
            int[] unsigned = new int[value.length];
            for (int i = 0; i < value.length; ++i) {
                unsigned[i] = (int)value[i];
            }
            attrValUnion.ulong_att_value(unsigned);
        } else {
            attrValUnion.long64_att_value(value);
        }
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, float value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.float_att_value(new float[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, float[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.float_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, double value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.double_att_value(new double[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, double[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.double_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, String value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.string_att_value(new String[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, String[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.string_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, DevState value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.state_att_value(new DevState[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, DevState[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.state_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, DevEncoded value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.encoded_att_value(new DevEncoded[]{value});
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], SCALAR);
    }

    public PipeDataElement(String name, DevEncoded[] value) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.encoded_att_value(value);
        this.element = new DevPipeDataElt(name, attrValUnion, new DevPipeDataElt[0], ARRAY);
    }

    public PipeDataElement(String name, PipeBlob pipeBlob) {
        AttrValUnion attrValUnion = new AttrValUnion();
        attrValUnion.union_no_data(true);
        this.element = new DevPipeDataElt(name, attrValUnion, pipeBlob.getDevPipeBlobObject().blob_data, pipeBlob.getDevPipeBlobObject().name);
    }

    public static PipeDataElement newInstance(String name, Object data) {
        if (!data.getClass().isArray()) {
            throw new IllegalArgumentException("data is expected to be an array!");
        }
        if (Array.getLength(data) == 0) {
            throw new IllegalArgumentException("data can not be empty!");
        }
        Class<?> componentType = data.getClass().getComponentType();
        if (componentType == Object.class) {
            throw new IllegalArgumentException("Can not create PipeBlob from Object[]");
        }
        if (componentType == Boolean.class || componentType == Short.class || componentType == Integer.class || componentType == Long.class || componentType == Float.class || componentType == Double.class) {
            return PipeDataElement.newInstance(name, ArrayUtils.toPrimitiveArray(data, componentType));
        }
        if (componentType.isArray()) {
            PipeBlobBuilder arrayBlob = new PipeBlobBuilder("array");
            int size = Array.getLength(data);
            for (int i = 0; i < size; ++i) {
                arrayBlob.add(Integer.toString(i), Array.get(data, i));
            }
            return new PipeDataElement(name, arrayBlob.build());
        }
        if (componentType == String.class) {
            return new PipeDataElement(name, (String[])data);
        }
        if (componentType == DevState.class) {
            return new PipeDataElement(name, (DevState[])data);
        }
        if (componentType == DevEncoded.class) {
            return new PipeDataElement(name, (DevEncoded[])data);
        }
        if (componentType == Boolean.TYPE) {
            return new PipeDataElement(name, (boolean[])data);
        }
        if (componentType == Short.TYPE) {
            return new PipeDataElement(name, (short[])data);
        }
        if (componentType == Integer.TYPE) {
            return new PipeDataElement(name, (int[])data);
        }
        if (componentType == Long.TYPE) {
            return new PipeDataElement(name, (long[])data);
        }
        if (componentType == Float.TYPE) {
            return new PipeDataElement(name, (float[])data);
        }
        if (componentType == Double.TYPE) {
            return new PipeDataElement(name, (double[])data);
        }
        throw new IllegalArgumentException("An array of ComponentType is not supported: " + componentType.getSimpleName());
    }

    private static int getType(DevPipeDataElt element) throws DevFailed {
        int type = -1;
        try {
            if (element.inner_blob != null && element.inner_blob.length > 0) {
                return 30;
            }
            int unionType = element.value.discriminator().value();
            switch (unionType) {
                case 0: {
                    type = 1;
                    break;
                }
                case 1: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 3;
                    break;
                }
                case 3: {
                    type = 23;
                    break;
                }
                case 4: {
                    type = 4;
                    break;
                }
                case 5: {
                    type = 5;
                    break;
                }
                case 6: {
                    type = 22;
                    break;
                }
                case 7: {
                    type = 6;
                    break;
                }
                case 8: {
                    type = 7;
                    break;
                }
                case 9: {
                    type = 24;
                    break;
                }
                case 10: {
                    type = 8;
                    break;
                }
                case 11: 
                case 12: {
                    type = 19;
                    break;
                }
                case 13: {
                    type = 28;
                    break;
                }
                case 14: {
                    type = 0;
                    break;
                }
                default: {
                    Except.throw_exception("AttributeTypeNotSupported", "Attribute Type (" + unionType + ") Not Supported");
                    break;
                }
            }
        }
        catch (BAD_PARAM e) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ");
        }
        return type;
    }

    public String getName() {
        return this.element.name;
    }

    public int getType() throws DevFailed {
        return PipeDataElement.getType(this.element);
    }

    DevPipeDataElt getDevPipeDataEltObject() {
        return this.element;
    }

    public boolean[] extractBooleanArray() {
        return this.element.value.bool_att_value();
    }

    public short[] extractUCharArray() {
        byte[] argOut = this.element.value.uchar_att_value();
        short[] val = new short[argOut.length];
        int mask = 255;
        for (int i = 0; i < argOut.length; ++i) {
            val[i] = (short)(0xFF & argOut[i]);
        }
        return val;
    }

    public byte[] extractCharArray() {
        return this.element.value.uchar_att_value();
    }

    public short[] extractShortArray() {
        return this.element.value.short_att_value();
    }

    public int[] extractUShortArray() {
        short[] argOut = this.element.value.ushort_att_value();
        int[] val = new int[argOut.length];
        for (int i = 0; i < argOut.length; ++i) {
            val[i] = 0xFFFF & argOut[i];
        }
        return val;
    }

    public int[] extractLongArray() {
        return this.element.value.long_att_value();
    }

    public long[] extractULongArray() {
        int[] array = this.element.value.ulong_att_value();
        long mask = Integer.MAX_VALUE;
        mask += 0x80000000L;
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = mask & (long)array[i];
        }
        return result;
    }

    public long[] extractLong64Array() {
        return this.element.value.long64_att_value();
    }

    public long[] extractULong64Array() {
        return this.element.value.ulong64_att_value();
    }

    public float[] extractFloatArray() {
        return this.element.value.float_att_value();
    }

    public double[] extractDoubleArray() {
        return this.element.value.double_att_value();
    }

    public String[] extractStringArray() {
        return this.element.value.string_att_value();
    }

    public DevState[] extractDevStateArray() throws DevFailed {
        return this.element.value.state_att_value();
    }

    public DevEncoded[] extractDevEncodedArray() {
        return this.element.value.encoded_att_value();
    }

    public PipeBlob extractPipeBlob() {
        return new PipeBlob(this.element.inner_blob_name, this.element.inner_blob);
    }
}

