/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.PipeBlob;
import fr.esrf.TangoApi.PipeDataElement;
import java.util.ArrayList;
import java.util.List;

public class PipeBlobBuilder {
    private String blobName;
    private List<PipeDataElement> elements = new ArrayList<PipeDataElement>();

    public PipeBlobBuilder(String blobName) {
        this.blobName = blobName;
    }

    public PipeBlobBuilder add(String name, boolean value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, boolean[] value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, short value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, short[] value, boolean asUChar) {
        this.elements.add(new PipeDataElement(name, value, asUChar));
        return this;
    }

    public PipeBlobBuilder add(String name, int value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, int[] value, boolean asUShort) {
        this.elements.add(new PipeDataElement(name, value, asUShort));
        return this;
    }

    public PipeBlobBuilder add(String name, long value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, long[] value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, float value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, float[] value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, double value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, double[] value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, String value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, String[] value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, DevState value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, DevState[] value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, DevEncoded value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, DevEncoded[] value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, PipeBlob value) {
        this.elements.add(new PipeDataElement(name, value));
        return this;
    }

    public PipeBlobBuilder add(String name, Object value) {
        this.elements.add(PipeDataElement.newInstance(name, value));
        return this;
    }

    public PipeBlob build() {
        PipeBlob blob = new PipeBlob(this.blobName);
        blob.addAll(this.elements);
        return blob;
    }
}

