/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.LockerLanguage;
import fr.esrf.TangoApi.DevLockManager;
import fr.esrf.TangoDs.Except;
import java.util.UUID;

public class LockerInfo {
    private LockerLanguage language;
    private int cpp_pid = 0;
    private UUID uuid;
    private String hostname;
    private String classname;
    private String status;
    private boolean locked;
    private static final int STATUS_IDX = 0;
    private static final int ADD_IDX = 1;
    private static final int CLASS_IDX = 2;
    private static final int LOCK_IDX = 0;
    private static final int PID_IDX = 1;
    private static final int UUID_IDX = 2;

    LockerInfo(DevVarLongStringArray lsa) {
        this.locked = lsa.lvalue[0] != 0;
        this.cpp_pid = lsa.lvalue[1];
        if (this.cpp_pid == 0) {
            this.language = LockerLanguage.JAVA;
            long msl = this.build64(lsa.lvalue[2], lsa.lvalue[3]);
            long lsl = this.build64(lsa.lvalue[4], lsa.lvalue[5]);
            this.uuid = new UUID(msl, lsl);
        } else {
            this.language = LockerLanguage.CPP;
        }
        this.status = lsa.svalue[0];
        this.hostname = this.parseHostAddress(lsa.svalue[1]);
        if (this.language == LockerLanguage.JAVA) {
            this.classname = lsa.svalue[2];
        }
    }

    private String parseHostAddress(String str) {
        int end;
        String header = "giop:tcp:";
        if (str.startsWith(header)) {
            str = str.substring(header.length());
        }
        if ((end = str.lastIndexOf(58)) > 0) {
            str = str.substring(0, end);
        }
        return str;
    }

    private long build64(int i1, int i2) {
        long msi = i1;
        long lsi = (long)i2 & 0xFFFFFFFFL;
        return (msi << 32) + lsi;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isJavaProcess() {
        return this.language == LockerLanguage.JAVA;
    }

    public boolean isCppProcess() {
        return this.language == LockerLanguage.CPP;
    }

    public UUID getJavaUUID() throws DevFailed {
        if (this.language == LockerLanguage.CPP) {
            Except.throw_exception("API_WrongData", "The locker is not a java process", "LockerInfo.getJavaUUID()");
        }
        return this.uuid;
    }

    public int getCppPID() throws DevFailed {
        if (this.language == LockerLanguage.JAVA) {
            Except.throw_exception("API_WrongData", "The locker is not a Cpp process", "LockerInfo.getCppPID()");
        }
        return this.cpp_pid;
    }

    public String getClassName() {
        return this.classname;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getStatus() {
        return this.status;
    }

    boolean isMe() {
        DevLockManager dlm = DevLockManager.getInstance();
        if (!dlm.getMainClass().equals(this.classname)) {
            System.out.println(dlm.getMainClass() + "!=" + this.classname);
            return false;
        }
        if (this.uuid.compareTo(dlm.getUUID()) != 0) {
            System.out.println("UUID different");
            return false;
        }
        return this.hostname.equals(dlm.getHost());
    }

    public String toString() {
        return this.status;
    }
}

