/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo_3;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.factory.TangoFactory;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AsyncCallObject;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DevicePipe;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoApi.ForwardedAttributeDatum;
import fr.esrf.TangoApi.IDeviceProxyDAO;
import fr.esrf.TangoApi.LockerInfo;
import fr.esrf.TangoApi.PipeBlob;
import fr.esrf.TangoApi.PipeInfo;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.Request;

public class DeviceProxy
extends Connection
implements ApiDefs {
    private IDeviceProxyDAO deviceProxyDAO = TangoFactory.getSingleton().getDeviceProxyDAO();
    private static final boolean check_idl = false;
    private DbDevice db_dev;
    private String full_class_name;
    private DeviceProxy adm_dev = null;
    private String[] attnames_array = null;
    protected int proxy_lock_cnt = 0;
    protected EventQueue event_queue;
    private DbEventImportInfo evt_import_info = null;
    private static boolean useEvents = true;
    private static boolean useEventsChecked = false;

    public DeviceProxy() throws DevFailed {
        this.deviceProxyDAO.init(this);
        DeviceProxyFactory.add(this);
    }

    public DeviceProxy(DbDevImportInfo info) throws DevFailed {
        super(info);
        this.deviceProxyDAO.init(this, info.name);
        DeviceProxyFactory.add(this);
    }

    public DeviceProxy(String devname) throws DevFailed {
        super(devname);
        this.deviceProxyDAO.init(this, devname);
        DeviceProxyFactory.add(this);
    }

    DeviceProxy(String devname, boolean check_access) throws DevFailed {
        super(devname, check_access);
        this.deviceProxyDAO.init(this, devname, check_access);
        DeviceProxyFactory.add(this);
    }

    public DeviceProxy(String devname, String ior) throws DevFailed {
        super(devname, ior);
        this.deviceProxyDAO.init(this, devname, ior);
        DeviceProxyFactory.add(this);
    }

    public DeviceProxy(String devname, String host, String port) throws DevFailed {
        super(devname, host, port);
        this.deviceProxyDAO.init(this, devname, host, host);
        DeviceProxyFactory.add(this);
    }

    public boolean use_db() {
        return this.deviceProxyDAO.use_db(this);
    }

    public Database get_db_obj() throws DevFailed {
        return this.deviceProxyDAO.get_db_obj(this);
    }

    protected void import_admin_device(DbDevImportInfo info) throws DevFailed {
        this.deviceProxyDAO.import_admin_device(this, info);
    }

    protected void import_admin_device(String origin) throws DevFailed {
        this.deviceProxyDAO.import_admin_device(this, origin);
    }

    public String name() {
        return this.deviceProxyDAO.name(this);
    }

    public String fullName() {
        return this.getUrl().toString();
    }

    public String status() throws DevFailed {
        return this.deviceProxyDAO.status(this);
    }

    public String status(boolean src) throws DevFailed {
        return this.deviceProxyDAO.status(this, src);
    }

    public DevState state() throws DevFailed {
        return this.deviceProxyDAO.state(this);
    }

    public DevState state(boolean src) throws DevFailed {
        return this.deviceProxyDAO.state(this, src);
    }

    public CommandInfo command_query(String cmdname) throws DevFailed {
        return this.deviceProxyDAO.command_query(this, cmdname);
    }

    public String get_class() throws DevFailed {
        return this.deviceProxyDAO.get_class(this);
    }

    public String[] get_class_inheritance() throws DevFailed {
        return this.deviceProxyDAO.get_class_inheritance(this);
    }

    public void put_alias(String aliasname) throws DevFailed {
        this.deviceProxyDAO.put_alias(this, aliasname);
    }

    public String get_alias() throws DevFailed {
        return this.deviceProxyDAO.get_alias(this);
    }

    public DeviceInfo get_info() throws DevFailed {
        return this.deviceProxyDAO.get_info(this);
    }

    public DbDevImportInfo import_device() throws DevFailed {
        return this.deviceProxyDAO.import_device(this);
    }

    public void export_device(DbDevExportInfo devinfo) throws DevFailed {
        this.deviceProxyDAO.export_device(this, devinfo);
    }

    public void unexport_device() throws DevFailed {
        this.deviceProxyDAO.unexport_device(this);
    }

    public void add_device(DbDevInfo devinfo) throws DevFailed {
        this.deviceProxyDAO.add_device(this, devinfo);
    }

    public void delete_device() throws DevFailed {
        this.deviceProxyDAO.delete_device(this);
    }

    public String[] get_property_list(String wildcard) throws DevFailed {
        return this.deviceProxyDAO.get_property_list(this, wildcard);
    }

    public DbDatum[] get_property(String[] propnames) throws DevFailed {
        return this.deviceProxyDAO.get_property(this, propnames);
    }

    public DbDatum get_property(String propname) throws DevFailed {
        return this.deviceProxyDAO.get_property(this, propname);
    }

    public DbDatum[] get_property(DbDatum[] properties) throws DevFailed {
        return this.deviceProxyDAO.get_property(this, properties);
    }

    public void put_property(DbDatum prop) throws DevFailed {
        this.deviceProxyDAO.put_property(this, prop);
    }

    public void put_property(DbDatum[] properties) throws DevFailed {
        this.deviceProxyDAO.put_property(this, properties);
    }

    public void delete_property(String[] propnames) throws DevFailed {
        this.deviceProxyDAO.delete_property(this, propnames);
    }

    public void delete_property(String propname) throws DevFailed {
        this.deviceProxyDAO.delete_property(this, propname);
    }

    public void delete_property(DbDatum[] properties) throws DevFailed {
        this.deviceProxyDAO.delete_property(this, properties);
    }

    public String[] get_attribute_list() throws DevFailed {
        return this.deviceProxyDAO.get_attribute_list(this);
    }

    public void put_attribute_property(DbAttribute[] attr) throws DevFailed {
        this.deviceProxyDAO.put_attribute_property(this, attr);
    }

    public void put_attribute_property(DbAttribute attr) throws DevFailed {
        this.deviceProxyDAO.put_attribute_property(this, attr);
    }

    public void delete_attribute_property(String attname, String[] propnames) throws DevFailed {
        this.deviceProxyDAO.delete_attribute_property(this, attname, propnames);
    }

    public void delete_attribute_property(String attname, String propname) throws DevFailed {
        this.deviceProxyDAO.delete_attribute_property(this, attname, propname);
    }

    public void delete_attribute_property(DbAttribute attr) throws DevFailed {
        this.deviceProxyDAO.delete_attribute_property(this, attr);
    }

    public void delete_attribute_property(DbAttribute[] attr) throws DevFailed {
        this.deviceProxyDAO.delete_attribute_property(this, attr);
    }

    public DbAttribute[] get_attribute_property(String[] attnames) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_property(this, attnames);
    }

    public DbAttribute get_attribute_property(String attname) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_property(this, attname);
    }

    public void delete_attribute(String attname) throws DevFailed {
        this.deviceProxyDAO.delete_attribute(this, attname);
    }

    public AttributeInfo[] get_attribute_info(String[] attnames) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info(this, attnames);
    }

    public AttributeInfoEx[] get_attribute_info_ex(String[] attnames) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info_ex(this, attnames);
    }

    public AttributeInfo[] get_attribute_config(String[] attnames) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info(this, attnames);
    }

    public AttributeInfo get_attribute_info(String attname) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info(this, attname);
    }

    public AttributeInfoEx get_attribute_info_ex(String attname) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info_ex(this, attname);
    }

    public AttributeInfo get_attribute_config(String attname) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info(this, attname);
    }

    public AttributeInfo[] get_attribute_info() throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info(this);
    }

    public AttributeInfoEx[] get_attribute_info_ex() throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info_ex(this);
    }

    public AttributeInfo[] get_attribute_config() throws DevFailed {
        return this.deviceProxyDAO.get_attribute_info(this);
    }

    public void set_attribute_info(AttributeInfo[] attr) throws DevFailed {
        this.deviceProxyDAO.set_attribute_info(this, attr);
    }

    public void set_attribute_info(AttributeInfoEx[] attr) throws DevFailed {
        this.deviceProxyDAO.set_attribute_info(this, attr);
    }

    public void set_attribute_config(AttributeInfo[] attr) throws DevFailed {
        this.deviceProxyDAO.set_attribute_info(this, attr);
    }

    public DeviceAttribute read_attribute(String attname) throws DevFailed {
        return this.deviceProxyDAO.read_attribute(this, attname);
    }

    public AttributeValue read_attribute_value(String attname) throws DevFailed {
        return this.deviceProxyDAO.read_attribute_value(this, attname);
    }

    public DeviceAttribute[] read_attribute(String[] attnames) throws DevFailed {
        DeviceProxy.checkDuplication(attnames, "DeviceProxy.read_attribute()");
        return this.deviceProxyDAO.read_attribute(this, attnames);
    }

    public void write_attribute(DeviceAttribute deviceAttribute) throws DevFailed {
        this.deviceProxyDAO.write_attribute(this, deviceAttribute);
    }

    public void write_attribute(DeviceAttribute[] deviceAttributes) throws DevFailed {
        this.deviceProxyDAO.write_attribute(this, deviceAttributes);
    }

    public DeviceAttribute write_read_attribute(DeviceAttribute deviceAttribute) throws DevFailed {
        return this.deviceProxyDAO.write_read_attribute(this, new DeviceAttribute[]{deviceAttribute})[0];
    }

    public DeviceAttribute[] write_read_attribute(DeviceAttribute[] deviceAttributes, String[] readNames) throws DevFailed {
        return this.deviceProxyDAO.write_read_attribute(this, deviceAttributes, readNames);
    }

    public DeviceAttribute[] write_read_attribute(DeviceAttribute[] deviceAttributes) throws DevFailed {
        return this.deviceProxyDAO.write_read_attribute(this, deviceAttributes);
    }

    public DeviceProxy get_adm_dev() throws DevFailed {
        return this.deviceProxyDAO.get_adm_dev(this);
    }

    public void poll_command(String cmdname, int period) throws DevFailed {
        this.deviceProxyDAO.poll_command(this, cmdname, period);
    }

    public void poll_attribute(String attname, int period) throws DevFailed {
        this.deviceProxyDAO.poll_attribute(this, attname, period);
    }

    public void stop_poll_command(String cmdname) throws DevFailed {
        this.deviceProxyDAO.stop_poll_command(this, cmdname);
    }

    public void stop_poll_attribute(String attname) throws DevFailed {
        this.deviceProxyDAO.stop_poll_attribute(this, attname);
    }

    public String[] polling_status() throws DevFailed {
        return this.deviceProxyDAO.polling_status(this);
    }

    public DeviceDataHistory[] command_history(String cmdname, int nb) throws DevFailed {
        return this.deviceProxyDAO.command_history(this, cmdname, nb);
    }

    public DeviceDataHistory[] attribute_history(String attname, int nb) throws DevFailed {
        return this.deviceProxyDAO.attribute_history(this, attname, nb);
    }

    public DeviceDataHistory[] command_history(String cmdname) throws DevFailed {
        return this.deviceProxyDAO.command_history(this, cmdname);
    }

    public DeviceDataHistory[] attribute_history(String attname) throws DevFailed {
        return this.deviceProxyDAO.attribute_history(this, attname);
    }

    public int get_attribute_polling_period(String attname) throws DevFailed {
        return this.deviceProxyDAO.get_attribute_polling_period(this, attname);
    }

    public int get_command_polling_period(DeviceProxy deviceProxy, String cmdname) throws DevFailed {
        return deviceProxy.get_command_polling_period(this, cmdname);
    }

    public int command_inout_asynch(String cmdname, DeviceData data_in) throws DevFailed {
        return this.deviceProxyDAO.command_inout_asynch(this, cmdname, data_in);
    }

    public int command_inout_asynch(String cmdname) throws DevFailed {
        return this.deviceProxyDAO.command_inout_asynch(this, cmdname);
    }

    public int command_inout_asynch(String cmdname, boolean forget) throws DevFailed {
        return this.deviceProxyDAO.command_inout_asynch(this, cmdname, forget);
    }

    public int command_inout_asynch(String cmdname, DeviceData data_in, boolean forget) throws DevFailed {
        return this.deviceProxyDAO.command_inout_asynch(this, cmdname, data_in, forget);
    }

    public void command_inout_asynch(String cmdname, DeviceData argin, CallBack cb) throws DevFailed {
        this.deviceProxyDAO.command_inout_asynch(this, cmdname, argin, cb);
    }

    public void command_inout_asynch(String cmdname, CallBack cb) throws DevFailed {
        this.deviceProxyDAO.command_inout_asynch(this, cmdname, cb);
    }

    public DeviceData command_inout_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        return this.deviceProxyDAO.command_inout_reply(this, id, timeout);
    }

    DeviceData command_inout_reply(AsyncCallObject aco, int timeout) throws DevFailed, AsynReplyNotArrived {
        return this.deviceProxyDAO.command_inout_reply(this, aco, timeout);
    }

    public DeviceData command_inout_reply(int id) throws DevFailed, AsynReplyNotArrived {
        return this.deviceProxyDAO.command_inout_reply(this, id);
    }

    DeviceData command_inout_reply(AsyncCallObject aco) throws DevFailed, AsynReplyNotArrived {
        return this.deviceProxyDAO.command_inout_reply(this, aco);
    }

    public int read_attribute_asynch(String attname) throws DevFailed {
        return this.deviceProxyDAO.read_attribute_asynch(this, attname);
    }

    public int read_attribute_asynch(String[] attnames) throws DevFailed {
        DeviceProxy.checkDuplication(attnames, "DeviceProxy.read_attribute_asynch()");
        return this.deviceProxyDAO.read_attribute_asynch(this, attnames);
    }

    protected String get_asynch_idl_cmd(Request request, String idl_cmd) {
        return this.deviceProxyDAO.get_asynch_idl_cmd(this, request, idl_cmd);
    }

    protected void check_asynch_reply(Request request, int id, String idl_cmd) throws DevFailed, AsynReplyNotArrived {
        this.deviceProxyDAO.check_asynch_reply(this, request, id, idl_cmd);
    }

    public DeviceAttribute[] read_attribute_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        return this.deviceProxyDAO.read_attribute_reply(this, id, timeout);
    }

    public DeviceAttribute[] read_attribute_reply(int id) throws DevFailed, AsynReplyNotArrived {
        return this.deviceProxyDAO.read_attribute_reply(this, id);
    }

    public void read_attribute_asynch(String attname, CallBack cb) throws DevFailed {
        this.deviceProxyDAO.read_attribute_asynch(this, attname, cb);
    }

    public void read_attribute_asynch(String[] attnames, CallBack cb) throws DevFailed {
        this.deviceProxyDAO.read_attribute_asynch(this, attnames, cb);
    }

    public int write_attribute_asynch(DeviceAttribute attr) throws DevFailed {
        return this.deviceProxyDAO.write_attribute_asynch(this, attr);
    }

    public int write_attribute_asynch(DeviceAttribute attr, boolean forget) throws DevFailed {
        return this.deviceProxyDAO.write_attribute_asynch(this, attr, forget);
    }

    public int write_attribute_asynch(DeviceAttribute[] attribs) throws DevFailed {
        return this.deviceProxyDAO.write_attribute_asynch(this, attribs);
    }

    public int write_attribute_asynch(DeviceAttribute[] attribs, boolean forget) throws DevFailed {
        return this.deviceProxyDAO.write_attribute_asynch(this, attribs, forget);
    }

    public void write_attribute_reply(int id) throws DevFailed, AsynReplyNotArrived {
        this.deviceProxyDAO.write_attribute_reply(this, id);
    }

    public void write_attribute_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        this.deviceProxyDAO.write_attribute_reply(this, id, timeout);
    }

    public void write_attribute_asynch(DeviceAttribute attr, CallBack cb) throws DevFailed {
        this.deviceProxyDAO.write_attribute_asynch(this, attr, cb);
    }

    public void write_attribute_asynch(DeviceAttribute[] attribs, CallBack cb) throws DevFailed {
        this.deviceProxyDAO.write_attribute_asynch(this, attribs, cb);
    }

    public int pending_asynch_call(int reply_model) {
        return this.deviceProxyDAO.pending_asynch_call(this, reply_model);
    }

    public void get_asynch_replies() {
        this.deviceProxyDAO.get_asynch_replies(this);
    }

    public void get_asynch_replies(int timeout) {
        this.deviceProxyDAO.get_asynch_replies(this, timeout);
    }

    public void add_logging_target(String target_type, String target_name) throws DevFailed {
        this.deviceProxyDAO.add_logging_target(this, target_type + "::" + target_name);
    }

    public void add_logging_target(String target) throws DevFailed {
        this.deviceProxyDAO.add_logging_target(this, target);
    }

    public void remove_logging_target(String target_type, String target_name) throws DevFailed {
        this.deviceProxyDAO.remove_logging_target(this, target_type, target_name);
    }

    public String[] get_logging_target() throws DevFailed {
        return this.deviceProxyDAO.get_logging_target(this);
    }

    public int get_logging_level() throws DevFailed {
        return this.deviceProxyDAO.get_logging_level(this);
    }

    public void set_logging_level(int level) throws DevFailed {
        this.deviceProxyDAO.set_logging_level(this, level);
    }

    public void lock() throws DevFailed {
        this.lock(10);
    }

    public void lock(int validity) throws DevFailed {
        this.deviceProxyDAO.lock(this, validity);
        ++this.proxy_lock_cnt;
    }

    public int unlock() throws DevFailed {
        int n = this.deviceProxyDAO.unlock(this);
        --this.proxy_lock_cnt;
        return n;
    }

    public boolean isLocked() throws DevFailed {
        return this.deviceProxyDAO.isLocked(this);
    }

    public boolean isLockedByMe() throws DevFailed {
        return this.deviceProxyDAO.isLockedByMe(this);
    }

    public String getLockerStatus() throws DevFailed {
        return this.deviceProxyDAO.getLockerStatus(this);
    }

    public LockerInfo getLockerInfo() throws DevFailed {
        return this.deviceProxyDAO.getLockerInfo(this);
    }

    public String[] dev_inform() throws DevFailed {
        return this.deviceProxyDAO.dev_inform(this);
    }

    public void set_rpc_protocol(int mode) throws DevFailed {
        this.deviceProxyDAO.set_rpc_protocol(this, mode);
    }

    public int get_rpc_protocol() throws DevFailed {
        return this.deviceProxyDAO.get_rpc_protocol(this);
    }

    public List<ForwardedAttributeDatum> getForwardedAttributeInfoForDevice() throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.name());
        }
        return this.db_dev.getForwardedAttributeInfoForDevice();
    }

    public List<String> getPipeNames() throws DevFailed {
        List<PipeInfo> infoList = this.deviceProxyDAO.getPipeConfig(this);
        ArrayList<String> pipeNames = new ArrayList<String>();
        for (PipeInfo info : infoList) {
            pipeNames.add(info.getName());
        }
        return pipeNames;
    }

    public List<PipeInfo> getPipeConfig() throws DevFailed {
        return this.deviceProxyDAO.getPipeConfig(this);
    }

    public PipeInfo getPipeConfig(String pipeName) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(pipeName);
        List<PipeInfo> infoList = this.getPipeConfig(list);
        if (infoList.isEmpty()) {
            return null;
        }
        return infoList.get(0);
    }

    public List<PipeInfo> getPipeConfig(String[] pipeNames) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(pipeNames.length);
        Collections.addAll(list, pipeNames);
        return this.getPipeConfig(list);
    }

    public List<PipeInfo> getPipeConfig(List<String> pipeNames) throws DevFailed {
        return this.deviceProxyDAO.getPipeConfig(this, pipeNames);
    }

    public void setPipeConfig(PipeInfo pipeInfo) throws DevFailed {
        ArrayList<PipeInfo> infoList = new ArrayList<PipeInfo>(1);
        infoList.add(pipeInfo);
        this.setPipeConfig(infoList);
    }

    public void setPipeConfig(PipeInfo[] pipeInfoList) throws DevFailed {
        ArrayList<PipeInfo> infoList = new ArrayList<PipeInfo>(pipeInfoList.length);
        Collections.addAll(infoList, pipeInfoList);
        this.setPipeConfig(infoList);
    }

    public void setPipeConfig(List<PipeInfo> pipeInfoList) throws DevFailed {
        this.deviceProxyDAO.setPipeConfig(this, pipeInfoList);
    }

    public DevicePipe readPipe(String pipeName) throws DevFailed {
        return this.deviceProxyDAO.readPipe(this, pipeName);
    }

    public void writePipe(String pipeName, PipeBlob pipeBlob) throws DevFailed {
        this.deviceProxyDAO.writePipe(this, new DevicePipe(pipeName, pipeBlob));
    }

    public void writePipe(DevicePipe devicePipe) throws DevFailed {
        this.deviceProxyDAO.writePipe(this, devicePipe);
    }

    public DevicePipe writeReadPipe(String pipeName, PipeBlob pipeBlob) throws DevFailed {
        return this.writeReadPipe(new DevicePipe(pipeName, pipeBlob));
    }

    public DevicePipe writeReadPipe(DevicePipe devicePipe) throws DevFailed {
        return this.deviceProxyDAO.writeReadPipe(this, devicePipe);
    }

    private boolean useEvents() {
        if (!useEventsChecked) {
            String s = System.getenv("UseEvents");
            if (s != null && s.equals("false")) {
                useEvents = false;
            }
            useEventsChecked = true;
        }
        return useEvents;
    }

    public int subscribe_event(String attr_name, int event, CallBack callback, String[] filters) throws DevFailed {
        if (!this.useEvents()) {
            Except.throw_exception("NO_EVENT", "Event system not available", "DeviceProxy.subscribe_event()");
        }
        if (event == 7) {
            Except.throw_exception("BAD_EVENT", TangoConst.eventNames[event] + " cannot be applied to an attribute");
        }
        return this.deviceProxyDAO.subscribe_event(this, attr_name, event, callback, filters, false);
    }

    public int subscribe_event(String attr_name, int event, CallBack callback, String[] filters, boolean stateless) throws DevFailed {
        if (!this.useEvents()) {
            Except.throw_exception("NO_EVENT", "Event system not available");
        }
        if (event == 7) {
            Except.throw_exception("BAD_EVENT", TangoConst.eventNames[event] + " cannot be applied to an attribute");
        }
        return this.deviceProxyDAO.subscribe_event(this, attr_name, event, callback, filters, stateless);
    }

    public int subscribe_event(String attr_name, int event, int max_size, String[] filters, boolean stateless) throws DevFailed {
        if (!this.useEvents()) {
            Except.throw_exception("NO_EVENT", "Event system not available");
        }
        if (event == 7) {
            Except.throw_exception("BAD_EVENT", TangoConst.eventNames[event] + " cannot be applied to a device");
        }
        return this.deviceProxyDAO.subscribe_event(this, attr_name, event, max_size, filters, stateless);
    }

    public int subscribe_event(int event, CallBack callback, boolean stateless) throws DevFailed {
        if (!this.useEvents()) {
            Except.throw_exception("NO_EVENT", "Event system not available");
        }
        if (event != 7) {
            Except.throw_exception("BAD_EVENT", TangoConst.eventNames[event] + " cannot be applied to a device");
        }
        return this.deviceProxyDAO.subscribe_event(this, event, callback, stateless);
    }

    public int subscribe_event(int event, int max_size, boolean stateless) throws DevFailed {
        if (!this.useEvents()) {
            Except.throw_exception("NO_EVENT", "Event system not available");
        }
        return this.deviceProxyDAO.subscribe_event(this, event, max_size, stateless);
    }

    public void setEventQueue(EventQueue eq) {
        this.event_queue = eq;
    }

    public EventQueue getEventQueue() {
        return this.event_queue;
    }

    public int get_event_queue_size() {
        return this.event_queue.size();
    }

    public int get_event_queue_size(int event_type) {
        return this.event_queue.size(event_type);
    }

    public EventData get_next_event() throws DevFailed {
        return this.event_queue.getNextEvent();
    }

    public EventData get_next_event(int event_type) throws DevFailed {
        return this.event_queue.getNextEvent(event_type);
    }

    public synchronized long get_last_event_date() throws DevFailed {
        return this.event_queue.getLastEventDate();
    }

    public EventData[] get_events() {
        return this.event_queue.getEvents();
    }

    public EventData[] get_events(int event_type) {
        return this.event_queue.getEvents(event_type);
    }

    public void unsubscribe_event(int event_id) throws DevFailed {
        this.deviceProxyDAO.unsubscribe_event(this, event_id);
    }

    public IDeviceProxyDAO getDeviceProxy() {
        return this.deviceProxyDAO;
    }

    public void setDeviceProxy(IDeviceProxyDAO deviceProxy) {
        this.deviceProxyDAO = deviceProxy;
    }

    public DeviceProxy getAdm_dev() {
        return this.adm_dev;
    }

    public void setAdm_dev(DeviceProxy adm_dev) {
        this.adm_dev = adm_dev;
    }

    public String[] getAttnames_array() {
        return this.attnames_array;
    }

    public void setAttnames_array(String[] attnames_array) {
        this.attnames_array = attnames_array;
    }

    public DbDevice getDb_dev() {
        return this.db_dev;
    }

    public void setDb_dev(DbDevice db_dev) {
        this.db_dev = db_dev;
    }

    public String getFull_class_name() {
        return this.full_class_name;
    }

    public void setFull_class_name(String full_class_name) {
        this.full_class_name = full_class_name;
    }

    public static boolean isCheck_idl() {
        return false;
    }

    public DbEventImportInfo get_evt_import_info() {
        return this.evt_import_info;
    }

    public void set_evt_import_info(DbEventImportInfo info) {
        this.evt_import_info = info;
    }

    private static void checkDuplication(String[] list, String orig) throws DevFailed {
        Vector<String> dupli = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            String str = list[i];
            for (int j = i + 1; j < list.length; ++j) {
                if (!list[j].equalsIgnoreCase(str) || dupli.indexOf(str) >= 0) continue;
                dupli.add(str);
            }
        }
        if (dupli.size() > 0) {
            String message = "Several times the same attribute in required attribute list: ";
            for (int i = 0; i < dupli.size(); ++i) {
                message = message + (String)dupli.get(i);
                if (i >= dupli.size() - 1) continue;
                message = message + ", ";
            }
            Except.throw_exception("", message, orig);
        }
    }

    protected void finalize() {
        if (this.proxy_lock_cnt > 0) {
            try {
                this.unlock();
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int getTangoVersionFromZmqEventSubscriptionChange() throws DevFailed {
        try {
            DeviceData argIn = new DeviceData();
            argIn.insert(new String[]{"info"});
            DeviceData argOut = this.get_adm_dev().command_inout("ZmqEventSubscriptionChange", argIn);
            DevVarLongStringArray lsa = argOut.extractLongStringArray();
            if (lsa.lvalue.length == 0) {
                return -1;
            }
            return lsa.lvalue[0];
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                return -1;
            }
            throw e;
        }
    }

    public int getTangoVersion() throws DevFailed {
        int adminIdl = this.get_adm_dev().get_idl_version();
        int version2 = this.getTangoVersionFromZmqEventSubscriptionChange();
        if (version2 > 900) {
            return version2;
        }
        CommandInfo[] commandInfoList = this.get_adm_dev().command_list_query();
        switch (adminIdl) {
            case 1: {
                return 100;
            }
            case 2: {
                return 200;
            }
            case 3: {
                for (CommandInfo commandInfo : commandInfoList) {
                    if (!commandInfo.cmd_name.equals("QueryWizardClassProperty")) continue;
                    return 520;
                }
                return 500;
            }
            case 4: {
                for (CommandInfo commandInfo : commandInfoList) {
                    if (!commandInfo.cmd_name.equals("EventConfirmSubscription")) continue;
                    return 810;
                }
                for (CommandInfo commandInfo : commandInfoList) {
                    if (!commandInfo.cmd_name.equals("ZmqEventSubscriptionChange")) continue;
                    return 800;
                }
                return 700;
            }
            case 5: {
                return 900;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            DeviceInfo deviceInfo = this.get_info();
            sb.append(deviceInfo).append('\n');
            DevInfo_3 devInfo3 = this.info_3();
            sb.append("Class:       ").append(devInfo3.dev_class).append('\n');
            sb.append("Server:      ").append(devInfo3.server_id).append('\n');
            sb.append("Host:        ").append(devInfo3.server_host).append('\n');
            sb.append(devInfo3.doc_url).append('\n');
            sb.append('\n');
            sb.append("IDL:   ").append(this.get_idl_version()).append('\n');
            int release = this.getTangoVersion();
            sb.append("Tango: ").append(String.format("%1.1f", 0.01 * (double)release));
        }
        catch (DevFailed e) {
            sb.append("\n").append(e.errors[0].desc);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String deviceName = null;
        String commandName = null;
        try {
            commandName = args[0];
            deviceName = args[1];
        }
        catch (Exception e) {
            if (commandName == null) {
                System.out.println("Usage :");
                System.out.println("fr.esrf.TangoApi.DeviceProxy  commandName deviceName");
                System.out.println("\t- info : Display device info.");
                System.out.println("\t- commandName : command name (ping, state, status, unexport...)");
                System.out.println("\t- deviceName : device name to send command.");
            } else {
                System.out.println("Device name ?");
            }
            System.exit(0);
        }
        try {
            int i;
            String[] devnames = !deviceName.contains("*") ? new String[]{deviceName} : ApiUtil.get_db_obj().getDevices(deviceName);
            DeviceProxy[] deviceProxies = new DeviceProxy[devnames.length];
            for (i = 0; i < devnames.length; ++i) {
                deviceProxies[i] = new DeviceProxy(devnames[i]);
            }
            if (commandName.equals("info")) {
                for (DeviceProxy deviceProxy : deviceProxies) {
                    System.out.println(deviceProxy + "\n");
                }
            } else {
                if (commandName.equals("ping")) {
                    while (true) {
                        for (i = 0; i < deviceProxies.length; ++i) {
                            try {
                                long t = deviceProxies[i].ping();
                                System.out.println(devnames[i] + " is alive  (" + t / 1000L + " ms)");
                                continue;
                            }
                            catch (DevFailed e) {
                                System.out.println(devnames[i] + "  " + e.errors[0].desc);
                            }
                        }
                        if (deviceProxies.length > 1) {
                            System.out.println();
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException i2) {}
                    }
                }
                if (commandName.equals("status")) {
                    for (i = 0; i < deviceProxies.length; ++i) {
                        try {
                            System.out.println(devnames[i] + " - " + deviceProxies[i].status());
                            continue;
                        }
                        catch (DevFailed e) {
                            System.out.println(devnames[i] + "  " + e.errors[0].desc);
                        }
                    }
                } else if (commandName.equals("state")) {
                    for (i = 0; i < deviceProxies.length; ++i) {
                        try {
                            System.out.println(devnames[i] + " is " + ApiUtil.stateName(deviceProxies[i].state()));
                            continue;
                        }
                        catch (DevFailed e) {
                            System.out.println(devnames[i] + "  " + e.errors[0].desc);
                        }
                    }
                } else if (commandName.equals("unexport")) {
                    for (i = 0; i < deviceProxies.length; ++i) {
                        try {
                            deviceProxies[i].unexport_device();
                            System.out.println(devnames[i] + " unexported !");
                            continue;
                        }
                        catch (DevFailed e) {
                            System.out.println(devnames[i] + "  " + e.errors[0].desc);
                        }
                    }
                } else {
                    System.out.println(commandName + " ?   Unknow command !");
                }
            }
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
    }
}

