/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.JavaClntIdent;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoApi.LockerInfo;
import fr.esrf.TangoDs.Except;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.UUID;
import java.util.Vector;

class DevLockManager {
    private static DevLockManager instance = null;
    private static UUID uuid;
    private static long[] l_uuid;
    private static String mainClass;
    private static String host_add;
    private static JavaClntIdent j_ident;
    private static ClntIdent ident;
    private static String strPID;
    private static boolean hasManagementClasses;
    private static Hashtable<String, LockedDeviceAmin> relockMap;
    private static final long VALIDITY_DELAY = 500L;

    static DevLockManager getInstance() {
        if (instance == null) {
            instance = new DevLockManager();
        }
        return instance;
    }

    private DevLockManager() {
        RuntimeMXBean mx;
        String str;
        int pos;
        uuid = UUID.randomUUID();
        l_uuid = new long[2];
        DevLockManager.l_uuid[0] = uuid.getMostSignificantBits();
        DevLockManager.l_uuid[1] = uuid.getLeastSignificantBits();
        if (hasManagementClasses && (pos = (str = (mx = ManagementFactory.getRuntimeMXBean()).getName()).indexOf(64)) > 0) {
            strPID = str.substring(0, pos);
        }
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String tag = ".main";
        String s = trace[trace.length - 1].toString();
        int idx = s.indexOf(".main");
        if (idx > 0) {
            mainClass = s.substring(0, idx);
            if (strPID != null) {
                mainClass = mainClass + " - PID=" + strPID;
            }
        } else {
            mainClass = strPID != null ? "PID=" + strPID : s.substring(s.lastIndexOf(40));
        }
        j_ident = new JavaClntIdent(mainClass, l_uuid);
        ident = new ClntIdent();
        ident.java_clnt(j_ident);
        try {
            host_add = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public int getJvmPid() {
        int pid = -1;
        if (strPID != null) {
            try {
                pid = Integer.parseInt(strPID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pid;
    }

    JavaClntIdent getJavaClntIdent() {
        return j_ident;
    }

    ClntIdent getClntIdent() {
        return ident;
    }

    String getMainClass() {
        return mainClass;
    }

    String getHost() {
        return host_add;
    }

    UUID getUUID() {
        return uuid;
    }

    public String toString() {
        String str = mainClass + ":\n";
        for (long an_uuid : l_uuid) {
            str = str + an_uuid + "\n";
        }
        return str.trim();
    }

    void lock(DeviceProxy deviceProxy, int validity) throws DevFailed {
        deviceProxy.import_admin_device("lock");
        DevVarLongStringArray lsa = new DevVarLongStringArray();
        lsa.svalue = new String[1];
        lsa.lvalue = new int[1];
        lsa.svalue[0] = deviceProxy.get_name();
        lsa.lvalue[0] = validity;
        DeviceData argin = new DeviceData();
        argin.insert(lsa);
        deviceProxy.getAdm_dev().command_inout("LockDevice", argin);
        this.addToRelockList(deviceProxy, validity);
    }

    int unlock(DeviceProxy deviceProxy) throws DevFailed {
        deviceProxy.import_admin_device("unlock");
        DevVarLongStringArray lsa = new DevVarLongStringArray();
        lsa.svalue = new String[1];
        lsa.lvalue = new int[1];
        lsa.svalue[0] = deviceProxy.get_name();
        lsa.lvalue[0] = 0;
        DeviceData argin = new DeviceData();
        argin.insert(lsa);
        DeviceData argout = deviceProxy.getAdm_dev().command_inout("UnlockDevice", argin);
        int nb = argout.extractLong();
        if (nb == 0) {
            this.removeToRelockList(deviceProxy);
        }
        return nb;
    }

    boolean isLocked(DeviceProxy deviceProxy) throws DevFailed {
        LockerInfo info = this.getLockerInfo(deviceProxy);
        return info.isLocked();
    }

    boolean isLockedByMe(DeviceProxy deviceProxy) throws DevFailed {
        LockerInfo info = this.getLockerInfo(deviceProxy);
        return info.isMe();
    }

    String getLockerStatus(DeviceProxy deviceProxy) throws DevFailed {
        LockerInfo info = this.getLockerInfo(deviceProxy);
        return info.getStatus();
    }

    LockerInfo getLockerInfo(DeviceProxy deviceProxy) throws DevFailed {
        deviceProxy.import_admin_device("getLockerInfo");
        DeviceData argin = new DeviceData();
        argin.insert(deviceProxy.get_name());
        DeviceData argout = deviceProxy.getAdm_dev().command_inout("DevLockStatus", argin);
        return new LockerInfo(argout.extractLongStringArray());
    }

    void addToRelockList(DeviceProxy dev, int validity) throws DevFailed {
        String adm;
        if (relockMap == null) {
            relockMap = new Hashtable();
            Runtime.getRuntime().addShutdownHook(new ShutdownThread());
            new GarbageThread().start();
        }
        try {
            adm = dev.adm_name();
        }
        catch (DevFailed e) {
            return;
        }
        LockedDevice ld = new LockedDevice(dev.get_name(), validity);
        if (!relockMap.containsKey(adm)) {
            LockedDeviceAmin lda = new LockedDeviceAmin(adm, ld);
            lda.start();
            relockMap.put(adm, lda);
        } else {
            LockedDeviceAmin lda = relockMap.get(adm);
            lda.add(ld);
        }
    }

    void removeToRelockList(DeviceProxy dev) {
        String adm;
        try {
            adm = dev.adm_name();
        }
        catch (DevFailed e) {
            return;
        }
        if (relockMap.containsKey(adm)) {
            LockedDeviceAmin lda = relockMap.get(adm);
            lda.remove(dev.get_name());
        }
    }

    static {
        mainClass = null;
        host_add = null;
        strPID = null;
        hasManagementClasses = true;
        try {
            Class<ManagementFactory> clazz = ManagementFactory.class;
        }
        catch (Exception e) {
            hasManagementClasses = false;
        }
        catch (Error e) {
            hasManagementClasses = false;
        }
        relockMap = null;
    }

    private class LockedDeviceAmin
    extends Thread {
        private DeviceProxy device = null;
        private final String name;
        private long t_relock;
        private final Vector<LockedDevice> devices;

        LockedDeviceAmin(String name, LockedDevice ld) throws DevFailed {
            this.device = DeviceProxyFactory.get(name);
            this.name = name;
            this.devices = new Vector();
            this.devices.add(ld);
            this.t_relock = System.currentTimeMillis();
        }

        private void add(LockedDevice ld_in) {
            for (LockedDevice ld_tmp : this.devices) {
                if (!ld_tmp.name.equals(ld_in.name)) continue;
                return;
            }
            this.devices.add(ld_in);
            this.wakeUp();
        }

        private String[] getDeviceNames() {
            String[] array = new String[this.devices.size()];
            for (int i = 0; i < this.devices.size(); ++i) {
                array[i] = this.devices.get(i).name;
            }
            return array;
        }

        private void remove(String devname) {
            for (int i = 0; i < this.devices.size(); ++i) {
                LockedDevice ld = this.devices.get(i);
                if (!ld.name.equals(devname)) continue;
                this.devices.remove(ld);
            }
            if (this.devices.size() == 0) {
                relockMap.remove(this.name);
            }
            this.wakeUp();
        }

        private void cleanUp() {
            try {
                DevVarLongStringArray lsa = new DevVarLongStringArray();
                lsa.svalue = new String[this.devices.size()];
                for (int i = 0; i < this.devices.size(); ++i) {
                    lsa.svalue[i] = this.devices.get(0).name;
                }
                lsa.lvalue = new int[1];
                lsa.lvalue[0] = 1;
                DeviceData argin = new DeviceData();
                argin.insert(lsa);
                DeviceProxy dev = DeviceProxyFactory.get(this.name);
                dev.import_admin_device("CleanUp");
                dev.getAdm_dev().command_inout("UnlockDevice", argin);
                System.out.println("all devices unlocked.");
            }
            catch (DevFailed e) {
                Except.print_exception(e);
            }
        }

        private int getMinValidity() {
            int min = 0xFFFFFFF;
            for (LockedDevice dev : this.devices) {
                if (min <= dev.validity) continue;
                min = dev.validity;
            }
            if (min == 0xFFFFFFF) {
                min = 1;
            }
            return min;
        }

        private void traceRelock(String[] devnames) {
            System.out.print(this.name + ":\tRelockDevices for ");
            for (String devname : devnames) {
                System.out.print(" " + devname);
            }
            System.out.println();
        }

        private void relock() {
            String[] devnames = this.getDeviceNames();
            this.traceRelock(devnames);
            try {
                DeviceData argin = new DeviceData();
                argin.insert(devnames);
                this.device.command_inout("RelockDevices", argin);
            }
            catch (DevFailed e) {
                for (DevError error : e.errors) {
                    String desc;
                    int idx;
                    String reason = error.reason;
                    if (reason.equals("TangoApi_DEVICE_NOT_EXPORTED")) {
                        for (String devname : devnames) {
                            this.remove(devname);
                        }
                        continue;
                    }
                    if (!reason.equals("API_DeviceNotLocked") && !reason.equals("API_DeviceLocked") || (idx = (desc = error.desc).indexOf(58)) <= 0) continue;
                    String devname = desc.substring(0, idx).trim();
                    this.remove(devname);
                }
            }
        }

        private synchronized void wakeUp() {
            this.notify();
        }

        private long getTimeToSleep() {
            long now = System.currentTimeMillis();
            int minValidity = this.getMinValidity() * 1000;
            return (long)minValidity - (now - this.t_relock) - 500L;
        }

        private synchronized void waitNext() {
            long t_sleep = this.getTimeToSleep();
            while (t_sleep > 500L && this.devices.size() > 0) {
                try {
                    this.wait(t_sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                t_sleep = this.getTimeToSleep();
            }
        }

        @Override
        public void run() {
            while (this.devices.size() > 0) {
                this.waitNext();
                if (this.devices.size() <= 0) continue;
                this.relock();
                this.t_relock = System.currentTimeMillis();
            }
            System.out.println("thread for " + this.name + "  exiting....");
        }
    }

    private class LockedDevice {
        private final String name;
        private final int validity;

        LockedDevice(String devname, int valid) {
            this.name = devname;
            this.validity = valid;
        }
    }

    private class GarbageThread
    extends Thread {
        private GarbageThread() {
        }

        @Override
        public void run() {
            long period = 9500L;
            while (true) {
                if (relockMap.size() > 0) {
                    System.gc();
                }
                try {
                    GarbageThread.sleep(9500L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            System.out.println("exiting.....");
            Enumeration keys = relockMap.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                LockedDeviceAmin lda = (LockedDeviceAmin)relockMap.get(key);
                lda.cleanUp();
            }
        }
    }
}

