/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevInfo_3;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.Device;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.Device_2Helper;
import fr.esrf.Tango.Device_3Helper;
import fr.esrf.Tango.Device_4Helper;
import fr.esrf.Tango.Device_5Helper;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.ApiUtilDAODefaultImpl;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DevLockManager;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IConnectionDAO;
import fr.esrf.TangoApi.TacoTangoDevice;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.IDLEntity;

public class ConnectionDAODefaultImpl
implements ApiDefs,
IConnectionDAO {
    private boolean firstTime = true;

    @Override
    public Device get_device(Connection connection) {
        return connection.device;
    }

    private String buildUrlName(String host, String port) {
        try {
            return "tango://" + TangoUrl.getCanonicalName(host) + ":" + port;
        }
        catch (DevFailed e) {
            return "tango://" + host + ":" + port;
        }
    }

    private String buildUrlName(String host, String port, String devname) {
        try {
            return "tango://" + TangoUrl.getCanonicalName(host) + ":" + port + "/" + devname;
        }
        catch (DevFailed e) {
            return "tango://" + host + ":" + port + "/" + devname;
        }
    }

    @Override
    public void init(Connection connection) throws DevFailed {
        connection.url = new TangoUrl();
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    @Override
    public void init(Connection connection, String host, String port) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(TangoUrl.getCanonicalName(host), port));
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    @Override
    public void init(Connection connection, String host, String port, boolean auto_reconnect) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(TangoUrl.getCanonicalName(host), port));
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = auto_reconnect;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    @Override
    public void init(Connection connection, String devname) throws DevFailed {
        connection.url = new TangoUrl(devname);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    @Override
    public void init(Connection connection, DbDevImportInfo info) throws DevFailed {
        connection.url = new TangoUrl(info.name);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = info.ior;
        }
        connection.classname = info.classname;
        try {
            this.initCtrlAccess(connection);
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
    }

    @Override
    public void init(Connection connection, String devname, boolean check_access) throws DevFailed {
        connection.url = new TangoUrl(devname);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        connection.check_access = check_access;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    @Override
    public void init(Connection connection, String devname, String param, int src) throws DevFailed {
        connection.devname = devname;
        connection.setDevice_is_dbase(false);
        if (src == 1) {
            connection.ior = param;
            connection.url = new TangoUrl();
            connection.url.protocol = 0;
        } else {
            Except.throw_wrong_syntax_exception("TangoApi_INVALID_ARGS", "Invalid argument", "Connection.Connection()");
        }
    }

    @Override
    public void init(Connection connection, String devname, String host, String port) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(host, port, devname));
        connection.devname = connection.url.devname;
        connection.setDevice_is_dbase(false);
        if (connection.url.protocol == 0) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    @Override
    public synchronized void build_connection(Connection connection) throws DevFailed {
        if (!connection.deviceCreated() && connection.devname != null) {
            long t = System.currentTimeMillis();
            long delay = t - connection.getPrev_failed_t0();
            boolean try_reconnection = true;
            if (connection.isDevice_is_dbase()) {
                this.connect_to_dbase(connection);
            } else {
                try {
                    if (connection.url.protocol == 0) {
                        if (connection instanceof DeviceProxy) {
                            ((DeviceProxy)connection).setAdm_dev(null);
                        }
                        if (connection.isPrev_failed() && delay < (long)ApiUtil.getReconnectionDelay()) {
                            try_reconnection = false;
                            throw connection.getPrev_failed();
                        }
                        connection.setPrev_failed_t0(t);
                        if (connection.url.use_db) {
                            this.dev_import(connection);
                        } else {
                            this.dev_import_without_dbase(connection);
                        }
                        connection.setPrev_failed(null);
                    } else if (connection.url.protocol == 1 && connection.taco_device == null) {
                        connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
                    }
                }
                catch (DevFailed e) {
                    if (try_reconnection) {
                        connection.setPrev_failed_t0(t);
                        connection.setPrev_failed(e);
                    }
                    connection.ior = null;
                    Except.throw_communication_failed(e, "TangoApi_CANNOT_IMPORT_DEVICE", "Cannot import " + connection.devname, "Connection.build_connection(" + connection.devname + ")");
                }
            }
        }
    }

    private void createDevice(Connection connection, String corba_str) throws DevFailed {
        try {
            ORB orb = ApiUtil.get_orb();
            connection.setObj(orb.string_to_object(corba_str));
        }
        catch (RuntimeException e) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_VALID", e.toString().substring(e.toString().indexOf(":") + 2), "Connection.createDevice()");
        }
        String strTimeout = ApiUtil.getStrDefaultTimeout();
        if (strTimeout == null) {
            strTimeout = "3000";
        }
        try {
            connection.setDev_timeout(Integer.parseInt(strTimeout));
        }
        catch (Exception e) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            e.printStackTrace();
        }
        this.set_obj_timeout(connection, connection.getDev_timeout());
        if (connection.getObj()._is_a("IDL:Tango/Device_5:1.0")) {
            connection.device_5 = Device_5Helper.narrow(connection.getObj());
            connection.device_4 = connection.device_5;
            connection.device_3 = connection.device_5;
            connection.device_2 = connection.device_5;
            connection.device = connection.device_5;
            connection.idl_version = 5;
        } else if (connection.getObj()._is_a("IDL:Tango/Device_4:1.0")) {
            connection.device_5 = null;
            connection.device_4 = Device_4Helper.narrow(connection.getObj());
            connection.device_3 = connection.device_4;
            connection.device_2 = connection.device_4;
            connection.device = connection.device_4;
            connection.idl_version = 4;
        } else if (connection.getObj()._is_a("IDL:Tango/Device_3:1.0")) {
            connection.device_5 = null;
            connection.device_4 = null;
            connection.device_3 = Device_3Helper.narrow(connection.getObj());
            connection.device_2 = connection.device_3;
            connection.device = connection.device_3;
            connection.idl_version = 3;
        } else if (connection.getObj()._is_a("IDL:Tango/Device_2:1.0")) {
            System.err.println("Device " + connection.get_name() + " is a Tango/Device_2:1.0 !!!!!!!!!");
            connection.device_5 = null;
            connection.device_4 = null;
            connection.device_3 = null;
            connection.device_2 = Device_2Helper.narrow(connection.getObj());
            connection.device = connection.device_2;
            connection.idl_version = 2;
        } else if (connection.getObj()._is_a("IDL:Tango/Device:1.0")) {
            System.err.println("Device " + connection.get_name() + " is a Tango/Device:1.0 !!!!!!!!!");
            connection.device_5 = null;
            connection.device_4 = null;
            connection.device_3 = null;
            connection.device_2 = null;
            connection.device = DeviceHelper.narrow(connection.getObj());
            connection.idl_version = 1;
        } else {
            System.err.println("TangoApi_DEVICE_IDL_UNKNOWN!");
            Except.throw_non_supported_exception("TangoApi_DEVICE_IDL_UNKNOWN", connection.devname + " has an IDL revision not supported !", "Connection.createDevice(" + connection.devname + ")");
        }
        connection.getObj()._is_a("Dummy");
    }

    @Override
    public String get_ior(Connection connection) throws DevFailed {
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strPort);
        DbDevImportInfo info = db.import_device(connection.devname);
        return info.ior;
    }

    @Override
    public String get_host_name(Connection connection) throws DevFailed {
        if (connection.url.use_db) {
            Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strPort);
            DbDevImportInfo info = db.import_device(connection.devname);
            return info.hostname;
        }
        return connection.url.host;
    }

    @Override
    public String get_server_name(Connection connection) throws DevFailed {
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strPort);
        DbDevImportInfo info = db.import_device(connection.devname);
        return info.server;
    }

    @Override
    public String get_class_name(Connection connection) throws DevFailed {
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strPort);
        if (connection.classname == null) {
            DbDevImportInfo info = db.import_device(connection.devname);
            connection.classname = info.classname;
        }
        return connection.classname;
    }

    private void initCtrlAccess(Connection connection) throws DevFailed {
        connection.access = connection.url.use_db && connection.check_access && !connection.check_access_done ? ApiUtil.get_db_obj(connection.url.host, connection.url.strPort).checkAccessControl(connection.devname, connection.url) : 1;
        connection.check_access_done = true;
    }

    private String get_exported_ior(Connection connection) throws DevFailed {
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strPort);
        DbDevImportInfo info = db.import_device(connection.devname);
        String result = null;
        if (info.exported) {
            result = info.ior;
        }
        if (info.is_taco) {
            connection.url.protocol = 1;
        } else {
            try {
                this.initCtrlAccess(connection);
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
            }
        }
        return result;
    }

    @Override
    public void dev_import(Connection connection) throws DevFailed {
        Database db = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strPort);
        String local_ior = null;
        boolean ior_read = false;
        if (connection.ior == null) {
            DbDevImportInfo info = db.import_device(connection.devname);
            if (info.exported) {
                local_ior = info.ior;
                ior_read = true;
            } else {
                Except.throw_connection_failed("TangoApi_DEVICE_NOT_EXPORTED", connection.devname + " Not Exported !", "Connection(" + connection.devname + ")");
            }
        } else {
            local_ior = connection.ior;
        }
        try {
            try {
                this.createDevice(connection, local_ior);
            }
            catch (Exception e0) {
                if (ior_read || connection.isAlready_connected()) {
                    throw e0;
                }
                if (e0.toString().startsWith("org.omg.CORBA.TRANSIENT")) {
                    throw e0;
                }
                connection.ior = null;
                this.dev_import(connection);
            }
            connection.setAlready_connected(true);
            connection.ior = local_ior;
        }
        catch (DevFailed e) {
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.device_5 = null;
            connection.ior = null;
            throw e;
        }
        catch (Exception e) {
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.device_5 = null;
            connection.ior = null;
            String reason = "TangoApi_CANNOT_IMPORT_DEVICE";
            String s = connection.isAlready_connected() ? "Re-" : "";
            String desc = "Cannot " + s + "import " + connection.devname + " :\n\t" + e.toString();
            String origin = "Connection.dev_import(" + connection.devname + ")";
            Except.throw_connection_failed("TangoApi_CANNOT_IMPORT_DEVICE", desc, origin);
        }
    }

    private void connect_to_dbase(Connection connection) throws DevFailed {
        if (connection.device == null) {
            try {
                String db_corbaloc = "corbaloc:iiop:" + connection.url.host + ":" + connection.url.strPort + "/database";
                this.createDevice(connection, db_corbaloc);
                connection.classname = "Database";
            }
            catch (SystemException ex) {
                if (connection.transparent_reconnection) {
                    try {
                        DbRedundancy dbr = DbRedundancy.get_instance();
                        String th2 = dbr.get(connection.url.host + ":" + connection.url.port);
                        String db_corbaloc = "corbaloc:iiop:" + th2 + "/database";
                        this.createDevice(connection, db_corbaloc);
                    }
                    catch (SystemException e) {
                        connection.device = null;
                        connection.ior = null;
                        Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + e, "connect_to_dbase(" + connection.url.host + "," + connection.url.strPort + ")");
                    }
                }
                connection.device = null;
                connection.ior = null;
                Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + ex, "connect_to_dbase(" + connection.url.host + "," + connection.url.strPort + ")");
            }
        }
    }

    private void dev_import_without_dbase(Connection connection) throws DevFailed {
        if (connection.device == null) {
            try {
                String db_corbaloc = "corbaloc:iiop:" + connection.url.host + ":" + connection.url.strPort + "/" + connection.devname.toLowerCase();
                this.createDevice(connection, db_corbaloc);
                connection.access = 1;
            }
            catch (SystemException e) {
                connection.device = null;
                connection.ior = null;
                Except.throw_connection_failed("TangoApi_DEVICE_CONNECTION_FAILED", "Connection to device without database failed  !\n" + e, "Connection.dev_import_without_dbase(" + connection.url.host + "," + connection.url.strPort + ")");
            }
        }
    }

    private void set_obj_timeout(Connection connection, int millis) {
        RelativeRoundtripTimeoutPolicy p = new RelativeRoundtripTimeoutPolicy(10000 * millis);
        Object obj = connection.getObj()._set_policy_override(new Policy[]{p}, SetOverrideType.ADD_OVERRIDE);
        connection.setObj(obj);
        switch (connection.idl_version) {
            case 5: {
                connection.device_5 = Device_5Helper.narrow(obj);
                break;
            }
            case 4: {
                connection.device_4 = Device_4Helper.narrow(obj);
                break;
            }
            case 3: {
                connection.device_3 = Device_3Helper.narrow(obj);
                break;
            }
            case 2: {
                connection.device_2 = Device_2Helper.narrow(obj);
                break;
            }
            default: {
                connection.device = DeviceHelper.narrow(obj);
            }
        }
        connection.setDev_timeout(millis);
    }

    @Override
    public void set_timeout_millis(Connection connection, int millis) throws DevFailed {
        this.build_connection(connection);
        if (connection.url.protocol == 1) {
            connection.taco_device.set_rpc_timeout(millis);
            return;
        }
        this.set_obj_timeout(connection, millis);
    }

    @Override
    @Deprecated
    public int get_timeout(Connection connection) {
        return connection.getDev_timeout();
    }

    @Override
    public int get_timeout_millis(Connection connection) throws DevFailed {
        this.build_connection(connection);
        if (connection.url.protocol == 1) {
            return connection.taco_device.get_rpc_timeout();
        }
        return connection.getDev_timeout();
    }

    @Override
    public void throw_dev_failed(Connection connection, Exception e, String command, boolean from_inout_cmd) throws DevFailed {
        String origin;
        if (e instanceof DevFailed) {
            throw (DevFailed)e;
        }
        String string = origin = from_inout_cmd ? connection.devname + ".command_inout(" + command + ")" : connection.devname + "." + command + ")";
        if (e.toString().contains("org.omg.CORBA.NO_RESPONSE") || e.toString().contains("org.omg.CORBA.TIMEOUT") || e.toString().contains("org.omg.CORBA.IMP_LIMIT")) {
            String desc = "Device (" + connection.devname + ") timed out (>" + connection.getDev_timeout() + " ms)!";
            Except.throw_communication_timeout(e.toString(), desc, origin);
        } else if (e.toString().contains("org.omg.CORBA.BAD_INV_ORDER")) {
            String desc = "Lost Connection during command : " + command;
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.device_5 = null;
            connection.ior = null;
            Except.throw_connection_failed(e.toString(), desc, origin);
        } else if (e.toString().contains("org.omg.CORBA.TRANSIENT") || e.toString().contains("org.omg.CORBA.UNKNOWN") || e.toString().contains("org.omg.CORBA.COMM_FAILURE") || e.toString().contains("org.omg.CORBA.OBJECT_NOT_EXIST")) {
            String desc = "Lost Connection during command : " + command;
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.device_5 = null;
            connection.ior = null;
            Except.throw_connection_failed(e.toString(), desc, origin);
        } else if (e.toString().startsWith("java.lang.RuntimeException")) {
            String desc = "API has catched a RuntimeException" + command;
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.device_5 = null;
            connection.ior = null;
            Except.throw_connection_failed(e.toString(), desc, origin);
        } else {
            System.out.println("API has caught an exception for " + origin + " : \n" + e);
            String desc = e.getMessage();
            Except.throw_communication_failed(e.toString(), desc, origin);
        }
    }

    protected void throwNotAuthorizedException(String desc, String origin) throws DevFailed {
        Except.throw_connection_failed("TangoApi_READ_ONLY_MODE", desc + "   is not authorized for:\n" + ApiUtilDAODefaultImpl.getUser() + "  on   " + ApiUtil.getHostName(), origin);
    }

    @Override
    public DeviceData command_inout(Connection connection, String command, DeviceData argin) throws DevFailed {
        Database db;
        Any received = null;
        this.build_connection(connection);
        if (connection.url.protocol == 1) {
            return connection.taco_device.command_inout(command, argin);
        }
        if (connection.access == 0 && !(db = ApiUtil.get_db_obj(connection.url.host, connection.url.strPort)).isCommandAllowed(connection.get_class_name(), command)) {
            if (db.access_devfailed != null) {
                throw db.access_devfailed;
            }
            if (this.firstTime && connection instanceof Database) {
                this.firstTime = false;
                return this.command_inout(connection, command, argin);
            }
            this.ping(connection);
            System.out.println(connection.devname + "." + command + "  -> TangoApi_READ_ONLY_MODE");
            this.throwNotAuthorizedException(connection.devname + ".command_inout(" + command + ")", "Connection.command_inout()");
        }
        boolean done = false;
        int timeoutReconnection = this.get_timeout_millis(connection);
        int retries = connection.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < retries && !done; ++i) {
            try {
                if (i > 0) {
                    connection.set_timeout_millis(timeoutReconnection);
                }
                received = connection.device_5 != null ? connection.device_5.command_inout_4(command, argin.extractAny(), connection.dev_src, DevLockManager.getInstance().getClntIdent()) : (connection.device_4 != null ? connection.device_4.command_inout_4(command, argin.extractAny(), connection.dev_src, DevLockManager.getInstance().getClntIdent()) : (connection.device_2 != null ? connection.device_2.command_inout_2(command, argin.extractAny(), connection.dev_src) : connection.device.command_inout(command, argin.extractAny())));
                done = true;
                continue;
            }
            catch (DevFailed e) {
                String reason = "TangoApi_CANNOT_EXECUTE_COMMAND";
                String desc = "Cannot execute command " + command + " on " + connection.devname;
                String origin = "Connection.command_inout()";
                if (e.errors[0].reason.equals("DB_DeviceNotDefined")) {
                    String d = e.errors[0].desc;
                    int idx = d.lastIndexOf("!");
                    if (idx > 0) {
                        d = d.substring(0, idx);
                    }
                    e.errors[0].desc = d = d + "  " + connection.url.host + ":" + connection.url.port + " !";
                }
                Except.throw_connection_failed(e, "TangoApi_CANNOT_EXECUTE_COMMAND", desc, "Connection.command_inout()");
                continue;
            }
            catch (Exception e) {
                this.manageExceptionReconnection(connection, retries, i, e, this.getClass() + ".command_inout");
            }
        }
        return new DeviceData(received);
    }

    @Override
    public DeviceData command_inout(Connection connection, String command) throws DevFailed {
        DeviceData argin = new DeviceData();
        return this.command_inout(connection, command, argin);
    }

    @Override
    public long ping(Connection connection) throws DevFailed {
        boolean retry;
        long result = 0L;
        int maxRetries = connection.transparent_reconnection ? 1 : 0;
        int nbRetries = 0;
        do {
            try {
                result = this.doPing(connection);
                retry = false;
            }
            catch (DevFailed e) {
                if (nbRetries >= maxRetries) {
                    throw e;
                }
                retry = true;
                ++nbRetries;
            }
        } while (retry);
        return result;
    }

    private long doPing(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "ping");
        this.build_connection(connection);
        long t0 = System.currentTimeMillis();
        try {
            connection.device.ping();
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_PING_DEVICE";
            String desc = "Cannot ping " + connection.devname;
            String origin = "Connection.ping()";
            Except.throw_connection_failed(e, "TangoApi_CANNOT_PING_DEVICE", desc, "Connection.ping()");
        }
        catch (Exception e) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, e, "ping", false);
        }
        long t1 = System.currentTimeMillis();
        return (int)(t1 - t0) * 1000;
    }

    @Override
    public String[] black_box(Connection connection, int length) throws DevFailed {
        this.checkIfTango(connection, "black_box");
        this.build_connection(connection);
        String[] result = new String[]{};
        try {
            result = connection.device.black_box(length);
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ_BLACK BOX";
            String desc = "Cannot read black box on " + connection.devname;
            String origin = "Connection.black_box()";
            Except.throw_connection_failed(e, "TangoApi_CANNOT_READ_BLACK BOX", desc, "Connection.black_box()");
        }
        catch (Exception e) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, e, "black_box", false);
        }
        return result;
    }

    @Override
    public DevInfo_3 info_3(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "info");
        this.build_connection(connection);
        try {
            DevInfo_3 info_3;
            if (connection.device_3 != null) {
                info_3 = connection.device_3.info_3();
            } else {
                DevInfo info = connection.device.info();
                info_3 = new DevInfo_3(info.dev_class, info.server_id, info.server_host, info.server_version, info.doc_url, "");
            }
            return info_3;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String desc = "Cannot read device info on " + connection.devname;
            String origin = "Connection.info()";
            Except.throw_connection_failed(e, "TangoApi_CANNOT_READ _DEVICE_INFO", desc, "Connection.info()");
        }
        catch (Exception e) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, e, "info", false);
        }
        return null;
    }

    @Override
    public DevInfo info(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "info");
        this.build_connection(connection);
        DevInfo info = null;
        try {
            info = connection.device.info();
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String desc = "Cannot read device info on " + connection.devname;
            String origin = "Connection.info()";
            Except.throw_connection_failed(e, "TangoApi_CANNOT_READ _DEVICE_INFO", desc, "Connection.info()");
        }
        catch (Exception e) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, e, "info", false);
        }
        return info;
    }

    @Override
    public CommandInfo[] command_list_query(Connection connection) throws DevFailed {
        this.build_connection(connection);
        int timeoutReconnection = this.get_timeout_millis(connection);
        int retries = connection.transparent_reconnection ? 2 : 1;
        for (int oneTry = 1; oneTry <= retries; ++oneTry) {
            try {
                IDLEntity[] tmp;
                CommandInfo[] result;
                if (oneTry > 0) {
                    connection.set_timeout_millis(timeoutReconnection);
                }
                if (connection.url.protocol == 1) {
                    result = connection.taco_device.commandListQuery();
                } else if (connection.device_2 != null) {
                    tmp = connection.device_2.command_list_query_2();
                    result = new CommandInfo[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        result[i] = new CommandInfo((DevCmdInfo_2)tmp[i]);
                    }
                } else {
                    tmp = connection.device.command_list_query();
                    result = new CommandInfo[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        result[i] = new CommandInfo((DevCmdInfo)tmp[i]);
                    }
                }
                return result;
            }
            catch (DevFailed e) {
                if (oneTry < retries) continue;
                String reason = "TangoApi_CANNOT__READ_CMD_LIST";
                String desc = "Cannot read command list for " + connection.devname;
                String origin = "Connection.command_list_query()";
                Except.throw_connection_failed(e, "TangoApi_CANNOT__READ_CMD_LIST", desc, "Connection.command_list_query()");
                continue;
            }
            catch (Exception e) {
                if (oneTry < retries) continue;
                ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
                this.throw_dev_failed(connection, e, "command_list_query", false);
            }
        }
        return null;
    }

    @Override
    public int get_idl_version(Connection connection) throws DevFailed {
        this.build_connection(connection);
        return connection.idl_version;
    }

    @Override
    public DevSource get_source(Connection connection) throws DevFailed {
        if (this.is_taco(connection)) {
            if (connection.taco_device == null) {
                connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
            }
            return connection.taco_device.get_source();
        }
        return connection.dev_src;
    }

    @Override
    public void set_source(Connection connection, DevSource new_src) throws DevFailed {
        if (this.is_taco(connection)) {
            if (connection.taco_device == null) {
                connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
            }
            connection.taco_device.set_source(new_src);
        } else {
            connection.dev_src = new_src;
        }
    }

    @Override
    public String get_name(Connection connection) {
        return connection.devname;
    }

    @Override
    public String description(Connection connection) throws DevFailed {
        this.build_connection(connection);
        return connection.device.description();
    }

    @Override
    public String adm_name(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "adm_name");
        this.build_connection(connection);
        String name = null;
        try {
            name = connection.device.adm_name();
        }
        catch (Exception e) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, e, "adm_name", false);
        }
        if (name != null && !name.startsWith("tango://") && !name.startsWith("//")) {
            name = "tango://" + connection.url.host + ":" + connection.url.port + "/" + name;
        }
        if (!connection.url.use_db) {
            name = name + "#dbase=no";
        }
        return name;
    }

    @Override
    public String get_tango_host(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "get_tango_host");
        return connection.url.host + ":" + connection.url.strPort;
    }

    @Override
    public boolean is_taco(Connection connection) {
        return connection.url.protocol == 1;
    }

    @Override
    public void checkIfTaco(Connection connection, String cmdname) throws DevFailed {
        if (!this.is_taco(connection)) {
            Except.throw_non_supported_exception("TangoApi_NOT_TANGO_CMD", cmdname + " is NOT a TANGO command.", cmdname + "()");
        }
    }

    @Override
    public void checkIfTango(Connection connection, String cmdname) throws DevFailed {
        if (this.is_taco(connection)) {
            Except.throw_non_supported_exception("TangoApi_NOT_TACO_CMD", cmdname + " is NOT a TACO command.", cmdname + "()");
        }
    }

    @Override
    public boolean get_transparency_reconnection(Connection connection) {
        return connection.transparent_reconnection;
    }

    @Override
    public void set_transparency_reconnection(Connection connection, boolean val) {
        connection.transparent_reconnection = val;
    }

    @Override
    public int getAccessControl(Connection connection) {
        return connection.access;
    }

    @Override
    public void setAccessControl(Connection connection, int access) {
        connection.access = access;
    }

    @Override
    public boolean isAllowedCommand(Connection connection, String cmd) throws DevFailed {
        Database db = ApiUtil.get_db_obj(connection.url.host, connection.url.strPort);
        return db.isCommandAllowed(connection.get_class_name(), cmd);
    }

    protected void manageExceptionReconnection(Connection deviceProxy, int retries, int i, Exception e, String origin) throws DevFailed {
        ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(deviceProxy);
        if (i == 0 && (e.toString().contains("org.omg.CORBA.TRANSIENT") || e.toString().contains("org.omg.CORBA.OBJECT_NOT_EXIST") || e.toString().contains("org.omg.CORBA.COMM_FAILURE"))) {
            deviceProxy.device = null;
            deviceProxy.device_2 = null;
            deviceProxy.device_3 = null;
            deviceProxy.device_4 = null;
            deviceProxy.device_5 = null;
            deviceProxy.ior = null;
            this.build_connection(deviceProxy);
            if (i == retries - 1) {
                this.throw_dev_failed(deviceProxy, e, origin, false);
            }
        } else {
            this.throw_dev_failed(deviceProxy, e, origin, false);
        }
    }
}

