/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;
import java.util.Collections;

public class AttributeProxy
implements ApiDefs,
Serializable {
    private String full_deviceName = null;
    private String deviceName = null;
    private DeviceProxy dev;
    private int idl_version = -1;

    public AttributeProxy(String deviceName) throws DevFailed {
        if (deviceName.indexOf(47) < 0) {
            String alias = deviceName;
            deviceName = ApiUtil.get_db_obj().get_attribute_from_alias(alias);
        }
        String devname = deviceName.substring(0, deviceName.lastIndexOf("/", deviceName.length() - 1));
        this.full_deviceName = deviceName;
        this.deviceName = deviceName.substring(deviceName.lastIndexOf("/", deviceName.length() - 1) + 1);
        String noDB = "#dbase=no";
        if (this.deviceName.endsWith(noDB)) {
            int pos = this.deviceName.indexOf(noDB);
            devname = devname + noDB;
            this.deviceName = this.deviceName.substring(0, pos);
        }
        this.dev = DeviceProxyFactory.get(devname);
    }

    public String get_alias() throws DevFailed {
        return ApiUtil.get_db_obj().get_alias_from_attribute(this.deviceName);
    }

    public void set_timeout_millis(int millis) throws DevFailed {
        this.dev.set_timeout_millis(millis);
    }

    public DeviceProxy getDeviceProxy() {
        return this.dev;
    }

    public int get_idl_version() throws DevFailed {
        if (this.idl_version < 0) {
            this.idl_version = this.dev.get_idl_version();
        }
        return this.idl_version;
    }

    public String fullName() {
        return this.full_deviceName;
    }

    public String name() {
        return this.deviceName;
    }

    public long ping() throws DevFailed {
        return this.dev.ping();
    }

    public DevState state() throws DevFailed {
        return this.dev.state();
    }

    public String status() throws DevFailed {
        return this.dev.status();
    }

    public DbAttribute get_property() throws DevFailed {
        return this.dev.get_attribute_property(this.deviceName);
    }

    public void put_property(DbDatum property) throws DevFailed {
        DbAttribute db_att = new DbAttribute(this.deviceName);
        db_att.add(property);
        this.dev.put_attribute_property(db_att);
    }

    public void put_property(DbDatum[] properties) throws DevFailed {
        DbAttribute db_att = new DbAttribute(this.deviceName);
        Collections.addAll(db_att, properties);
        this.dev.put_attribute_property(db_att);
    }

    public void delete_property(String propname) throws DevFailed {
        this.dev.delete_attribute_property(this.deviceName, propname);
    }

    public void delete_property(String[] propnames) throws DevFailed {
        this.dev.delete_attribute_property(this.deviceName, propnames);
    }

    public AttributeInfo get_info() throws DevFailed {
        return this.dev.get_attribute_info(this.deviceName);
    }

    public AttributeInfoEx get_info_ex() throws DevFailed {
        return this.dev.get_attribute_info_ex(this.deviceName);
    }

    public void set_info(AttributeInfo[] attr) throws DevFailed {
        this.dev.set_attribute_info(attr);
    }

    public void set_info(AttributeInfoEx[] attr) throws DevFailed {
        this.dev.set_attribute_info(attr);
    }

    public DeviceAttribute read() throws DevFailed {
        return this.dev.read_attribute(this.deviceName);
    }

    public void write(DeviceAttribute devattr) throws DevFailed {
        this.dev.write_attribute(devattr);
    }

    public DeviceAttribute write_read_attribute(DeviceAttribute devattr) throws DevFailed {
        return this.dev.write_read_attribute(devattr);
    }

    public DeviceAttribute[] write_read_attribute(DeviceAttribute[] devattr) throws DevFailed {
        return this.dev.write_read_attribute(devattr);
    }

    public DeviceDataHistory[] history(int nb) throws DevFailed {
        return this.dev.attribute_history(this.deviceName, nb);
    }

    public DeviceDataHistory[] history() throws DevFailed {
        return this.dev.attribute_history(this.deviceName);
    }

    public void poll(int period) throws DevFailed {
        this.dev.poll_attribute(this.deviceName, period);
    }

    public int get_polling_period() throws DevFailed {
        return this.dev.get_attribute_polling_period(this.deviceName);
    }

    public void stop_poll() throws DevFailed {
        this.dev.stop_poll_attribute(this.deviceName);
    }

    public int read_asynch() throws DevFailed {
        return this.dev.read_attribute_asynch(this.deviceName);
    }

    public void read_asynch(CallBack cb) throws DevFailed {
        this.dev.read_attribute_asynch(this.deviceName, cb);
    }

    public DeviceAttribute[] read_reply(int id, int timeout) throws DevFailed {
        return this.dev.read_attribute_reply(id, timeout);
    }

    public DeviceAttribute[] read_reply(int id) throws DevFailed {
        return this.dev.read_attribute_reply(id);
    }

    public int write_asynch(DeviceAttribute attr) throws DevFailed {
        return this.dev.write_attribute_asynch(attr);
    }

    public int write_asynch(DeviceAttribute attr, boolean forget) throws DevFailed {
        return this.dev.write_attribute_asynch(attr, forget);
    }

    public void write_asynch(DeviceAttribute attr, CallBack cb) throws DevFailed {
        this.dev.write_attribute_asynch(attr, cb);
    }

    public void write_reply(int id) throws DevFailed {
        this.dev.write_attribute_reply(id);
    }

    public void write_reply(int id, int timeout) throws DevFailed {
        this.dev.write_attribute_reply(id, timeout);
    }

    public int subscribe_event(int event, CallBack callback, String[] filters) throws DevFailed {
        return this.dev.subscribe_event(this.deviceName, event, callback, filters);
    }

    public static void main(String[] args) {
        String deviceName = "tango/admin/corvus/hoststate";
        try {
            AttributeProxy att = new AttributeProxy(deviceName);
            att.ping();
            System.out.println(att.name() + " is alive");
            DbAttribute db_att = att.get_property();
            for (int i = 0; i < db_att.size(); ++i) {
                DbDatum datum = db_att.datum(i);
                System.out.println(datum.name + " : " + datum.extractString());
            }
            DeviceAttribute da = att.read();
            System.out.println(att.name() + " : " + da.extractShort());
            System.out.println(att.name() + " state  : " + ApiUtil.stateName(att.state()));
            System.out.println(att.name() + " status : " + att.status());
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
    }
}

