/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.factory.TangoFactory;
import fr.esrf.TangoApi.AsyncCallObject;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbPipe;
import fr.esrf.TangoApi.DevLockManager;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.HostInfo;
import fr.esrf.TangoApi.IApiUtilDAO;
import fr.esrf.TangoApi.TangoEnv;
import fr.esrf.TangoDs.Except;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Request;

public class ApiUtil {
    public static String revNumber = "9.1.3  -  Mon Apr 25 13:04:57 CEST 2016";
    private static IApiUtilDAO apiutilDAO = TangoFactory.getSingleton().getApiUtilDAO();
    private static int hwmValue = 0;
    protected static ORB orb = null;

    public IApiUtilDAO getApiUtilDAO() {
        return apiutilDAO;
    }

    public void setApiUtilDAO(IApiUtilDAO databaseDAO) {
    }

    public static boolean useDefaultFactory() {
        return TangoFactory.getSingleton().isDefaultFactory();
    }

    public static Database get_db_obj(String tango_host) throws DevFailed {
        return apiutilDAO.get_db_obj(tango_host);
    }

    public static Database get_default_db_obj() throws DevFailed {
        return apiutilDAO.get_default_db_obj();
    }

    public static boolean default_db_obj_exists() throws DevFailed {
        return apiutilDAO.default_db_obj_exists();
    }

    public static synchronized Database get_db_obj() throws DevFailed {
        return apiutilDAO.get_db_obj();
    }

    public static Database get_db_obj(String host, String port) throws DevFailed {
        return apiutilDAO.get_db_obj(host, port);
    }

    public static Database change_db_obj(String host, String port) throws DevFailed {
        return apiutilDAO.change_db_obj(host, port);
    }

    public static Database set_db_obj(String host, String port) throws DevFailed {
        return apiutilDAO.set_db_obj(host, port);
    }

    public static Database set_db_obj(String tango_host) throws DevFailed {
        return apiutilDAO.set_db_obj(tango_host);
    }

    public static ORB get_orb() throws DevFailed {
        return apiutilDAO.get_orb();
    }

    public static String getHostAddress() throws DevFailed {
        return HostInfo.getAddress();
    }

    public static Vector<String> getHostAddresses() throws DevFailed {
        return HostInfo.getAddresses();
    }

    public static String getHostName() throws DevFailed {
        return HostInfo.getName();
    }

    public static void set_in_server(boolean val) {
        apiutilDAO.set_in_server(val);
    }

    public static boolean in_server() {
        return apiutilDAO.in_server();
    }

    public static int getReconnectionDelay() {
        return apiutilDAO.getReconnectionDelay();
    }

    public static int put_async_request(AsyncCallObject aco) {
        return apiutilDAO.put_async_request(aco);
    }

    public static Request get_async_request(int id) throws DevFailed {
        return apiutilDAO.get_async_request(id);
    }

    public static AsyncCallObject get_async_object(int id) {
        return apiutilDAO.get_async_object(id);
    }

    public static void remove_async_request(int id) {
        apiutilDAO.remove_async_request(id);
    }

    public static void set_async_reply_model(int id, int reply_model) {
        apiutilDAO.set_async_reply_model(id, reply_model);
    }

    public static void set_async_reply_cb(int id, CallBack cb) {
        apiutilDAO.set_async_reply_cb(id, cb);
    }

    public static int pending_asynch_call(DeviceProxy dev, int reply_model) {
        return apiutilDAO.pending_asynch_call(dev, reply_model);
    }

    public static int pending_asynch_call(int reply_model) {
        return apiutilDAO.pending_asynch_call(reply_model);
    }

    public static void set_asynch_cb_sub_model(int model) {
        apiutilDAO.set_asynch_cb_sub_model(model);
    }

    public static int get_asynch_cb_sub_model() {
        return apiutilDAO.get_asynch_cb_sub_model();
    }

    public static void get_asynch_replies() {
        apiutilDAO.get_asynch_replies();
    }

    public static void get_asynch_replies(int timeout) {
        apiutilDAO.get_asynch_replies(timeout);
    }

    public static void get_asynch_replies(DeviceProxy dev) {
        apiutilDAO.get_asynch_replies(dev);
    }

    public static void get_asynch_replies(DeviceProxy dev, int timeout) {
        apiutilDAO.get_asynch_replies(dev, timeout);
    }

    public static String[] toStringArray(String objname, String[] argin) {
        String[] array = new String[1 + argin.length];
        array[0] = objname;
        System.arraycopy(argin, 0, array, 1, argin.length);
        return array;
    }

    public static String[] toStringArray(String objname, String argin) {
        String[] array = new String[]{objname, argin};
        return array;
    }

    public static String[] toStringArray(String argin) {
        String[] array = new String[]{argin};
        return array;
    }

    public static String[] toStringArray(String objname, DbAttribute[] attributes, int mode) {
        int nb_attr = attributes.length;
        ArrayList<String> list = new ArrayList<String>();
        list.add(objname);
        list.add(Integer.toString(nb_attr));
        for (DbAttribute attribute : attributes) {
            list.add(attribute.name);
            list.add("" + attribute.size());
            for (int j = 0; j < attribute.size(); ++j) {
                list.add(attribute.get_property_name(j));
                String[] values = attribute.get_value(j);
                if (mode != 1) {
                    list.add("" + values.length);
                }
                list.addAll(Arrays.asList(values));
            }
        }
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (String)list.get(i);
        }
        return array;
    }

    public static String[] toStringArray(String deviceNme, DbPipe dbPipe) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(deviceNme);
        list.add(Integer.toString(1));
        list.add(dbPipe.getName());
        list.add(Integer.toString(dbPipe.size()));
        for (DbDatum datum : dbPipe) {
            if (datum.is_empty()) continue;
            String[] values = datum.extractStringArray();
            list.add(datum.name);
            list.add(Integer.toString(values.length));
            Collections.addAll(list, values);
        }
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            System.out.println((String)list.get(i));
            array[i] = (String)list.get(i);
        }
        return array;
    }

    public static DbAttribute[] toDbAttributeArray(String[] array, int mode) throws DevFailed {
        if (mode < 1 && mode > 2) {
            Except.throw_non_supported_exception("API_NotSupportedMode", "Mode " + mode + " to decode attribute properties is not supported", "ApiUtil.toDbAttributeArray()");
        }
        int idx = 1;
        int nb_attr = Integer.parseInt(array[idx++]);
        DbAttribute[] attr = new DbAttribute[nb_attr];
        for (int i = 0; i < nb_attr; ++i) {
            attr[i] = new DbAttribute(array[idx++]);
            int nb_prop = Integer.parseInt(array[idx++]);
            block5: for (int j = 0; j < nb_prop; ++j) {
                String p_name = array[idx++];
                switch (mode) {
                    case 1: {
                        attr[i].add(p_name, array[idx++]);
                        continue block5;
                    }
                    case 2: {
                        int p_length = Integer.parseInt(array[idx++]);
                        String[] val = new String[p_length];
                        for (int p = 0; p < p_length; ++p) {
                            val[p] = array[idx++];
                        }
                        attr[i].add(p_name, val);
                    }
                }
            }
        }
        return attr;
    }

    public static DbPipe toDbPipe(String pipeName, String[] array) throws DevFailed {
        DbPipe dbPipe = new DbPipe(pipeName);
        try {
            int index = 3;
            int nbProperties = Integer.parseInt(array[index++]);
            for (int i = 0; i < nbProperties; ++i) {
                String propertyName = array[index++];
                int nbValues = Integer.parseInt(array[index++]);
                String[] arrayValues = new String[nbValues];
                for (int v = 0; v < nbValues; ++v) {
                    arrayValues[v] = array[index++];
                }
                dbPipe.add(new DbDatum(propertyName, arrayValues));
            }
        }
        catch (Exception e) {
            Except.throw_exception("TangoApi_SyntaxError", "Cannot convert data to DbPipe: " + e);
        }
        return dbPipe;
    }

    public static String stateName(DevState state) {
        return apiutilDAO.stateName(state);
    }

    public static String stateName(short state_val) {
        return apiutilDAO.stateName(state_val);
    }

    public static String qualityName(AttrQuality att_q) {
        return apiutilDAO.qualityName(att_q);
    }

    public static String qualityName(short att_q_val) {
        return apiutilDAO.qualityName(att_q_val);
    }

    public static String[] parseTangoHost(String tgh) throws DevFailed {
        return apiutilDAO.parseTangoHost(tgh);
    }

    public static ORB getOrb() {
        return orb;
    }

    public static void setOrb(ORB orb) {
        ApiUtil.orb = orb;
    }

    public static String getTangoHost() throws DevFailed {
        return TangoEnv.getTangoHost();
    }

    public static boolean isSuperTango() {
        return TangoEnv.isSuperTango();
    }

    public static String getAccessDevname() {
        return TangoEnv.getAccessDevname();
    }

    public static String getStrDefaultTimeout() {
        return TangoEnv.getStrDefaultTimeout();
    }

    public static String getORBgiopMaxMsgSize() {
        return TangoEnv.getORBgiopMaxMsgSize();
    }

    public static void setEventBufferHWM(int bufferSize) {
        hwmValue = bufferSize;
    }

    public static int getEventBufferHWM() {
        return hwmValue;
    }

    public static void printTrace(String str) {
        String trace = System.getenv("ApiTrace");
        if (trace != null && trace.equals("true")) {
            System.out.println(str);
        }
    }

    public static void writeStackTraceFile(String filename, String deviceName) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            System.out.println(element);
        }
        String host = "";
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int pid = DevLockManager.getInstance().getJvmPid();
        filename = filename + "." + host + "." + pid;
        StringBuilder sb = new StringBuilder(deviceName + ":\n");
        for (StackTraceElement stackTraceElement : stackTrace) {
            sb.append(stackTraceElement).append('\n');
        }
        ApiUtil.writeFile(filename, sb.toString());
    }

    public static void writeFile(String filename, String code) {
        try {
            FileOutputStream fidout = new FileOutputStream(filename);
            fidout.write(code.getBytes());
            fidout.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static int getVersionAsInteger() {
        StringTokenizer stk = new StringTokenizer(revNumber);
        String release = null;
        int i = 0;
        while (stk.hasMoreTokens()) {
            String s = stk.nextToken();
            if (i == 1) {
                release = s;
                break;
            }
            ++i;
        }
        stk = new StringTokenizer(release, ".");
        release = "";
        while (stk.hasMoreTokens()) {
            release = release + stk.nextToken();
        }
        int version2 = 0;
        try {
            version2 = Integer.parseInt(release);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version2;
    }

    public static String getVersionAsString() {
        return revNumber;
    }

    public static double getZmqVersion() {
        return apiutilDAO.getZmqVersion();
    }

    public static long toLongUnsigned(int intValue) {
        long mask = Integer.MAX_VALUE;
        return (long)intValue & (mask += 0x80000000L);
    }
}

