/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangoEnv;
import fr.esrf.TangoDs.Except;
import java.util.Hashtable;
import java.util.Vector;

class AccessProxy
extends DeviceProxy {
    protected static String user = null;
    protected static String hostAddr = null;
    protected boolean forced = TangoEnv.isSuperTango();
    private static boolean muliIP = true;
    private static final Object monitor = new Object();
    protected Hashtable<String, String> dev_right_table = new Hashtable();
    protected Hashtable<String, String[]> allowed_cmd_table = new Hashtable();

    AccessProxy(String devname) throws DevFailed {
        super(devname, false);
        if (!this.forced) {
            this.set_transparency_reconnection(false);
            this.ping();
            this.set_transparency_reconnection(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkAccessControl(String devName) throws DevFailed {
        if (this.forced) {
            return 1;
        }
        Object object = monitor;
        synchronized (object) {
            String str = this.dev_right_table.get(devName);
            if (str != null) {
                if (str.equals("write")) {
                    return 1;
                }
                return 0;
            }
            try {
                String rights;
                if (user == null) {
                    user = System.getProperty("user.name").toLowerCase();
                }
                hostAddr = ApiUtil.getHostAddress();
                DeviceData argin = new DeviceData();
                if (muliIP) {
                    Vector<String> addresses = ApiUtil.getHostAddresses();
                    String[] array = new String[addresses.size() + 2];
                    int i = 0;
                    array[i++] = user;
                    array[i++] = devName;
                    for (String address : addresses) {
                        array[i++] = address;
                    }
                    argin.insert(array);
                    rights = this.command_inout("GetAccessForMultiIP", argin).extractString();
                } else {
                    argin.insert(new String[]{user, hostAddr, devName});
                    rights = this.command_inout("GetAccess", argin).extractString();
                }
                this.dev_right_table.put(devName, rights);
                if (rights.equals("write")) {
                    return 1;
                }
                return 0;
            }
            catch (DevFailed e) {
                if (!e.errors[0].reason.equals("TangoApi_DEVICE_NOT_EXPORTED")) {
                    if (muliIP && e.errors[0].reason.equals("API_CommandNotFound")) {
                        System.err.println(e.errors[0].desc + "  -  TAC server is an old version");
                        muliIP = false;
                        return this.checkAccessControl(devName);
                    }
                    throw e;
                }
                Except.re_throw_exception(e, "TangoApi_CANNOT_CHECK_ACCESS_CONTROL", "Cannot import Access Control device !", "AccessProxy.checkAccessControl()");
            }
        }
        return 0;
    }

    boolean isCommandAllowed(String classname, String cmd) {
        String[] allowed = this.allowed_cmd_table.get(classname);
        if (allowed == null) {
            allowed = this.getAllowedCommands(classname);
        }
        if (allowed.length == 0) {
            return false;
        }
        for (String anAllowed : allowed) {
            if (!anAllowed.toLowerCase().equals(cmd.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected String[] getAllowedCommands(String classname) {
        try {
            DeviceData argin = new DeviceData();
            argin.insert(classname);
            DeviceData argout = this.command_inout("GetAllowedCommands", argin);
            String[] allowed = argout.extractStringArray();
            this.allowed_cmd_table.put(classname, allowed);
            return allowed;
        }
        catch (DevFailed e) {
            String[] dummy = new String[]{};
            this.allowed_cmd_table.put(classname, dummy);
            return dummy;
        }
    }
}

