/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.failover;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.toys.delegate.SimpleReference;
import com.thoughtworks.proxy.toys.hotswap.HotSwappingInvoker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FailoverInvoker
extends HotSwappingInvoker {
    private final Object[] delegates;
    private final Class exceptionClass;
    private int current;
    private Object currentProxy;

    public FailoverInvoker(Class[] types, ProxyFactory proxyFactory, Object[] delegates, Class exceptionClass) {
        super(types, proxyFactory, new SimpleReference(delegates[0]), true);
        this.delegates = delegates;
        this.exceptionClass = exceptionClass;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.currentProxy = proxy;
        return super.invoke(proxy, method, args);
    }

    protected Object invokeOnDelegate(Method method, Object[] args) throws Throwable {
        Object result = null;
        try {
            result = super.invokeOnDelegate(method, args);
        }
        catch (InvocationTargetException e) {
            if (this.exceptionClass.isInstance(e.getTargetException())) {
                HotSwappingInvoker hiding = (HotSwappingInvoker)this.proxyFactory.getInvoker(this.currentProxy);
                ++this.current;
                this.current %= this.delegates.length;
                hiding.hotswap(this.delegates[1]);
                result = super.invokeOnDelegate(method, args);
            }
            throw e;
        }
        return result;
    }
}

