/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import zmq.Config;
import zmq.Decoder;
import zmq.DecoderBase;
import zmq.Encoder;
import zmq.EncoderBase;
import zmq.IEngine;
import zmq.IMsgSink;
import zmq.IMsgSource;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Msg;
import zmq.Options;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.Transfer;
import zmq.Utils;
import zmq.V1Decoder;
import zmq.V1Encoder;
import zmq.ZError;

public class StreamEngine
implements IEngine,
IPollEvents,
IMsgSink {
    private static final int GREETING_SIZE = 12;
    private boolean io_enabled;
    private SocketChannel handle;
    private ByteBuffer inbuf;
    private int insize;
    private DecoderBase decoder;
    private Transfer outbuf;
    private int outsize;
    private EncoderBase encoder;
    private boolean handshaking;
    private final ByteBuffer greeting;
    private final ByteBuffer greeting_output_buffer;
    private SessionBase session;
    private Options options;
    private String endpoint;
    private boolean plugged;
    private boolean terminating;
    private SocketBase socket;
    private IOObject io_object;

    public StreamEngine(SocketChannel fd_, Options options_, String endpoint_) {
        this.handle = fd_;
        this.inbuf = null;
        this.insize = 0;
        this.io_enabled = false;
        this.outbuf = null;
        this.outsize = 0;
        this.handshaking = true;
        this.session = null;
        this.options = options_;
        this.plugged = false;
        this.terminating = false;
        this.endpoint = endpoint_;
        this.socket = null;
        this.greeting = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        this.greeting_output_buffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        this.encoder = null;
        this.decoder = null;
        try {
            Utils.unblock_socket(this.handle);
            if (this.options.sndbuf != 0) {
                this.handle.socket().setSendBufferSize(this.options.sndbuf);
            }
            if (this.options.rcvbuf != 0) {
                this.handle.socket().setReceiveBufferSize(this.options.rcvbuf);
            }
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    private DecoderBase new_decoder(int size, long max, SessionBase session, int version2) {
        if (this.options.decoder == null) {
            if (version2 == 1) {
                return new V1Decoder(size, max, session);
            }
            return new Decoder(size, max);
        }
        try {
            if (version2 == 0) {
                Constructor<? extends DecoderBase> dcon = this.options.decoder.getConstructor(Integer.TYPE, Long.TYPE);
                return dcon.newInstance(size, max);
            }
            Constructor<? extends DecoderBase> dcon = this.options.decoder.getConstructor(Integer.TYPE, Long.TYPE, IMsgSink.class, Integer.TYPE);
            return dcon.newInstance(size, max, session, version2);
        }
        catch (SecurityException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (InvocationTargetException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (InstantiationException e) {
            throw new ZError.InstantiationException(e);
        }
    }

    private EncoderBase new_encoder(int size, SessionBase session, int version2) {
        if (this.options.encoder == null) {
            if (version2 == 1) {
                return new V1Encoder(size, session);
            }
            return new Encoder(size);
        }
        try {
            if (version2 == 0) {
                Constructor<? extends EncoderBase> econ = this.options.encoder.getConstructor(Integer.TYPE);
                return econ.newInstance(size);
            }
            Constructor<? extends EncoderBase> econ = this.options.encoder.getConstructor(Integer.TYPE, IMsgSource.class, Integer.TYPE);
            return econ.newInstance(size, session, version2);
        }
        catch (SecurityException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (InvocationTargetException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ZError.InstantiationException(e);
        }
        catch (InstantiationException e) {
            throw new ZError.InstantiationException(e);
        }
    }

    public void destroy() {
        assert (!this.plugged);
        if (this.handle != null) {
            try {
                this.handle.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.handle = null;
        }
    }

    @Override
    public void plug(IOThread io_thread_, SessionBase session_) {
        assert (!this.plugged);
        this.plugged = true;
        assert (this.session == null);
        assert (session_ != null);
        this.session = session_;
        this.socket = this.session.get_soket();
        this.io_object = new IOObject(null);
        this.io_object.set_handler(this);
        this.io_object.plug(io_thread_);
        this.io_object.add_fd(this.handle);
        this.io_enabled = true;
        this.greeting_output_buffer.put((byte)-1);
        this.greeting_output_buffer.putLong(this.options.identity_size + 1);
        this.greeting_output_buffer.put((byte)127);
        this.io_object.set_pollin(this.handle);
        boolean custom = false;
        try {
            custom = this.options.encoder != null && this.options.encoder.getDeclaredField("RAW_ENCODER") != null;
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        if (!custom) {
            this.outsize = this.greeting_output_buffer.position();
            this.greeting_output_buffer.flip();
            this.outbuf = new Transfer.ByteBufferTransfer(this.greeting_output_buffer);
            this.io_object.set_pollout(this.handle);
        }
        this.in_event();
    }

    private void unplug() {
        assert (this.plugged);
        this.plugged = false;
        if (this.io_enabled) {
            this.io_object.rm_fd(this.handle);
            this.io_enabled = false;
        }
        this.io_object.unplug();
        if (this.encoder != null) {
            this.encoder.set_msg_source(null);
        }
        if (this.decoder != null) {
            this.decoder.set_msg_sink(null);
        }
        this.session = null;
    }

    @Override
    public void terminate() {
        if (!this.terminating && this.encoder != null && this.encoder.has_data()) {
            this.terminating = true;
            return;
        }
        this.unplug();
        this.destroy();
    }

    @Override
    public void in_event() {
        int processed;
        if (this.handshaking && !this.handshake()) {
            return;
        }
        assert (this.decoder != null);
        boolean disconnection = false;
        if (this.insize == 0) {
            this.inbuf = this.decoder.get_buffer();
            this.insize = this.read(this.inbuf);
            this.inbuf.flip();
            if (this.insize == -1) {
                this.insize = 0;
                disconnection = true;
            }
        }
        if ((processed = this.decoder.process_buffer(this.inbuf, this.insize)) == -1) {
            disconnection = true;
        } else {
            if (processed < this.insize) {
                this.io_object.reset_pollin(this.handle);
            }
            this.insize -= processed;
        }
        this.session.flush();
        if (disconnection) {
            if (this.decoder.stalled()) {
                this.io_object.rm_fd(this.handle);
                this.io_enabled = false;
            } else {
                this.error();
            }
        }
    }

    @Override
    public void out_event() {
        int nbytes;
        if (this.outsize == 0) {
            if (this.encoder == null) {
                assert (this.handshaking);
                return;
            }
            this.outbuf = this.encoder.get_data(null);
            this.outsize = this.outbuf.remaining();
            if (this.outbuf.remaining() == 0) {
                this.io_object.reset_pollout(this.handle);
                if (this.encoder.is_error()) {
                    this.error();
                }
                return;
            }
        }
        if ((nbytes = this.write(this.outbuf)) == -1) {
            this.io_object.reset_pollout(this.handle);
            if (this.terminating) {
                this.terminate();
            }
            return;
        }
        this.outsize -= nbytes;
        if (this.handshaking && this.outsize == 0) {
            this.io_object.reset_pollout(this.handle);
        }
        if (this.outsize == 0) {
            if (this.encoder != null && this.encoder.is_error()) {
                this.error();
                return;
            }
            if (this.terminating) {
                this.terminate();
            }
        }
    }

    @Override
    public void connect_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timer_event(int id_) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void activate_out() {
        this.io_object.set_pollout(this.handle);
        this.out_event();
    }

    @Override
    public void activate_in() {
        if (!this.io_enabled) {
            this.decoder.process_buffer(this.inbuf, 0);
            assert (!this.decoder.stalled());
            this.session.flush();
            this.error();
            return;
        }
        this.io_object.set_pollin(this.handle);
        this.io_object.in_event();
    }

    private boolean handshake() {
        assert (this.handshaking);
        while (this.greeting.position() < 12) {
            int n = this.read(this.greeting);
            if (n == -1) {
                this.error();
                return false;
            }
            if (n == 0) {
                return false;
            }
            if ((this.greeting.get(0) & 0xFF) != 255) break;
            if (this.greeting.position() < 10) continue;
            if ((this.greeting.get(9) & 1) == 0) break;
            if (this.greeting_output_buffer.limit() >= 12) continue;
            if (this.outsize == 0) {
                this.io_object.set_pollout(this.handle);
            }
            int pos = this.greeting_output_buffer.position();
            this.greeting_output_buffer.position(10).limit(12);
            this.greeting_output_buffer.put((byte)1);
            this.greeting_output_buffer.put((byte)this.options.type);
            this.greeting_output_buffer.position(pos);
            this.outsize += 2;
        }
        int version_pos = 10;
        if ((this.greeting.get(0) & 0xFF) != 255 || (this.greeting.get(9) & 1) == 0) {
            this.encoder = this.new_encoder(Config.OUT_BATCH_SIZE.getValue(), null, 0);
            this.encoder.set_msg_source(this.session);
            this.decoder = this.new_decoder(Config.IN_BATCH_SIZE.getValue(), this.options.maxmsgsize, null, 0);
            this.decoder.set_msg_sink(this.session);
            int header_size = this.options.identity_size + 1 >= 255 ? 10 : 2;
            ByteBuffer tmp = ByteBuffer.allocate(header_size);
            this.encoder.get_data(tmp);
            assert (tmp.remaining() == header_size);
            this.inbuf = this.greeting;
            this.greeting.flip();
            this.insize = this.greeting.remaining();
            if (this.options.type == 1 || this.options.type == 9) {
                this.decoder.set_msg_sink(this);
            }
        } else if (this.greeting.get(10) == 0) {
            this.encoder = this.new_encoder(Config.OUT_BATCH_SIZE.getValue(), null, 0);
            this.encoder.set_msg_source(this.session);
            this.decoder = this.new_decoder(Config.IN_BATCH_SIZE.getValue(), this.options.maxmsgsize, null, 0);
            this.decoder.set_msg_sink(this.session);
        } else {
            this.encoder = this.new_encoder(Config.OUT_BATCH_SIZE.getValue(), this.session, 1);
            this.decoder = this.new_decoder(Config.IN_BATCH_SIZE.getValue(), this.options.maxmsgsize, this.session, 1);
        }
        if (this.outsize == 0) {
            this.io_object.set_pollout(this.handle);
        }
        this.handshaking = false;
        return true;
    }

    @Override
    public int push_msg(Msg msg_) {
        assert (this.options.type == 1 || this.options.type == 9);
        int rc = this.session.push_msg(msg_);
        assert (rc == 0);
        msg_ = new Msg(new byte[]{1});
        rc = this.session.push_msg(msg_);
        this.session.flush();
        assert (this.decoder != null);
        this.decoder.set_msg_sink(this.session);
        return rc;
    }

    private void error() {
        assert (this.session != null);
        this.socket.event_disconnected(this.endpoint, this.handle);
        this.session.detach();
        this.unplug();
        this.destroy();
    }

    private int write(Transfer buf) {
        int nbytes = 0;
        try {
            nbytes = buf.transferTo(this.handle);
        }
        catch (IOException e) {
            return -1;
        }
        return nbytes;
    }

    private int read(ByteBuffer buf) {
        int nbytes = 0;
        try {
            nbytes = this.handle.read(buf);
        }
        catch (IOException e) {
            return -1;
        }
        return nbytes;
    }
}

