/*
 * Decompiled with CFR 0.152.
 */
package org.tango.utils;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tango.utils.DevFailedUtils;

public final class TangoUtil {
    public static final String DEVICE_SEPARATOR = "/";
    public static final int FULL_NAME_NR_SEPARATOR = 3;
    public static final String DEVICE_PATTERN = "*";
    public static final List<Integer> SCALARS;
    public static final List<Integer> SPECTRUMS;
    public static final Map<String, AttrWriteType> WRITABLE_MAP;
    public static final Map<String, AttrDataFormat> FORMAT_MAP;
    public static final Map<String, Integer> TYPE_MAP;
    public static final String DBASE_NO = "#dbase=no";
    private static final Pattern ENTITY_SPLIT_PATTERN;
    private static final int PREFIX_INDEX = 1;
    private static final int ATTRIBUTE_ALIAS_INDEX = 2;
    private static final int DEVICE_NAME_INDEX = 3;
    private static final int DEVICE_ALIAS_INDEX = 4;
    private static final int ENTITY_INDEX = 5;
    private static final int NO_DB_INDEX = 6;

    private TangoUtil() {
    }

    public static final Map.Entry<String, String> splitDeviceEntity(String entityName) throws DevFailed {
        AbstractMap.SimpleEntry<Object, Object> result = null;
        Matcher matcher = ENTITY_SPLIT_PATTERN.matcher(entityName.trim());
        if (matcher.matches()) {
            boolean noDb;
            String device = null;
            String entity = null;
            String prefixGroup = matcher.group(1);
            boolean bl = noDb = matcher.group(6) != null;
            if (noDb) {
                if (matcher.group(3) != null && matcher.group(5) != null) {
                    String deviceNameGroup = matcher.group(3);
                    String entityGroup = matcher.group(5);
                    device = prefixGroup + deviceNameGroup;
                    entity = entityGroup;
                }
            } else if (matcher.group(2) != null) {
                String attributeAliasGroup = matcher.group(2);
                String fullAttributeName = ApiUtil.get_db_obj().get_attribute_from_alias(attributeAliasGroup);
                int lastIndexOf = fullAttributeName.lastIndexOf(DEVICE_SEPARATOR);
                device = prefixGroup + fullAttributeName.substring(0, lastIndexOf);
                entity = fullAttributeName.substring(lastIndexOf + 1);
            } else if (matcher.group(4) != null) {
                String deviceAliasGroup = matcher.group(4);
                String entityGroup = matcher.group(5);
                String fullDeviceName = ApiUtil.get_db_obj().get_device_from_alias(deviceAliasGroup);
                device = prefixGroup + fullDeviceName;
                entity = entityGroup;
            } else {
                String deviceNameGroup = matcher.group(3);
                String entityGroup = matcher.group(5);
                device = prefixGroup + deviceNameGroup;
                entity = entityGroup;
            }
            if (device != null && entity != null) {
                result = new AbstractMap.SimpleEntry<Object, Object>(device, entity);
            }
        }
        return result;
    }

    public static Map<String, Collection<String>> splitDeviceEntities(Collection<String> entityNames) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (String entityName : entityNames) {
            try {
                Map.Entry<String, String> deviceEntity = TangoUtil.splitDeviceEntity(entityName);
                if (deviceEntity == null) continue;
                String device = deviceEntity.getKey();
                String entity = deviceEntity.getValue();
                if (device == null || entity == null) continue;
                HashSet<String> attributes = (HashSet<String>)result.get(device);
                if (attributes == null) {
                    attributes = new HashSet<String>();
                    result.put(device, attributes);
                }
                attributes.add(entity);
            }
            catch (DevFailed e) {}
        }
        return result;
    }

    public static String getfullDeviceNameForAttribute(String attributeName) throws DevFailed {
        String result;
        TangoUtil.checkNullOrEmptyString(attributeName);
        if (attributeName.contains(DBASE_NO)) {
            result = attributeName.substring(0, attributeName.lastIndexOf(DEVICE_SEPARATOR));
        } else {
            String[] fields = attributeName.split(DEVICE_SEPARATOR);
            if (fields.length == 1) {
                result = TangoUtil.getfullDeviceNameForAttribute(ApiUtil.get_db_obj().get_attribute_from_alias(fields[0]));
            } else if (fields.length == 2) {
                result = ApiUtil.get_db_obj().get_device_from_alias(fields[0]);
            } else if (fields.length == 4) {
                result = fields[0] + DEVICE_SEPARATOR + fields[1] + DEVICE_SEPARATOR + fields[2];
            } else {
                throw DevFailedUtils.newDevFailed("TANGO_WRONG_DATA_ERROR", "cannot retrieve device name");
            }
        }
        return result;
    }

    public static String getfullAttributeNameForAttribute(String attributeName) throws DevFailed {
        String result;
        TangoUtil.checkNullOrEmptyString(attributeName);
        if (attributeName.contains(DBASE_NO)) {
            result = attributeName;
        } else {
            String[] fields = attributeName.split(DEVICE_SEPARATOR);
            Database db = ApiUtil.get_db_obj();
            result = fields.length == 1 ? db.get_attribute_from_alias(fields[0]) : (fields.length == 2 ? db.get_device_from_alias(fields[0]) + DEVICE_SEPARATOR + fields[1] : attributeName);
        }
        return result;
    }

    public static String getFullDeviceNameForCommand(String commandName) throws DevFailed {
        TangoUtil.checkNullOrEmptyString(commandName);
        return TangoUtil.getfullNameForDevice(commandName.substring(0, commandName.lastIndexOf(47)));
    }

    public static void checkFullCommandName(String fullCommandName) throws DevFailed {
        TangoUtil.checkNullOrEmptyString(fullCommandName);
        if (!fullCommandName.contains(DBASE_NO) && StringUtils.countMatches((CharSequence)fullCommandName, DEVICE_SEPARATOR) != 3) {
            throw DevFailedUtils.newDevFailed(fullCommandName + " command must contains 4 fields");
        }
    }

    public static String getfullNameForDevice(String deviceName) throws DevFailed {
        TangoUtil.checkNullOrEmptyString(deviceName);
        String[] fields = deviceName.split(DEVICE_SEPARATOR);
        if (deviceName.contains(DBASE_NO) || fields.length != 1) {
            return deviceName;
        }
        Database db = ApiUtil.get_db_obj();
        return db.get_device_from_alias(fields[0]);
    }

    public static String[] getDevicesForPattern(String deviceNamePattern) throws DevFailed {
        String[] devices;
        TangoUtil.checkNullOrEmptyString(deviceNamePattern);
        if (!deviceNamePattern.contains(DEVICE_PATTERN)) {
            devices = new String[]{TangoUtil.getfullNameForDevice(deviceNamePattern)};
        } else {
            Database db = ApiUtil.get_db_obj();
            devices = db.get_device_exported(deviceNamePattern);
        }
        return devices;
    }

    public static String[] getDevicesForPattern(String deviceNamePattern, boolean exported) throws DevFailed {
        String[] devices;
        TangoUtil.checkNullOrEmptyString(deviceNamePattern);
        if (exported) {
            devices = TangoUtil.getDevicesForPattern(deviceNamePattern);
        } else if (!deviceNamePattern.contains(DEVICE_PATTERN)) {
            devices = new String[]{TangoUtil.getfullNameForDevice(deviceNamePattern)};
        } else {
            Database db = ApiUtil.get_db_obj();
            devices = db.get_device_list(deviceNamePattern);
        }
        return devices;
    }

    public static String getAttributeName(String fullname) throws DevFailed {
        String s = TangoUtil.getfullAttributeNameForAttribute(fullname);
        return s.substring(s.lastIndexOf(DEVICE_SEPARATOR) + 1);
    }

    private static void checkNullOrEmptyString(String s) throws DevFailed {
        if (s == null || s.isEmpty()) {
            throw DevFailedUtils.newDevFailed("string is null or empty");
        }
    }

    static {
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        tempList.add(1);
        tempList.add(5);
        tempList.add(4);
        tempList.add(3);
        tempList.add(2);
        tempList.add(22);
        tempList.add(7);
        tempList.add(6);
        tempList.add(8);
        tempList.add(22);
        tempList.add(24);
        tempList.add(23);
        tempList.add(28);
        tempList.add(19);
        SCALARS = Collections.unmodifiableList(tempList);
        ArrayList<Integer> tempList2 = new ArrayList<Integer>();
        tempList2.add(9);
        tempList2.add(10);
        tempList2.add(11);
        tempList2.add(12);
        tempList2.add(13);
        tempList2.add(14);
        tempList2.add(15);
        tempList2.add(16);
        tempList2.add(25);
        tempList2.add(26);
        SPECTRUMS = Collections.unmodifiableList(tempList2);
        HashMap<String, AttrWriteType> tmpMap1 = new HashMap<String, AttrWriteType>();
        tmpMap1.put(AttrWriteType.READ.toString(), AttrWriteType.READ);
        tmpMap1.put(AttrWriteType.READ_WITH_WRITE.toString(), AttrWriteType.READ_WITH_WRITE);
        tmpMap1.put(AttrWriteType.WRITE.toString(), AttrWriteType.WRITE);
        tmpMap1.put(AttrWriteType.READ_WRITE.toString(), AttrWriteType.READ_WRITE);
        WRITABLE_MAP = Collections.unmodifiableMap(tmpMap1);
        HashMap<String, AttrDataFormat> tmpMap2 = new HashMap<String, AttrDataFormat>();
        tmpMap2.put(AttrDataFormat.SCALAR.toString(), AttrDataFormat.SCALAR);
        tmpMap2.put(AttrDataFormat.SPECTRUM.toString(), AttrDataFormat.SPECTRUM);
        tmpMap2.put(AttrDataFormat.IMAGE.toString(), AttrDataFormat.IMAGE);
        tmpMap2.put(AttrDataFormat.FMT_UNKNOWN.toString(), AttrDataFormat.FMT_UNKNOWN);
        FORMAT_MAP = Collections.unmodifiableMap(tmpMap2);
        HashMap<String, Integer> tmpMap3 = new HashMap<String, Integer>();
        tmpMap3.put("VOID", 0);
        tmpMap3.put("BOOLEAN", 1);
        tmpMap3.put("SHORT", 2);
        tmpMap3.put("LONG", 3);
        tmpMap3.put("FLOAT", 4);
        tmpMap3.put("DOUBLE", 5);
        tmpMap3.put("USHORT", 6);
        tmpMap3.put("ULONG", 7);
        tmpMap3.put("STRING", 8);
        tmpMap3.put("STATE", 19);
        tmpMap3.put("CONST_STRING", 20);
        tmpMap3.put("CHAR", 21);
        tmpMap3.put("UCHAR", 22);
        tmpMap3.put("LONG64", 23);
        tmpMap3.put("ULONG64", 24);
        tmpMap3.put("INT", 27);
        tmpMap3.put("ENCODED", 28);
        TYPE_MAP = Collections.unmodifiableMap(tmpMap3);
        String nameR = "[\\w\\-\\.]+";
        String protocolR = "(?:(?:(?:tango|taco):)?//)";
        String hostPortR = "(?:[\\w\\-\\.]+:\\d+/)";
        String prefixR = "((?:(?:(?:tango|taco):)?//)?(?:[\\w\\-\\.]+:\\d+/)?)";
        String deviceAliasR = "([\\w\\-\\.]+)";
        String attributeAliasR = "([\\w\\-\\.]+)";
        String deviceR = "([\\w\\-\\.]+/[\\w\\-\\.]+/[\\w\\-\\.]+)";
        String attributeR = "(?:/([\\w\\-\\.]+))";
        String propertyR = "(?:->[\\w\\-\\.]+)?";
        String dbaseR = "(?:#dbase=(yes|(no)))?";
        String entityR = "((?:(?:(?:tango|taco):)?//)?(?:[\\w\\-\\.]+:\\d+/)?)(?:([\\w\\-\\.]+)|(?:(?:([\\w\\-\\.]+/[\\w\\-\\.]+/[\\w\\-\\.]+)|([\\w\\-\\.]+))(?:/([\\w\\-\\.]+))))(?:->[\\w\\-\\.]+)?(?:#dbase=(yes|(no)))?";
        ENTITY_SPLIT_PATTERN = Pattern.compile("((?:(?:(?:tango|taco):)?//)?(?:[\\w\\-\\.]+:\\d+/)?)(?:([\\w\\-\\.]+)|(?:(?:([\\w\\-\\.]+/[\\w\\-\\.]+/[\\w\\-\\.]+)|([\\w\\-\\.]+))(?:/([\\w\\-\\.]+))))(?:->[\\w\\-\\.]+)?(?:#dbase=(yes|(no)))?", 2);
    }
}

