/*
 * Decompiled with CFR 0.152.
 */
package org.tango.utils;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public final class ArrayUtils {
    public static final Map<Class<?>, Class<?>> OBJ_TO_PRIMITIVE = new HashMap();
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_OBJ;

    private ArrayUtils() {
    }

    public static final Object toPrimitiveArray(Object array) {
        if (!array.getClass().isArray()) {
            return array;
        }
        Class<?> clazz = OBJ_TO_PRIMITIVE.get(array.getClass().getComponentType());
        return ArrayUtils.setArray(clazz, array);
    }

    public static final Object toObjectArray(Object array) {
        if (!array.getClass().isArray()) {
            return array;
        }
        Class<?> clazz = PRIMITIVE_TO_OBJ.get(array.getClass().getComponentType());
        return ArrayUtils.setArray(clazz, array);
    }

    private static final Object setArray(Class<?> clazz, Object array) {
        Object result = array;
        if (clazz != null) {
            int length = Array.getLength(array);
            result = Array.newInstance(clazz, length);
            for (int i = 0; i < length; ++i) {
                Array.set(result, i, Array.get(array, i));
            }
        }
        return result;
    }

    public static String[] toStringArray(Object array) {
        int length = Array.getLength(array);
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Array.get(array, i).toString();
        }
        return result;
    }

    public static Object addAll(Object array1, Object array2) {
        Object joinedArray;
        if (array1 == null) {
            if (array2.getClass().isArray()) {
                joinedArray = array2;
            } else {
                joinedArray = Array.newInstance(array2.getClass(), 1);
                Array.set(joinedArray, 0, array2);
            }
        } else if (array2 == null) {
            if (array1.getClass().isArray()) {
                joinedArray = array1;
            } else {
                joinedArray = Array.newInstance(array1.getClass(), 1);
                Array.set(joinedArray, 0, array1);
            }
        } else {
            int length1 = 1;
            if (array1.getClass().isArray()) {
                length1 = Array.getLength(array1);
            }
            int length2 = 1;
            if (array2.getClass().isArray()) {
                length2 = Array.getLength(array2);
            }
            joinedArray = array1.getClass().isArray() ? Array.newInstance(array1.getClass().getComponentType(), length1 + length2) : Array.newInstance(array1.getClass(), length1 + length2);
            if (array1.getClass().isArray()) {
                System.arraycopy(array1, 0, joinedArray, 0, length1);
            } else {
                Array.set(joinedArray, 0, array1);
            }
            if (array2.getClass().isArray()) {
                System.arraycopy(array2, 0, joinedArray, length1, length2);
            } else {
                Array.set(joinedArray, length1, array2);
            }
        }
        return joinedArray;
    }

    public static Object from2DArrayToArray(Object array2D) {
        Object array = null;
        if (array2D.getClass().isArray()) {
            int lengthY = Array.getLength(array2D);
            if (Array.getLength(array2D) > 0) {
                Object firstLine = Array.get(array2D, 0);
                if (firstLine.getClass().isArray()) {
                    int lengthLineX = Array.getLength(firstLine);
                    Class<?> compType = firstLine.getClass().getComponentType();
                    array = Array.newInstance(compType, lengthY * lengthLineX);
                    if (lengthLineX > 0 && lengthY > 0) {
                        for (int y = 0; y < lengthY; ++y) {
                            Object line = Array.get(array2D, y);
                            System.arraycopy(line, 0, array, lengthLineX * y, lengthLineX);
                        }
                    }
                } else {
                    array = Array.newInstance(array2D.getClass().getComponentType(), Array.getLength(array2D));
                    System.arraycopy(array2D, 0, array, 0, Array.getLength(array2D));
                }
            } else {
                array = array2D.getClass().getComponentType().isArray() ? Array.newInstance(array2D.getClass().getComponentType().getComponentType(), Array.getLength(array2D)) : Array.newInstance(array2D.getClass().getComponentType(), Array.getLength(array2D));
            }
        } else {
            array = array2D;
        }
        return array;
    }

    public static int get2DArrayXDim(Object array2D) {
        int dimX = 0;
        if (Array.getLength(array2D) > 0) {
            dimX = Array.getLength(Array.get(array2D, 0));
        }
        return dimX;
    }

    public static int get2DArrayYDim(Object array2D) {
        return Array.getLength(array2D);
    }

    public static boolean checkDimensions(Object object, int dimX, int dimY) {
        boolean hasGoodDimensions = false;
        if (object != null) {
            if (object.getClass().isArray()) {
                if (Array.getLength(object) == 0 && dimX == 0) {
                    hasGoodDimensions = true;
                } else if (object.getClass().getComponentType().isArray()) {
                    Object line = Array.get(object, 0);
                    if (dimX * dimY == Array.getLength(object) * Array.getLength(line)) {
                        hasGoodDimensions = true;
                    }
                } else {
                    int length = Array.getLength(object);
                    if (dimX == length && dimY == 0) {
                        hasGoodDimensions = true;
                    } else if (dimX * dimY == length) {
                        hasGoodDimensions = true;
                    }
                }
            } else if (dimX == 1 && dimY == 0) {
                hasGoodDimensions = true;
            }
        }
        return hasGoodDimensions;
    }

    public static Object fromArrayTo2DArray(Object array, int dimX, int dimY) throws DevFailed {
        Object array2D = null;
        if (array.getClass().isArray()) {
            if (dimY > 0) {
                array2D = Array.newInstance(array.getClass().getComponentType(), dimY, dimX);
                for (int y = 0; y < dimY; ++y) {
                    Object line = Array.get(array2D, y);
                    System.arraycopy(array, y * dimX, line, 0, Array.getLength(line));
                }
            } else {
                array2D = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
                System.arraycopy(array, 0, array2D, 0, Array.getLength(array));
            }
        } else {
            array2D = array;
        }
        return array2D;
    }

    public static int[][] copyOf(int[][] nums) {
        int[][] copy = new int[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            int[] member = new int[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static double[][] copyOf(double[][] nums) {
        double[][] copy = new double[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            double[] member = new double[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static float[][] copyOf(float[][] nums) {
        float[][] copy = new float[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            float[] member = new float[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static long[][] copyOf(long[][] nums) {
        long[][] copy = new long[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            long[] member = new long[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static short[][] copyOf(short[][] nums) {
        short[][] copy = new short[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            short[] member = new short[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static byte[][] copyOf(byte[][] nums) {
        byte[][] copy = new byte[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            byte[] member = new byte[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static char[][] copyOf(char[][] nums) {
        char[][] copy = new char[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            char[] member = new char[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static boolean[][] copyOf(boolean[][] nums) {
        boolean[][] copy = new boolean[nums.length][];
        for (int i = 0; i < copy.length; ++i) {
            boolean[] member = new boolean[nums[i].length];
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static <T> T[][] copyOf(T[][] nums) {
        int lengthY = Array.getLength(nums);
        int lengthX = 0;
        if (Array.getLength(nums) > 0) {
            lengthX = Array.getLength(nums[0]);
        }
        Object[][] copy = (Object[][])Array.newInstance(nums.getClass().getComponentType().getComponentType(), lengthY, lengthX);
        for (int i = 0; i < copy.length; ++i) {
            Object[] member = (Object[])Array.newInstance(nums[i].getClass().getComponentType(), nums[i].length);
            System.arraycopy(nums[i], 0, member, 0, nums[i].length);
            copy[i] = member;
        }
        return copy;
    }

    public static Object deepCopyOf(Object array) {
        Object result = array;
        int lengthX = 0;
        if (array != null && array.getClass().isArray()) {
            int lengthY = Array.getLength(array);
            if (lengthY > 0) {
                Object firtLine = Array.get(array, 0);
                if (firtLine != null && firtLine.getClass().isArray()) {
                    lengthX = Array.getLength(firtLine);
                    result = Array.newInstance(firtLine.getClass().getComponentType(), lengthY, lengthX);
                } else {
                    result = Array.newInstance(array.getClass().getComponentType(), lengthY);
                }
            }
            ArrayUtils.deepCopy(array, result);
        }
        return result;
    }

    private static void deepCopy(Object source, Object dest) {
        int length;
        if (source != null && (length = Array.getLength(source)) > 0) {
            Object firstline = Array.get(source, 0);
            if (firstline != null && firstline.getClass().isArray()) {
                for (int i = 0; i < length; ++i) {
                    ArrayUtils.deepCopy(Array.get(source, i), Array.get(dest, i));
                }
            } else {
                System.arraycopy(source, 0, dest, 0, length);
            }
        }
    }

    static {
        OBJ_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        OBJ_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        OBJ_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        OBJ_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        OBJ_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        OBJ_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        OBJ_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        OBJ_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        PRIMITIVE_TO_OBJ = new HashMap();
        PRIMITIVE_TO_OBJ.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_OBJ.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_OBJ.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_OBJ.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_OBJ.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_OBJ.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_OBJ.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_OBJ.put(Double.TYPE, Double.class);
    }
}

