/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.monitoring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tango.server.Chronometer;
import org.tango.server.monitoring.TangoMXBean;

public class TangoStats
implements TangoMXBean {
    private static final int MAX_CHRONO = 1000;
    private static final int DURATION = 1000;
    private final Chronometer periodChrono = new Chronometer();
    private final Map<Long, Chronometer> chronoMap = new ConcurrentHashMap<Long, Chronometer>();
    private String serverName = "";
    private volatile long seqNumber = 0L;
    private volatile String lastRequest = "";
    private volatile long requestsPerSecond = 0L;
    private volatile long minRequestsPerSecond = 0L;
    private volatile long maxRequestsPerSecond = 0L;
    private volatile long averageRequestsPerSecond = 0L;
    private volatile long totalRequestsPerSecond = 0L;
    private volatile long requestsPerSecondTemp = 0L;
    private volatile long lastRequestDuration = 0L;
    private volatile long minRequestDuration = Long.MAX_VALUE;
    private volatile long maxRequestDuration = Long.MIN_VALUE;
    private volatile long averageRequestDuration = 0L;
    private volatile long totalRequestDuration = 0L;
    private volatile String maxRequest = "";
    private volatile long errorNr = 0L;
    private static final TangoStats INSTANCE = new TangoStats();

    public static TangoStats getInstance() {
        return INSTANCE;
    }

    private TangoStats() {
    }

    @Override
    public void resetStats() {
        this.seqNumber = 0L;
        this.lastRequest = "";
        this.requestsPerSecond = 0L;
        this.minRequestsPerSecond = 0L;
        this.maxRequestsPerSecond = 0L;
        this.averageRequestsPerSecond = 0L;
        this.totalRequestsPerSecond = 0L;
        this.requestsPerSecondTemp = 0L;
        this.lastRequestDuration = 0L;
        this.minRequestDuration = Long.MAX_VALUE;
        this.maxRequestDuration = Long.MIN_VALUE;
        this.maxRequest = "";
        this.averageRequestDuration = 0L;
        this.totalRequestDuration = 0L;
        this.errorNr = 0L;
        this.chronoMap.clear();
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getLastRequest() {
        return this.lastRequest;
    }

    @Override
    public long getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    private synchronized long getNextSeqNumber() {
        return this.seqNumber++;
    }

    public long addRequest(String lastRequest) {
        this.lastRequest = lastRequest;
        Chronometer chrono = new Chronometer();
        chrono.start();
        long id = this.getNextSeqNumber();
        if (this.chronoMap.size() > 1000) {
            this.resetStats();
        }
        this.chronoMap.put(id, chrono);
        if (this.periodChrono.isOver()) {
            this.requestsPerSecond = this.requestsPerSecondTemp;
            this.requestsPerSecondTemp = 0L;
            this.periodChrono.start(1000L);
        } else {
            ++this.requestsPerSecondTemp;
        }
        return id;
    }

    public long getSeqNumber() {
        return this.seqNumber;
    }

    public void endRequest(long id) {
        Chronometer chrono = this.chronoMap.get(id);
        if (chrono != null) {
            this.lastRequestDuration = chrono.getElapsedTime();
            this.chronoMap.remove(id);
            if (this.lastRequestDuration < this.minRequestDuration) {
                this.minRequestDuration = this.lastRequestDuration;
            } else if (this.lastRequestDuration > this.maxRequestDuration) {
                this.maxRequestDuration = this.lastRequestDuration;
                this.maxRequest = this.lastRequest;
            }
            this.totalRequestDuration += this.lastRequestDuration;
            this.averageRequestDuration = this.totalRequestDuration / this.getSeqNumber();
            if (this.requestsPerSecond < this.minRequestsPerSecond) {
                this.minRequestsPerSecond = this.requestsPerSecond;
            } else if (this.requestsPerSecond > this.maxRequestsPerSecond) {
                this.maxRequestsPerSecond = this.requestsPerSecond;
            }
            this.totalRequestsPerSecond += this.requestsPerSecond;
            this.averageRequestsPerSecond = this.totalRequestsPerSecond / this.getSeqNumber();
        }
    }

    @Override
    public long getLastRequestDuration() {
        return this.lastRequestDuration;
    }

    @Override
    public String getMaxRequest() {
        return this.maxRequest;
    }

    @Override
    public long getMaxRequestDuration() {
        return this.maxRequestDuration;
    }

    @Override
    public long getMinRequestDuration() {
        return this.minRequestDuration;
    }

    @Override
    public long getAverageRequestDuration() {
        return this.averageRequestDuration;
    }

    public void addError() {
        ++this.errorNr;
    }

    @Override
    public long getErrorNr() {
        return this.errorNr;
    }

    @Override
    public long getMaxRequestsPerSecond() {
        return this.maxRequestsPerSecond;
    }

    @Override
    public long getAverageRequestsPerSecond() {
        return this.averageRequestsPerSecond;
    }

    @Override
    public long getMinRequestsPerSecond() {
        return this.minRequestsPerSecond;
    }
}

