/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.idl;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrValUnion;
import fr.esrf.Tango.AttributeDataType;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.tango.attribute.AttributeTangoType;
import org.tango.utils.ArrayUtils;
import org.tango.utils.DevFailedUtils;

public final class CleverAttrValUnion {
    private static final Map<AttributeDataType, String> METHOD_MAP = new HashMap<AttributeDataType, String>();
    private static final Map<AttributeDataType, Class<?>> PARAM_MAP;

    private CleverAttrValUnion() {
    }

    public static Object get(AttrValUnion union, AttrDataFormat format) throws DevFailed {
        Object result = null;
        if (union != null) {
            AttributeDataType discriminator = union.discriminator();
            if (discriminator.value() == 14) {
                throw DevFailedUtils.newDevFailed("there is not data");
            }
            try {
                Method method = union.getClass().getMethod(METHOD_MAP.get(discriminator), new Class[0]);
                result = method.invoke((Object)union, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                throw DevFailedUtils.newDevFailed(e.getCause());
            }
            catch (SecurityException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (NoSuchMethodException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            if (format.equals(AttrDataFormat.SCALAR) && !discriminator.equals(AttributeDataType.DEVICE_STATE)) {
                result = Array.get(result, 0);
            }
        }
        return result;
    }

    public static AttrValUnion set(int tangoType, Object value) throws DevFailed {
        AttributeDataType discriminator = AttributeTangoType.getTypeFromTango(tangoType).getAttributeDataType();
        AttrValUnion union = new AttrValUnion();
        Object array = null;
        if (value.getClass().isArray()) {
            array = ArrayUtils.toPrimitiveArray(value);
        } else {
            array = Array.newInstance(AttributeTangoType.getTypeFromTango(tangoType).getType(), 1);
            try {
                Array.set(array, 0, value);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed("API_AttrOptProp", value.getClass().getCanonicalName() + " is not of the good type");
            }
        }
        try {
            Method method = union.getClass().getMethod(METHOD_MAP.get(discriminator), PARAM_MAP.get(discriminator));
            method.invoke((Object)union, array);
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed("API_AttrOptProp", value.getClass().getCanonicalName() + " is not of the good type");
        }
        catch (IllegalAccessException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        catch (InvocationTargetException e) {
            throw DevFailedUtils.newDevFailed(e.getCause());
        }
        catch (SecurityException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        catch (NoSuchMethodException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        return union;
    }

    static {
        METHOD_MAP.put(AttributeDataType.ATT_BOOL, "bool_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_SHORT, "short_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_USHORT, "ushort_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_LONG, "long_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_ULONG, "ulong_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_LONG64, "long64_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_ULONG64, "ulong64_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_FLOAT, "float_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_DOUBLE, "double_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_STRING, "string_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_STATE, "state_att_value");
        METHOD_MAP.put(AttributeDataType.DEVICE_STATE, "dev_state_att");
        METHOD_MAP.put(AttributeDataType.ATT_UCHAR, "uchar_att_value");
        METHOD_MAP.put(AttributeDataType.ATT_ENCODED, "encoded_att_value");
        PARAM_MAP = new HashMap();
        PARAM_MAP.put(AttributeDataType.ATT_BOOL, boolean[].class);
        PARAM_MAP.put(AttributeDataType.ATT_SHORT, short[].class);
        PARAM_MAP.put(AttributeDataType.ATT_USHORT, short[].class);
        PARAM_MAP.put(AttributeDataType.ATT_LONG, int[].class);
        PARAM_MAP.put(AttributeDataType.ATT_ULONG, int[].class);
        PARAM_MAP.put(AttributeDataType.ATT_LONG64, long[].class);
        PARAM_MAP.put(AttributeDataType.ATT_ULONG64, long[].class);
        PARAM_MAP.put(AttributeDataType.ATT_FLOAT, float[].class);
        PARAM_MAP.put(AttributeDataType.ATT_DOUBLE, double[].class);
        PARAM_MAP.put(AttributeDataType.ATT_STRING, String[].class);
        PARAM_MAP.put(AttributeDataType.ATT_STATE, DevState[].class);
        PARAM_MAP.put(AttributeDataType.DEVICE_STATE, DevState.class);
        PARAM_MAP.put(AttributeDataType.ATT_UCHAR, byte[].class);
        PARAM_MAP.put(AttributeDataType.ATT_ENCODED, DevEncoded[].class);
    }
}

